<?php

// Redfinition du temps d'excution maximum
@set_time_limit(0);	 
	
$titre = "Adaptation des fichiers de la version 2.*  3.0";

include ('header.php');

// On modifie le format du fichier //
if ($_GET['file'])
{
	$fichier = gzopen($repertoire."/".$_GET['file'], 'r');
	$contents = '';
	while (!gzeof($fichier)) 
		$contents .= gzgets($fichier);
	gzclose($fichier); 

	$separator = '/;/';
	$new_separator = ';';
	
	// On change le format
	$save = str_replace($separator, $new_separator, $contents);	
	$save = preg_replace("/MyKtools v2\.[0-6]/", "Myktools v3.0", $save);
	
	// On rcup l'extension
	$ext_tab = explode('.', $_GET['file']);
	$nb_ext = count($ext_tab);
	if ($nb_ext >= 3)
		$save = gzencode($save, 9);
	
	// Cration du fichier
	if (!$fichier = fopen($repertoire.'/'.$_GET['file'], 'w+')) 
	{
		echo $lang['open_no'].$fichier;
		include ('footer.php');
		exit();
	}

	// Ecriture dans le fichier
	if (fwrite($fichier, $save) === FALSE) 
	{
    	echo $lang['write_no'].$file;
		include ('footer.php');
		exit();
	}	
	fclose($fichier);
	echo $lang['modif_success'];
}

// Vrifie que c'est un fichier en .sql .sql.gz
function authorized_file ($name)
{
	$ext = strrchr($name, '.');
	if ($ext == ".sql")
		return true;
	else if ($ext == ".gz")
	{
		$ext = substr ($name, 0, strpos($name, ".gz"));
		$ext = strrchr($ext, '.');
		if ($ext == ".sql")
			return true;
		else
			return false;
	}
	else
		return false;
}
	
$files = preg_find('/./', $repertoire, PREG_FIND_SORTMODIFIED | PREG_FIND_RETURNASSOC | PREG_FIND_SORTDESC);
if ($files != 42)
{
	echo '<table align="center" class="table_other2"><tr><td align="center"><strong>'.$lang['name_list'].'</strong></td><td align="center"><strong>'.$lang['operation_list'].'</strong></td></tr>';
	foreach($files as $element)
	{
		$element = $element["basename"];
		
		$fichier = gzopen($repertoire."/".$element, 'r');
		$contents = '';
		while (!gzeof($fichier)) 
			$contents .= gzgets($fichier);
		gzclose($fichier); 
		
			
		if (authorized_file($element) && preg_match("/MyKtools v2/", $contents))
		{
			
			// Nom
			echo '<tr><td align="center">'.$element.'</td>';
			// Oprations //
			echo '<td align="center"><a href="change_old.php?file='.$element.'">'.$lang['chang_format'].'</a></td></tr>';
		}
	}

	// Affiche les totaux
	echo '</table>';
}
else
	echo $lang['inaccess_rep'];
						
include ('footer.php');

?>