<?php

function security($login, $mdp) 
{
	global $lang;
	
	$var1 = false;
	$var2 = false;
	
	if (isset($_COOKIE['mdp_myktools']) && ($_COOKIE['mdp_myktools'] == $mdp)
		&& isset($_COOKIE['login_myktools']) && ($_COOKIE['login_myktools'] == $login)) 
	{ 
		setcookie("mdp_myktools", $_COOKIE['mdp_myktools'], time() + (720 * 3600));
		setcookie("login_myktools", $_COOKIE['login_myktools'], time() + (720 * 3600));
		$var1 = true;
	}
	 
	if (sha1($_POST['mdp']) == $mdp && $_POST['login'] == $login) 
	{ 
		setcookie("mdp_myktools", sha1($_POST['mdp']), time() + (720 * 3600));
		setcookie("login_myktools", $_POST['login'], time() + (720 * 3600));
		$var2 = true;
	}

	if (!$var1 && !$var2)
	{

		echo '<form action="index.php" method="post">
		<input type="hidden" name="protection" value="yes" />';
		if ($_POST['mdp'])
			echo '<strong>Mot de passe incorrect !</strong><br /><br />';
		echo $lang['please_secur']."<br /><br />";
		echo $lang['login'].' : <input type="text" name="login" size="15" /><br />
		'.$lang['mdp'].' : <input type="password" name="mdp" size="10" /><br />
		<input type="submit" value="Ok" name="submit" />
		</form>';
		return false;
	}
	else
		return true;
}

//////////////////////
// fonction timing //
/////////////////////

function getMicroTime() {
  $mt = microtime();
  list($micro, $time) = explode(' ', $mt);
  return ($micro + $time);
}

///////////////////////////////////////////////////////////
// Fonction qui transforme le nom du fichier en une date //
///////////////////////////////////////////////////////////

function name_to_date($name) 
{
	$name_tab = explode('-', $name);
	$annee = explode('.', $name_tab[4]);
	$retour = $name_tab[2].'/'.$name_tab[3].'/'.$annee[0];
	return $retour;
}

///////////////////////////////////////////////////////////////////////
// Fonction qui retourne la taille d'un fichier en multiple d'octets //
///////////////////////////////////////////////////////////////////////

function size_file($size)
{
  $i = 0;
  $iec = array(" o", " ko", " mo", " go");
  while (($size / 1024) > 1) 
  {
  	$size /= 1024;
   	++$i;
  }
  return substr($size, 0, strpos($size, '.') + 3).$iec[$i];
}


define('PREG_FIND_RECURSIVE', 1);
define('PREG_FIND_DIRMATCH', 2);
define('PREG_FIND_FULLPATH', 4);
define('PREG_FIND_NEGATE', 8);
define('PREG_FIND_DIRONLY', 16);
define('PREG_FIND_RETURNASSOC', 32);
define('PREG_FIND_SORTDESC', 64);
define('PREG_FIND_SORTKEYS', 128); 
define('PREG_FIND_SORTBASENAME', 256);   # requires PREG_FIND_RETURNASSOC
define('PREG_FIND_SORTMODIFIED', 512);   # requires PREG_FIND_RETURNASSOC
define('PREG_FIND_SORTFILESIZE', 1024);  # requires PREG_FIND_RETURNASSOC
define('PREG_FIND_SORTDISKUSAGE', 2048); # requires PREG_FIND_RETURNASSOC

// PREG_FIND_RECURSIVE   - go into subdirectorys looking for more files
// PREG_FIND_DIRMATCH    - return directorys that match the pattern also
// PREG_FIND_DIRONLY     - return only directorys that match the pattern (no files)
// PREG_FIND_FULLPATH    - search for the pattern in the full path (dir+file)
// PREG_FIND_NEGATE      - return files that don't match the pattern
// PREG_FIND_RETURNASSOC - Instead of just returning a plain array of matches,
//                         return an associative array with file stats
//
// You can also request to have the results sorted based on various criteria
// By default if any sorting is done, it will be sorted in ascending order.
// You can reverse this via use of:
// PREG_FIND_SORTDESC    - Reverse order of sort
// PREG_FILE_SORTKEYS    - Sort on the keyvalues or non-assoc array results
// The following sorts *require* PREG_FIND_RETURNASSOC to be used as they are
// sorting on values stored in the constructed associative array
// PREG_FIND_SORTBASENAME - Sort the results in alphabetical order on filename
// PREG_FIND_SORTMODIFIED - Sort the results in last modified timestamp order
// PREG_FIND_SORTFILESIZE  - Sort the results based on filesize
// PREG_FILE_SORTDISKUSAGE - Sort based on the amount of disk space taken
// to use more than one simply seperate them with a | character



// Search for files matching $pattern in $start_dir.
// if args contains PREG_FIND_RECURSIVE then do a recursive search
// return value is an associative array, the key of which is the path/file
// and the value is the stat of the file.
function preg_find($pattern, $start_dir='.', $args=NULL) 
{

	$files_matched = array();
	
	if ($fh = @opendir($start_dir))
	{
		while (($file = readdir($fh)) !== false)
		{
			if (strcmp($file, '.')==0 || strcmp($file, '..')==0) continue;
			$filepath = $start_dir . '/' . $file;
			if (preg_match($pattern, ($args & PREG_FIND_FULLPATH) ? $filepath : $file)) 
			{
				$doadd =    is_file($filepath)
				   || (is_dir($filepath) && ($args & PREG_FIND_DIRMATCH))
				   || (is_dir($filepath) && ($args & PREG_FIND_DIRONLY));
				if ($args & PREG_FIND_DIRONLY && $doadd && !is_dir($filepath)) $doadd = false;
				if ($args & PREG_FIND_NEGATE) $doadd = !$doadd;
				if ($doadd) 
				{
					if ($args & PREG_FIND_RETURNASSOC) 
					{ 
						// return more than just the filenames
						$fileres = array();
						if (function_exists('stat')) 
						{
							$fileres['stat'] = stat($filepath);
							$fileres['du'] = $fileres['stat']['blocks'] * 512;
						}
						if (function_exists('fileowner')) $fileres['uid'] = fileowner($filepath);
						if (function_exists('filegroup')) $fileres['gid'] = filegroup($filepath);
						if (function_exists('filetype')) $fileres['filetype'] = filetype($filepath);
						if (function_exists('mime_content_type')) $fileres['mimetype'] = mime_content_type($filepath);
						if (function_exists('dirname')) $fileres['dirname'] = dirname($filepath);
						if (function_exists('basename')) $fileres['basename'] = basename($filepath);
						if (isset($fileres['uid']) && function_exists('posix_getpwuid')) $fileres['owner'] = posix_getpwuid ($fileres['uid']);
						$files_matched[$filepath] = $fileres;
					} 
					else
					array_push($files_matched, $filepath);
				}
			}
			if ( is_dir($filepath) && ($args & PREG_FIND_RECURSIVE) ) 
			{
				$files_matched = array_merge($files_matched, preg_find($pattern, $filepath, $args));
			}
		}
		closedir($fh); 
	}
	else
		return (42);
	
	// Before returning check if we need to sort the results.
	if ($args & (PREG_FIND_SORTKEYS|PREG_FIND_SORTBASENAME|PREG_FIND_SORTMODIFIED|PREG_FIND_SORTFILESIZE|PREG_FIND_SORTDISKUSAGE)) 	{
		$order = ($args & PREG_FIND_SORTDESC) ? 1 : -1;
		$sortby = '';
		if ($args & PREG_FIND_RETURNASSOC) 
		{
			if ($args & PREG_FIND_SORTMODIFIED)  $sortby = "['stat']['mtime']";
			if ($args & PREG_FIND_SORTBASENAME)  $sortby = "['basename']";
			if ($args & PREG_FIND_SORTFILESIZE)  $sortby = "['stat']['size']";
			if ($args & PREG_FIND_SORTDISKUSAGE) $sortby = "['du']";
		}
		$filesort = create_function('$a,$b', "\$a1=\$a$sortby;\$b1=\$b$sortby; if (\$a1==\$b1) return 0; else return (\$a1<\$b1) ? $order : 0- $order;");
		uasort($files_matched, $filesort);
	}
	return $files_matched;
}
       
?>