<?php

// Redfinition du temps d'excution maximum
@set_time_limit(0);

// Nom du fichier gnr dynamiquement en fonction de la date
$date = date("d-m-Y",time());
$fichier = 'sauvegarde-'.$_GET['bdd'].'-'.$date.'.sql';

// On gzip si c'est demand sinon c'est un .sql normal
if ($zip == "true")
	$fichier = $fichier.".gz";
	
// Include du fichier des fonctions et du fichier de langue choisis //
include ('configuration/includes.php'); 

if (!security($login_sec, $mdp_sec))
	exit ();

// Envoie les en-tetes
header('Content-Type: application/octetstream');
header('Content-Disposition: filename="'.$fichier.'"');
header('Pragma: no-cache');
header('Expires: 0');

// Dpart chrono
$temps_depart = getMicroTime();

// Variables spcifiques
$separator = ';';

// Fonction d'erreur
function error ($message)
{
	echo $message;
	exit ();
}

// Vrification qu'on a slectionn une base de donnes et chargement
if (!$_GET['bdd'])
	error ($lang['error_hack']);
else if (!file_exists ("bdds/".$_GET['bdd'].".php"))
	error ($lang['error_hack']);
else
{
	$bdd = $_GET['bdd'];
	include ("bdds/".$bdd.".php");
}

// Base de donne informations
$info_bdd = "--\n-- ".$lang['db']." : `$bdd`\n--\n\n";
if ($creer == "true")
	$save = "--\n-- ".$lang['create_db']."\n--\nCREATE DATABASE `$bdd`".$separator."\n\n".$info_bdd;
else
	$save = $info_bdd;

// Connexion  la base de donne et slection de la base de donne
if (!($connexion = mysql_connect($serveur,$login,$mdp)))
	error ($lang['error_connexion']."<br />".mysql_error());

// Slection de la bdd
if (!mysql_select_db($bdd, $connexion))
	error ($lang['error_select']."<br />".mysql_error());

// Selection des tables  sauvegarder //

// Toutes les tables
if ($all_tables == "true")
{
	$alltable = mysql_list_tables($bdd, $connexion);
	$num = mysql_num_rows($alltable);
	// Vrification  la prsence d'au moins 1 table !
	if (empty($num))
		error ($lang['any_table']);
}
// Tables spcifiques
else
{
	$alltable = explode(";", $tables);
	$num = count ($alltable);
	// Vrification  la prsence d'au moins 1 table !
	if (!$num)
		error ($lang['any_table']);
}

/////////////////////////////////////////////////////////////////
// On effectue l'opration de sauvegarde sur toutes les tables //
/////////////////////////////////////////////////////////////////

for ($i = 0; $i < $num; $i++) 
{
	if ($all_tables == "true")
		$table = mysql_tablename($alltable, $i);
	else
		$table = $alltable[$i];

	// Importation de la structure de la table
	$qry_import_structure = 'SHOW CREATE TABLE `'.$table.'`';
	if (!($result = mysql_query($qry_import_structure,$connexion)))
		error (mysql_error($connexion));
	$qry_create = mysql_fetch_row($result);

	// Importation des lignes de la table et construction de l'INSERT
	$qry_import_lignes = 'SELECT * FROM `'.$table.'`';
	if (!($lignes = mysql_query($qry_import_lignes, $connexion)))
		error (mysql_error($connexion));

	// Nombres de champs
	$nbchamps = mysql_num_fields($lignes);

	// Ecriture de la table
	$save .= "\n--\n-- ".$lang['structure']." `$table`\n--\n\n";
	// Supprimer la table si existante
	if ($drop == "true")
	{
		$qry_drop = 'DROP TABLE IF EXISTS `'.$table.'`'.$separator;
		$save .= $qry_drop."\n";
	}
	// Crer la table
	if ($create == "true")
		$save .= $qry_create[1].$separator."\n\n";
	$save .= "--\n-- ".$lang['contents']." `$table`\n--\n\n";
	
	// Vrification de la prsence d'au moins 1 enregistrement dans la table ! //
	$nb_save = mysql_num_rows($lignes);
	if (!empty($nb_save))
	{
		$save .= "INSERT INTO `$table`";
		// Inscription des champs
		$save .= ' (';
		for($j = 0; $j < $nbchamps; $j++)
		{
			$save .= '`'.mysql_field_name($lignes, $j).'`';
			// Continue ou termine la chane
			if ($j == ($nbchamps - 1))
				$save .= ') ';
			else
				$save .= ', ';
		}
		// Gnration des enregistrements
		$save .= 'VALUES ';
		while ($row = mysql_fetch_row($lignes))
        {
        	if (isset($boucle_start))
				$save .= ",\n";
			else
				$boucle_start = '';
        	$values = '(\''.implode("','", array_map('mysql_real_escape_string', $row)).'\')';
        	$save .= $values;
        	++$nb;
        }
		$save .= $separator."\n";
		unset($boucle_start);
	}
	// Si 0 enregistrement on l'affiche !	
	else 
		$save .= "--\n-- ".$lang['any_data']." `$table`\n--\n"; // On l'crit dans le fichier
}

// On ferme la connexion
mysql_close($connexion);

////////////////////////////////////////////////////////////
// Fin de l'opration de sauvegarde sur toutes les tables //
///////////////////////////////////////////////////////////
// Temps
$temps = round(getMicroTime() - $temps_depart, 4);

// Informations finales
$save .= "\n--\n-- ".$lang['info']." \"$fichier\", $num table(s), $nb ".$lang['info2']." $temps s, date : $date\n--";
	
// On gzip si c'est demand sinon c'est un .sql normal
if ($zip == "true")
  	$save = gzencode($save, 9);	

echo $save;

// Ecrit le log //
$log = fopen("./logs/log-sauvegarde-".$bdd."-".$date.".txt", 'w+');
$log_txt = $lang['log_write']."$num table(s), $nb ".$lang['info2']." $temps s\n".$lang['log_success'];
fwrite($log, $log_txt);
fclose($log);
  
?>