<?php
// Redfinition du temps d'excution maximum
@set_time_limit(0);

// Rcupration des variables du formulaire
foreach($_POST as $key => $value)
{
	global $$key;
	$$key = $value;
}	 
	
$titre = "MyKlist - module de listage des fichiers de sauvegarde";

include ('header.php');

///////////////////////////
// Supression du fichier //
///////////////////////////

if ($_GET['act'] == "del")
{
	if (unlink($repertoire."/".$_GET['file']) === FALSE)
		echo $lang['no_del'].$fichier;
	else
		echo $lang['del'];
	echo '<br /><br />';
}

/////////////////////////
// Voir une sauvegarde //
/////////////////////////

if ($_GET['act'] == "see")
{
	include_once('colorateur/geshi.php');

	$fichier = gzopen($repertoire."/".$_GET['file'], 'r');
	$contents = '';
	while (!gzeof($fichier)) 
		$contents .= gzgets($fichier);
	gzclose($fichier); 

	$code = geshi_highlight($contents, 'sql', 'colorateur', true);
	
	echo '<table align="center" class="table_other2">
	<tr>
		<td align="center"><strong>'.$_GET['file'].'</strong></td>
		<td align="center">'.size_file(filesize($repertoire.'/'.$_GET['file'])).'</td>
		<td align="center">'.name_to_date($_GET['file']).'</td>
	</tr>
	<tr><td style="background:#FFFFFF;" align="left" colspan="3">'.$code.'</td></tr>
	</table>';	
}

/////////////////////////////
// Modifier une sauvegarde //
/////////////////////////////

// On modifie
if ($_POST['action'])
{
	$save = $_POST['sql'];

	// On rcup l'extension
	$ext_tab = explode('.', $_POST['file']);
	$nb_ext = count($ext_tab);
	if ($nb_ext >= 3)
		$save = gzencode($save, 9);
	
	// Cration du fichier
	if (!$fichier = fopen($repertoire.'/'.$_POST['file'], 'w+')) 
	{
		echo $lang['open_no'].$fichier;
		include ('footer.php');
		exit();
	}

	// Ecriture dans le fichier
	if (fwrite($fichier, $save) === FALSE) 
	{
    	echo $lang['write_no'].$file;
		include ('footer.php');
		exit();
	}
	
	fclose($fichier);
	echo $lang['modif_success'];
}

// Formulaire de modification
if ($_GET['act'] == "modify")
{
	$file = $_GET['file'];
	$fichier = gzopen($repertoire."/".$file, 'r');
	$contents = '';
	while (!gzeof($fichier)) 
		$contents .= gzgets($fichier);
	gzclose($fichier); 
	
	echo '<form name="MyKlist" method="post" action="myklist.php?act=modify&file='.$file.'">
	<input type="hidden" name="action" value="modif" />
	<input type="hidden" name="file" value="'.$file.'" />
	<table align="center" class="table_other2">
	<tr>
	<td align="center"><strong>'.$file.'</strong></td>
	<td align="center">'.size_file(filesize($repertoire.'/'.$file)).'</td>
	<td align="center">'.name_to_date($file).'</td>
	</tr>
	<tr><td align="left" colspan="3" style="background:#FFFFFF;"><textarea cols="65" rows="50" name="sql">'.$contents.'</textarea>	
	</td></tr>
	<tr><td align="center" colspan="3"><input type="submit" value="'.$lang['file_modif'].'" name="bouton" /></td></tr>
	</table>
	</form>';
}

/////////////////////////////////////////////////////
// Affichage des sauvegardes de la base de donnes //
/////////////////////////////////////////////////////

?>
<script language="javascript" type="text/javascript">
function alerte(act, file, size)
{
	if (size >= 250)
	{
		if (confirm("<?php echo $lang['file_alert']; ?>")) 
			window.open("myklist.php?act="+act+"&file="+escape(file));
	}
	else
		window.open("myklist.php?act="+act+"&file="+escape(file));
}
</script>
<?php

// Vrifie que c'est un fichier en .sql .sql.gz
function authorized_file ($name)
{
	$ext = strrchr($name, '.');
	if ($ext == ".sql")
		return true;
	else if ($ext == ".gz")
	{
		$ext = substr ($name, 0, strpos($name, ".gz"));
		$ext = strrchr($ext, '.');
		if ($ext == ".sql")
			return true;
		else
			return false;
	}
	else
		return false;
}

if ($_GET['act'] == "showall" || $_GET['act'] == "del")
{
	if (!$_GET['bdd'])
	{
		echo $lang['error_hack'];
		include ('footer.php');
		exit ();
	}
	
	$files = preg_find('/./', $repertoire, PREG_FIND_SORTMODIFIED | PREG_FIND_RETURNASSOC | PREG_FIND_SORTDESC);
	if ($files != 42)
	{
		echo '<table align="center" class="table_other2"><tr><td align="center"><strong>'.$lang['name_list'].'</strong></td><td align="center"><strong>'.$lang['date_list'].'</strong></td><td align="center"><strong>'.$lang['size_list'].'</strong></td><td align="center"><strong>'.$lang['operation_list'].'</strong></td></tr>';

		$nb_fichiers = 0;
		$taille_total = 0;
	
		foreach($files as $element)
		{
			$element = $element["basename"];
			$exp = explode('-', $element);
			
			if ($exp[1] == $_GET['bdd'] && authorized_file($element))
			{
				// Nom
				echo '<tr><td align="center">'.$element.'</td>';
				// Date
				echo '<td align="center">'.name_to_date($element).'</td>';
				// Taille
				$chemin = $repertoire.'/'.$element;
				$taille_total += filesize($chemin); 
				echo '<td align="center">'.size_file(filesize($chemin)).'</td>';
				// Oprations //
				echo '<td style="width:100px;padding-left: 20px">';
				// Tlcharger
				echo '<img src="./images/database_link.png" alt="" /> <a href="'.$repertoire.'/'.$element.'">'.$lang['download'].'</a><br />';
				// Supression
				echo '<img src="./images/database_delete.png" alt="" /> <a href="myklist.php?act=del&file='.$element.'&bdd='.$_GET['bdd'].'">'.$lang['suppr_list'].'</a><br />';
				// Restauration
				echo '<img src="./images/database_go.png" alt="" /> <a href="mykcreate.php?file='.$element.'&bdd='.$_GET['bdd'].'">'.$lang['recreate'].'</a><br />';
				// Afficher et Modifier //
				// Taille du fichier en ko
				$size = filesize($chemin)/1024;
				// Sparer le nom du fichier
				/*$ext = explode('.',$element);
				if (count($ext) > 2)
					$ext[1] = $ext[1].'.'.$ext[2];*/
			
				echo '<img src="./images/database.png" alt="" /> <a href="javascript:alerte(\'see\', \''.$element.'\', \''.$size.'\')">'.$lang['file_see'].'</a><br />';
				echo '<img src="./images/database_edit.png" alt="" /> <a href="javascript:alerte(\'modify\', \''.$element.'\', \''.$size.'\')")">'.$lang['file_modif'].'</a>';
			
				++$nb_fichiers;
			}
		}
	
		// Affiche les totaux
		echo '<tr><td colspan="4"><b>'.$lang['total_list'].'</b> '.$nb_fichiers.' '.$lang['nb_files'].' - '.size_file($taille_total).'</td></tr></table>';
	}
	else
		echo $lang['inaccess_rep'];
}
						
include ('footer.php');

?>