<?php

// Redfinition du temps d'excution maximum
@set_time_limit(0);
	 
$titre = "MyKsave - module de sauvegarde";

include ('header.php');

// Dpart chrono
$temps_depart = getMicroTime();

// Date actuelle
$date = date("d-m-Y",time());

// Variables spcifiques
$separator = ';';

// Fonction d'erreur
function error ($message)
{
	echo $message;
	include ('footer.php');
	exit ();
}

// Vrification qu'on a slectionn une base de donnes et chargement
if (!$_GET['bdd'])
	error ($lang['error_hack']);
else if (!file_exists ("bdds/".$_GET['bdd'].".php"))
	error ($lang['error_hack']);
else
{
	$bdd = $_GET['bdd'];
	include ("bdds/".$bdd.".php");
}

// Nom du fichier gnr dynamiquement en fonction de la date
$fichier = 'sauvegarde-'.$bdd.'-'.$date.'.sql';
	
// Base de donne informations / Temps
if (!$_GET['part'])
{

	$temps_depart_w = $temps_depart;
	$info_bdd = "--\n-- ".$lang['db']." : `$bdd`\n--\n\n";
	if ($creer == "true")
		$save = "--\n-- ".$lang['create_db']."\n--\nCREATE DATABASE `$bdd`".$separator."\n\n".$info_bdd;
	else
		$save = $info_bdd;
}
else
{
	$save = "";
	$temps_depart_w = $_GET['time'];
}

// Connexion  la base de donne et slection de la base de donne
if (!($connexion = mysql_connect($serveur,$login,$mdp)))
	error ($lang['error_connexion']."<br />".mysql_error());

// Slection de la bdd
if (!mysql_select_db($bdd, $connexion))
	error ($lang['error_select']."<br />".mysql_error());

// Selection des tables  sauvegarder //

// Toutes les tables
if ($all_tables == "true")
{
	$alltable = mysql_list_tables($bdd, $connexion);
	$num = mysql_num_rows($alltable);
	// Vrification  la prsence d'au moins 1 table !
	if (empty($num))
		error ($lang['any_table']);
}
// Tables spcifiques
else
{
	$alltable = explode(";", $tables);
	$num = count ($alltable);
	// Vrification  la prsence d'au moins 1 table !
	if (!$num)
		error ($lang['any_table']);
}

/////////////////////////////////////////////////////////////////
// On effectue l'opration de sauvegarde sur toutes les tables //
/////////////////////////////////////////////////////////////////

// Recherche la position de dpart pour la boucle des tables
if (!$_GET['part'])
{
	$i = 0;
	$nb = 0;
	$opt_file = 'w';
}
else
{
	$nb = $_GET['nb'];
	$i = $_GET['table'];
	$opt_file = 'a';
}

for (; $i < $num; ++$i) 
{
	if ($all_tables == "true")
		$table = mysql_tablename($alltable, $i);
	else
		$table = $alltable[$i];

	if (!$_GET['part']  || ($_GET['part'] && $i != $_GET['table']))
	{
		// Importation de la structure de la table
		$qry_import_structure = 'SHOW CREATE TABLE `'.$table.'`';
		if (!($result = mysql_query($qry_import_structure,$connexion)))
			error (mysql_error($connexion));
		$qry_create = mysql_fetch_row($result);
	
		// Ecriture de la table
		$save .= "\n--\n-- ".$lang['structure']." `$table`\n--\n\n";
		// Supprimer la table si existante
		if ($drop == "true")
		{
			$qry_drop = 'DROP TABLE IF EXISTS `'.$table.'`'.$separator;
			$save .= $qry_drop."\n";
		}
		// Crer la table
		if ($create == "true")
			$save .= $qry_create[1].$separator."\n\n";
		$save .= "--\n-- ".$lang['contents']." `$table`\n--\n\n";
	}
	
	// Importation des lignes de la table et construction de l'INSERT
	if (!$_GET['part'] || ($_GET['part'] && $i != $_GET['table']))
	{
		$k = 0;
		$qry_import_lignes = 'SELECT * FROM `'.$table.'`';
	}
	else
	{
		$k = $_GET['part'];
		$qry_import_lignes = 'SELECT * FROM `'.$table.'` LIMIT '.$_GET['part'].', 18446744073709551615';
	}
	if (!($lignes = mysql_query($qry_import_lignes, $connexion)))
		error (mysql_error($connexion));

	// Nombres de champs
	$nbchamps = mysql_num_fields($lignes);
	
	// Vrification de la prsence d'au moins 1 enregistrement dans la table ! //
	$nb_save = mysql_num_rows($lignes);
	
	if (!empty($nb_save))
	{
		if (!$_GET['part'] || ($_GET['part'] && $i != $_GET['table']))
		{
			$save .= "INSERT INTO `$table`";
			// Inscription des champs
			$save .= ' (';
			for($j = 0; $j < $nbchamps; ++$j)
			{
				$save .= '`'.mysql_field_name($lignes, $j).'`';
				// Continue ou termine la chane
				if ($j == ($nbchamps - 1))
					$save .= ') ';
				else
					$save .= ', ';
			}
			// Gnration des enregistrements
			$save .= 'VALUES ';
		}
		while ($row = mysql_fetch_row($lignes))
        {			
        	if (isset($boucle_start))
				$save .= ",\n";
			else
				$boucle_start = '';
        	$values = '(\''.implode("','", array_map('mysql_real_escape_string', $row)).'\')';
        	$save .= $values;
        	++$nb;
			++$k;
							
			// Gestion des grosses bases de donnes
			if (round(getMicroTime() - $temps_depart, 4) >= 25)
			{
				if ($k < $nb_save)
					$save .= ",\n";
				// On gzip si c'est demand sinon c'est un .sql normal
				if ($zip == "true")
				{
					$fichier = $fichier.".gz";
					$save = gzencode($save, 9);
				}
				// Cration du fichier
				if (!$file = fopen($repertoire."/".$fichier, $opt_file)) 
					error ($lang['open_no'].$fichier);
				
				// Ecriture dans le fichier
				if (fwrite($file, $save) === FALSE) 
					error ($lang['write_no'].$fichier);
					
				// On actualise la page avec les paramtres
				echo '<script language="javascript" type="text/javascript">
				<!--
				window.location.replace("myksave.php?bdd='.$bdd.'&part='.$k.'&table='.$i.'&nb='.$nb.'&time='.$temps_depart_w.'");
				-->
				</script>';
				exit ();
			}			
        }
		$save .= $separator."\n";
		unset($boucle_start);
	}
	// Si 0 enregistrement on l'affiche !	
	else 
	{
		echo $lang['any_data']." $table ...<br />"; // On l'affiche ...
	 	$save .= "--\n-- ".$lang['any_data']." `$table`\n--\n"; // On l'crit dans le fichier
	}
}

// On ferme la connexion !! //
mysql_close($connexion);

////////////////////////////////////////////////////////////
// Fin de l'opration de sauvegarde sur toutes les tables //
////////////////////////////////////////////////////////////

// Temps de fin
$temps = round(getMicroTime() - $temps_depart_w, 4);

// Informations finales
$save .= "\n--\n-- ".$lang['info']." \"$fichier\", $num table(s), $nb ".$lang['info2']." $temps s, date : $date\n--";

/////////////////////////////////////////////////////////////////
// Enregistrement de la base de donne dans un fichier texte ! //
/////////////////////////////////////////////////////////////////
	
// Creation du log
$log = fopen("./logs/log-sauvegarde-".$bdd."-".$date.".txt", 'w+');

// On gzip si c'est demand sinon c'est un .sql normal
if ($zip == "true")
{
	$fichier = $fichier.".gz";
  	$save = gzencode($save, 9);
}
  
// Cration du fichier
if (!$file = fopen($repertoire."/".$fichier, $opt_file)) 
	error ($lang['open_no'].$fichier);

// Ecriture dans le fichier
if (fwrite($file, $save) === FALSE) 
{	
	// Ecrit le log //
	$log_txt = $lang['log_error_save'];
	fwrite($log, $log_txt);
	error ($lang['write_no'].$fichier);
}
    
echo "<strong>".$lang['write_success']."</strong>";
	
// Ecrit le log //
$log_txt = $lang['log_write']."$num table(s), $nb ".$lang['info2']." $temps s\n".$lang['log_success'];
fwrite($log, $log_txt); 
	
// On ferme les fichiers
fclose($file);  
fclose($log);         


// Envoie d'un mail avec le fichier si demand
if ($save_email == "true")
{
	// si gzip
  	if ($zip == "true") 
		$type = "application/x-gzip";
	else 
		$type = "text/sql"; 
	
	include('./mail/htmlMimeMail.php');

	// Cre un nouvel objet email
	$mail = new htmlMimeMail();
	
	// Lit le fichier  attacher
	$attachment = $mail->getFile($repertoire.'/'.$fichier);

	// Sujet de l'email
	$mail->setSubject($lang['mail_title'].$date);

	// Texte de l'email
	$mail->setText($lang['mail_subject'].$bdd.' - '.$date.$lang['mail_script']);

	// Attache le fichier  l'email
	$mail->addAttachment($attachment, $fichier, $type);

	// Envoie l'email !
	$mail->setFrom('MyKtools v'.$version);
	
	$all_emails = explode(";", $email);
	foreach ($all_emails as $value)
	{
		$result = $mail->send(array($value));
	
		// Rponse : envoie effectu ou non ?
		echo $result ? '<br />'.$lang['email'] : $lang['error_mail'];
		
		// Creation du log
		$log = fopen("./logs/log-sauvegarde-".$bdd."-".$date.".txt", 'a+');
		if ($result)
			$log_txt = "\n".$lang['email'];
		else
			$log_txt = "\n".$lang['error_mail'];
		fwrite($log, $log_txt);
		fclose($log);
	}
}

echo "<br />";

// Envoie le fichier sur un FTP si demand
if ($save_ftp == "true")
{
    // Connexion au serveur FTP
	if(!$ftp_co = ftp_connect($ftp))
		echo $lang['error_ftp_connect'];
	else
	{
		if(!ftp_login($ftp_co, $ftp_login, $ftp_mdp))
			echo $lang['error_ftp_login'];
		else
		{
			if (!ftp_chdir($ftp_co, $ftp_dir))
				 echo $lang['error_ftp_dir'];
			if (!ftp_put($ftp_co, $fichier, $repertoire.'/'.$fichier, FTP_BINARY))
				echo $lang['error_ftp_transfert'].$fichier;
		}
		ftp_close($ftp_co); 
	}

	// Creation du log
	$log = fopen("./logs/log-sauvegarde-".$bdd."-".$date.".txt", 'a+');
	if ($result)
		$log_txt = "\n".$lang['ftp_send'];
	else
		$log_txt = "\n".$lang['error_ftp_transfert'];
	fwrite($log, $log_txt);
	fclose($log);
}

echo "<br />";

// On efface le fichier si demand (email)
if ($delete == "true" && $save_email == "true")
{ 
	// Creation du log
	$log = fopen("./logs/log-sauvegarde-".$bdd."-".$date.".txt", 'a+');
	
	if (unlink($repertoire."/".$fichier) === FALSE)
	{
		echo $lang['no_del'].$fichier;
		$log_txt = "\n".$lang['log_error_del'];
	}
	else
	{
		echo $lang['del'];
		$log_txt = "\n".$lang['log_del'];
	}
	// On crit puis on ferme le log
	fwrite($log, $log_txt);
	fclose($log);
}

// On efface le fichier si demand (FTP)
if ($delete_ftp == "true" && $delete == "false" && $save_ftp == "true")
{ 
	// Creation du log
	$log = fopen("./logs/log-sauvegarde-".$bdd."-".$date.".txt", 'a+');
	
	if (unlink($repertoire."/".$fichier) === FALSE)
	{
		echo $lang['no_del'].$fichier;
		$log_txt = "\n".$lang['log_error_del'];
	}
	else
	{
		echo $lang['del'];
		$log_txt = "\n".$lang['log_del'];
	}
	// On crit puis on ferme le log
	fwrite($log, $log_txt);
	fclose($log);
}

include ('footer.php');
?>