<?php
/*
....
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPABC_MailChimp' ) )
{
    class CPABC_MailChimp extends CPABC_BaseAddon
    {
        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-mailchimp-20170504";
		protected $name = "MailChimp";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;

			// Insertion in database
			if(
				isset( $_REQUEST[ 'cpabc_mailchimp_list_id' ] ) &&
				isset( $_REQUEST[ 'cpabc_mailchimp_api_key' ] )
			)
			{
                $this->add_field_verify("apphbmailchimp_accept_field", "TEXT");
                
				$data = array(
					'status_if_new' => 'pending',
					'fields' => array(),
					'groups' => array()
				);

				if(isset($_REQUEST[ 'cpabc_mailchimp_status_if_new' ]) && $_REQUEST[ 'cpabc_mailchimp_status_if_new' ] == 'subscribed') $data['status_if_new'] = 'subscribed';

                if (!empty($_REQUEST[ 'cpabc_mailchimp_attr' ]))
				    foreach( $_REQUEST[ 'cpabc_mailchimp_attr' ] as $key => $attr )
				    {
				    	$attr = trim( $attr );
				    	if( !empty( $attr ) ) $data[ 'fields' ][ $key ] = $attr;
				    }

                if (!empty($_REQUEST[ 'cpabc_mailchimp_gpr' ]))
				    foreach( $_REQUEST[ 'cpabc_mailchimp_gpr' ] as $key => $group )
				    {
				    	$data[ 'groups' ][ $key ] = array(
				    		'title' => $_REQUEST[ 'cpabc_mailchimp_gpr_title' ][ $key ],
				    		'structure' => $_REQUEST[ 'cpabc_mailchimp_gpr_structure' ][ $key ]
				    	);
				    }

				$wpdb->delete( $wpdb->prefix.$this->form_mailchimp_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert( 	$wpdb->prefix.$this->form_mailchimp_table,
								array(
									'formid' 	=> $form_id,
									'api_key'	=> trim( $_REQUEST[ 'cpabc_mailchimp_api_key' ] ),
									'list_id'   => trim( $_REQUEST[ 'cpabc_mailchimp_list_id' ] ),
									'data'	 	=> serialize( $data ),
                                    'apphbmailchimp_accept_field'   => trim( $_REQUEST[ 'apphbmailchimp_accept_field' ] ),
								),
								array( '%d', '%s', '%s', '%s', '%s' )
							);
			}

			$api_key = '';
			$list_id = '';
			$data 	 = array();
			$groups  = array();
			$row 	 = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_mailchimp_table." WHERE formid=%d", $form_id ) );
			$status_if_new = 'pending';
			if( $row )
			{
				$api_key 	= $row->api_key;
				$list_id 	= $row->list_id;
				if( ( $tmp = @unserialize( $row->data ) ) != false )
				{
					if(isset($tmp['status_if_new']) && $tmp['status_if_new'] == 'subscribed') $status_if_new = 'subscribed';
					$data = ( isset( $tmp[ 'fields' ] ) ) ? $tmp[ 'fields' ] : $tmp;
					if ( isset( $tmp[ 'groups' ] ) ) $groups = $tmp[ 'groups' ];
				}
			}
			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
					<table cellspacing="0">
						<tr>
							<td style="white-space:nowrap;width:100px;"><?php _e('API KEY', 'cpabc');?>:</td>
							<td><input type="text" name="cpabc_mailchimp_api_key" value="<?php echo esc_attr( $api_key ); ?>" style="width:100%;" /></td>
							<td><input type="button" value="<?php echo esc_attr( __( 'Get Lists', 'cpabc' ) ); ?>" onclick="cpabc_mailchimp_getList();" /></td>
						</tr>
						<tr>
							<td style="white-space:nowrap;width:100px;"><?php _e('List ID', 'cpabc');?>:</td>
							<td>
								<input type="text" name="cpabc_mailchimp_list_id" readonly value="<?php echo esc_attr( $list_id ); ?>" style="width:100%;" />
							</td>
							<td><input type="button" value="<?php echo esc_attr( __( 'Get Fields and Groups', 'cpabc' ) ); ?>" onclick="cpabc_mailchimp_getFields();" /></td>
						</tr>
						<tr>
							<td></td>
							<td><div class="cpabc-mailchimp-list-container"></div></td>
							<td></td>
						</tr>
						<tr><td colspan="3"><strong><?php _e('Form Fields', 'cpabc');?>:</strong></td></tr>
						<tr>
							<td colspan="3">
								<table class="cpabc-mailchimp-fields-container">
								<?php
									if( !empty( $data ) )
									{
										foreach( $data as $attr => $value )
										{
											print '<tr>
											<td>'.$attr.'</td>
											<td><input type="text" name="cpabc_mailchimp_attr['.esc_attr($attr).']" value="'.esc_attr( $value ).'" placeholder="fieldname#" /></td>
											</tr>';
										}
									}
									else
									{
										print '<tr><td colspan="2">'.__( 'There are not fields selected', 'cpabc').'</td></tr>';
									}
								?>
								</table>
							</td>
						</tr>
						<tr><td colspan="3"><strong><?php _e('Groups', 'cpabc');?>:</strong></td></tr>
						<tr>
							<td colspan="3">
								<table class="cpabc-mailchimp-groups-container">
								<?php
									if( !empty( $groups ) )
									{
										foreach( $groups as $grp => $obj )
										{
											$obj[ 'structure' ] = stripcslashes( $obj[ 'structure' ] );
											print '
											<tr>
												<td valign="top">
													<input type="checkbox" name="cpabc_mailchimp_gpr['.esc_attr($grp).']" CHECKED />'.$obj[ 'title' ].'
													<input type="hidden" name="cpabc_mailchimp_gpr_title['.esc_attr($grp).']" value="'.esc_attr( $obj[ 'title' ] ).'" />
												</td>
												<td class="cpabc-mailchimp-group-container">
													<input type="hidden" name="cpabc_mailchimp_gpr_structure['.esc_attr($grp).']" value="'.esc_attr( $obj[ 'structure' ] ).'" />
													'.$obj[ 'structure' ].'
												</td>
											</tr>';
										}
									}
									else
									{
										print '<tr><td colspan="2">'.__( 'There are not groups selected', 'cpabc').'</td></tr>';
									}
								?>
								</table>
							</td>
						</tr>
						<tr>
							<td style="white-space:nowrap;width:100px;"><?php _e('Status If New', 'cpabc');?>:</td>
							<td colspan="2">
								<select name="cpabc_mailchimp_status_if_new">
									<option value="pending" <?php if($status_if_new == 'pending') print 'SELECTED'; ?>><?php print esc_html(__('Pending', 'cpabc')); ?></option>
									<option value="subscribed" <?php if($status_if_new == 'subscribed') print 'SELECTED'; ?>><?php print esc_html(__('Subscribed', 'cpabc')); ?></option>
								</select>
							</td>
						</tr>
                        <tr><td colspan="2"><hr></td></tr>
						<tr>
							<td style="white-space:nowrap;width:100px;"><?php _e('Acceptance field', 'cpabc');?>:</td>
							<td>
								<input type="text" name="apphbmailchimp_accept_field"  value="<?php if (!empty($row) && $row->apphbmailchimp_accept_field) echo esc_attr( $row->apphbmailchimp_accept_field ); ?>" size="10" /><br />
                                <em>Optional: ID of a checkbox field to accept being added to MailChimp. If marked the user will be added to MailChimp. If this settings field is left blank the user will be added always to MailChimp. Sample value: fieldname3</em>   
							</td>							
						</tr>                         
					</table>
				</div>
				<script>
					var cpabc_mailchimp_texts = {
							'invalid_api_key' : '<?php print esc_js( __( 'Invalid API KEY', 'cpabc' ) ); ?>',
							'select_list' 	  : '<?php print esc_js( __( 'Select a List', 'cpabc' ) ); ?>',
							'required_list_id': '<?php print esc_js( __( 'Select a List ID', 'cpabc' ) ); ?>',
							'no_list'		  : '<?php print esc_js( __( 'Create at least a list in your MailChimp account', 'cpabc' ) ); ?>',
							'no_fields'		  : '<?php print esc_js( __( 'There are not fields selected', 'cpabc' ) ); ?>',
							'no_groups'		  : '<?php print esc_js( __( 'There are not groups selected', 'cpabc' ) ); ?>'
						},
						cpabc_mailchimp_nonce = '<?php print esc_js( wp_create_nonce( "cpabc_mailchimp_nonce" ) ); ?>';
				</script>
			</div>
			<?php
		}

		/************************ ADDON CODE *****************************/
        /************************ ATTRIBUTES *****************************/

		private $form_mailchimp_table = 'cpabc_mailchimp';
		private $mailchimp_url = 'https://%s.api.mailchimp.com/3.0/lists/%s/members';
		private $mailchimp_user = 'cpabc-mailchimp-addon';

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("The add-on creates MailChimp List members with the submitted information", 'cpabc' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

			// Call actions
			add_action( 'init', array( &$this, 'init' ), 1 );

			// Load resources
            add_action( 'admin_enqueue_scripts', array( &$this, 'enqueue_scripts' ), 10 );

			// Create the member
			add_action( 'cpabc_process_data', array( &$this, 'create_member' ) );
            
            $this->update_database();

        } // End __construct

        /************************ PROTECTED METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_mailchimp_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					api_key VARCHAR(250) DEFAULT '' NOT NULL,
					list_id VARCHAR(250) DEFAULT '' NOT NULL,
                    apphbmailchimp_accept_field VARCHAR(250) DEFAULT '' NOT NULL,
					data text,
					UNIQUE KEY id (id)
				) $charset_collate;";

			$wpdb->query($sql);
		} // End update_database

        /************************ PRIVATE METHODS *****************************/
		/************************ PUBLIC METHODS  *****************************/

		public function init()
		{
			add_action( 'cpabc_the_form', array( &$this, 'add_groups' ), 10, 2 );
			if(
				isset($_REQUEST[ 'cpabc_mailchimp_nonce' ]) &&
				wp_verify_nonce( $_REQUEST[ 'cpabc_mailchimp_nonce' ], 'cpabc_mailchimp_nonce' )
			)
			{
				$result = $this->mailchimp_actions( $_REQUEST );
				if( $result !== false )
				{
					print $result;
					exit;
				}
			}
		}

		/** 
		 * Modifies the form structure to includes the fields for groups
		 */
		public function add_groups( $form_str, $id )
		{
			global $wpdb, $CP_CPP_global_form_count;

			$data  = $wpdb->get_var( $wpdb->prepare( "SELECT data FROM ".$wpdb->prefix.$this->form_mailchimp_table." WHERE formid=%d", $id ) );

			if( $data && ( $tmp = @unserialize( $data ) ) != false )
			{
				if ( isset( $tmp[ 'groups' ] ) )
				{
					foreach( $tmp[ 'groups' ] as $key => $group )
					{
						$tmp[ 'groups' ][ $key ][ 'structure' ] = stripcslashes( $group[ 'structure' ] );
					}
					$form_str .='<pre style="display:none;"><!--noptimize--><script>mailchimp_groups'.$CP_CPP_global_form_count.'='.json_encode( $tmp[ 'groups' ] ).';</script><!--/noptimize--></pre>';

					// Enqueue the script that insert the groups into the form's structure
					wp_enqueue_script( 'cpabc_mailchimp_addon_js', plugins_url('/mailchimp.addon/js/public_scripts.js',  __FILE__), array( 'jquery' ) );
				}
			}
			return $form_str;
		}

        /**
         * Contact the MailChimp service
         */
		public function mailchimp_actions( $data )
		{
			if( isset( $data[ 'cpabc_mailchimp_action' ]  ) )
			{
				if(
					!empty( $data[ 'api_key' ] ) &&
					preg_match( '/(.*)\-(us\d+)$/i', $data[ 'api_key' ], $parts )
				)
				{
					$args = array(
									'headers' => array( 'Authorization' => 'Basic '.base64_encode( $this->mailchimp_user.':'.$parts[1] )  )
								);
					switch( strtolower( trim( $data[ 'cpabc_mailchimp_action' ] ) ) )
					{
						case 'cpabc_mailchimp_get_lists':
							$url = "https://{$parts[2]}.api.mailchimp.com/3.0/lists";
							$response = wp_remote_get(
											$url,
											$args
										);
						break;
						case 'cpabc_mailchimp_get_fields':
							if( !empty( $data[ 'list_id' ] ) && ($list_id = trim( $data[ 'list_id' ] ) ) !== '' )
							{
								$results = array();

								// ******** GET FIELDS ***********
								$response_fields = wp_remote_get( "https://{$parts[2]}.api.mailchimp.com/3.0/lists/{$list_id}/merge-fields", $args );

								if( !is_wp_error( $response_fields ) && $response_fields['response']['code'] == 200 )
								{
									$_fields = json_decode( $response_fields[ 'body' ] );
									if( $_fields !== false )
									{
										$fields = array();
										foreach( $_fields->merge_fields as $_field )
										{
											$fields[] = $_field->tag;
										}

										if( !empty( $fields ) )
										{
											$results[ 'fields' ] = $fields;
										}
									}	// End if( $_fields !== false )
								}

								// ******** GET GROUPS ***********
								$response_groups = wp_remote_get( "https://{$parts[2]}.api.mailchimp.com/3.0/lists/{$list_id}/interest-categories", $args );
								if( !is_wp_error( $response_groups ) && $response_groups['response']['code'] == 200 )
								{
									$groups = array();

									$_groups = json_decode( $response_groups[ 'body' ] );
									if( $_groups !== false )
									{

										foreach( $_groups->categories as $_group )
										{
											$group  = array();
											// if( $_group->type == 'hidden' ) continue;

											// ******** GET INTERESTS ***********
											$response_interests = wp_remote_get( "https://{$parts[2]}.api.mailchimp.com/3.0/lists/{$list_id}/interest-categories/".$_group->id."/interests", $args );
											if( !is_wp_error( $response_interests ) && $response_interests['response']['code'] == 200 )
											{
												$_interests = json_decode( $response_interests[ 'body' ] );
												if( $_interests !== false )
												{
													$_output = '';
													switch( strtolower( $_group->type ) )
													{
														case 'hidden':
														case 'checkboxes':
															foreach( $_interests->interests as $_interest )
															{
																$_output .= '<label><input value="'.esc_attr($_interest->id).'" name="'.esc_attr($_group->id).'[]" type="checkbox" /> '.esc_html($_interest->name).'</label><br />';
															}
														break;
														case 'radio':
															foreach( $_interests->interests as $_interest )
															{
																$_output .= '<label><input value="'.esc_attr($_interest->id).'" name="'.esc_attr($_group->id).'" type="radio" /> '.esc_html($_interest->name).'</label><br />';
															}
														break;
														case 'dropdown':
															$_output .= '<select name="'.esc_attr($_group->id).'"><option value="">'.__('Please select...', 'cpabc').'</option>';
															foreach( $_interests->interests as $_interest )
															{
																$_output .= '<option value="'.esc_attr($_interest->id).'">'.esc_html($_interest->name).'</option>';
															}
															$_output .= '</select>';
														break;
													}  // End switch

													if( !empty( $_output ) )
													{
														$group[ 'title' ] 			= $_group->title;
														$group[ 'id' ] 				= $_group->id;
														$group[ 'interests' ] 		= $_output;
													}
												}
											}

											if( !empty( $group ) ) $groups[] = $group;
										}
									} // End if( $_groups !== false )

									if( !empty( $groups ) )
									{
										$results[ 'groups' ] = $groups;
									}
								}
								if( !empty( $results ) )
								{
									return json_encode( $results );
								}
								else
								{
									return '{"error":"Not field or group detected in the list"}';
								}
								exit;
							}
							else
							{
								return '{"error":"Invalid List Id"}';
							}
						break;
						case 'cpabc_mailchimp_create_member':
							if( !empty( $data[ 'list_id' ] ) && !empty( $data[ 'data' ]) )
							{
								$url = "https://{$parts[2]}.api.mailchimp.com/3.0/lists/".trim( $data[ 'list_id' ] )."/members/".md5( $data[ 'data' ][ 'email_address' ]);
								$args[ 'method' ] = 'PUT';
								$args[ 'headers' ][ 'Content-Type' ] = 'application/json';
								$args[ 'body' ] = json_encode( $data[ 'data' ] );     
                                  // print_r($data) ;exit;
								$response = wp_remote_request(
												$url,
												$args
											);
                                // print_r($response);exit;
							}
							else
							{
								return '{"error":"Invalid data"}';
							}
						break;
					}

					if( !empty( $response ) )
					{
						if ( wp_remote_retrieve_response_code( $response ) == 200 ) {
							return $response[ 'body' ];
						}
						else
						{
							return '{"error":"Error Connecting with MailChimp"}';
						}
					}
				}
				else
				{
					return '{"error":"Invalid API Key"}';
				}
			}
			return false;
		} // End mailchimp_actions

		/**
         * Enqueue all resources: CSS and JS files, required by the Addon
         */
        public function enqueue_scripts()
        {
			wp_enqueue_script( 'cpabc_mailchimp_addon_js', plugins_url('/mailchimp.addon/js/scripts.js',  __FILE__), array( 'jquery', 'jquery-ui-autocomplete' ) );

        } // End enqueue_scripts

		/**
         * Create the MailChimp member
         */
        public function	create_member( $params )
		{
			global $wpdb;
                        
			$form_id = @intval( $params[ 'formid' ] );
			if( $form_id )
			{
				$row = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_mailchimp_table." WHERE formid=%d", $form_id ) );
				if( $row && !empty( $row->api_key ) && !empty( $row->list_id ) )
				{
                    
                    if ($row->apphbmailchimp_accept_field && empty($params[$row->apphbmailchimp_accept_field]))
                        return;
                        
					$data = array(
						'status_if_new' => 'pending',
						'merge_fields' => array()
					);

					if( ( $_data = unserialize( $row->data ) ) !== false )
					{
						if(isset($_data['status_if_new']) && $_data['status_if_new'] == 'subscribed')
							$data['status_if_new'] = 'subscribed';

						$attrs = ( isset ( $_data[ 'fields' ] ) ) ? $_data[ 'fields' ] : $_data;
						foreach( $attrs as $key => $value )
						{
							if( $key == 'email_address' )
								$data[ $key ] = ( isset( $params[ $value ] ) ) ? $params[ $value ] : $value;
							$data[ 'merge_fields' ][ $key ] = ( isset( $params[ $value ] ) ) ? $params[ $value ] : $value;
						}

						$groups = ( isset( $_data[ 'groups' ] ) ) ? $_data[ 'groups' ] : array();
                        
						$interests = array();
						foreach( $groups as $key => $group )                        
						{
                            
                            $extracted = str_replace('CHECKED','checked',str_replace('\"','"',$group[ 'structure' ]));  
                            //echo htmlentities($extracted);
                            preg_match_all ('/"([a-z0-9]+)" checked/',$extracted, $matches);
                            //echo '<pre>';print_r($matches);
                            for ($ik=0;$ik<count($matches);$ik++)
                                foreach ($matches[$ik] as $match)
                                {
                                    $match = str_replace('"','',$match);
                                    $match = str_replace(' ','',$match);
                                    $match = str_replace('checked','',$match);
                                    $interests[$match] = true;
                                }                       
							if( !empty( $_REQUEST[ $key ] ) )
							{
								if( is_array( $_REQUEST[ $key ] ) )
								{
									foreach( $_REQUEST[ $key ] as $value )
									{
										if( strpos( $group[ 'structure' ], $value ) !== false )
										{
											$interests[ $value ] = true;
										}
									}
								}
								else
								{
									if( strpos( $group[ 'structure' ], $_REQUEST[ $key ] ) !== false )
									{
										$interests[ $_REQUEST[ $key ] ] = true;
									}
								}
							}
						}
                     
						if( !empty( $interests ) )
						{
							$data[ 'interests' ] = $interests;
						}

						$args = array(
							'api_key' => $row->api_key,
							'list_id' => $row->list_id,
							'cpabc_mailchimp_action' => 'cpabc_mailchimp_create_member',
							'data' => $data
						);

						$this->mailchimp_actions( $args );
					}
				}
			}
		} // End create_member


		/**
		 *	Add field if not exists
		 */
        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL")
        {
            global $wpdb, $cp_appb_plugin;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$this->form_mailchimp_table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_mailchimp_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }
        

    } // End Class

    // Main add-on code
    $cpabc_mailchimp_obj = new CPABC_MailChimp();

    global $cpabc_addons_objs_list;
	$cpabc_addons_objs_list[ $cpabc_mailchimp_obj->get_addon_id() ] = $cpabc_mailchimp_obj;
}
?>