<?php
/*
    iCal Import Addon
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPABC_paymentTimeout' ) )
{
    class CPABC_paymentTimeout extends CPABC_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-paymentTimeout-20220114";
		protected $name = "Payment Timeout";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPABC_paymentTimeout_id' ] )
			)
			{
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									'paymentTimeout_enable'	 => $_REQUEST["paymentTimeout_enable"],
                                    'timeoutminutes'	 => $_REQUEST["timeoutminutes"],
                                    'deletecancelled_enable'	 => $_REQUEST["deletecancelled_enable"],
                                    'dcancelleddays'	 => $_REQUEST["dcancelleddays"]
								),
								array( '%d', '%d', '%d', '%d', '%d', '%d' )
							);          
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["paymentTimeout_enable"] = 0;
			    $row["timeoutminutes"] = 30;
                $row["deletecancelled_enable"] = 0;
                $row["dcancelleddays"] = 0;
			} else {
			    $row["paymentTimeout_enable"] = $rows[0]->paymentTimeout_enable;
			    $row["timeoutminutes"] = $rows[0]->timeoutminutes;
                $row["deletecancelled_enable"] = $rows[0]->deletecancelled_enable;
                $row["dcancelleddays"] = $rows[0]->dcancelleddays;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPABC_paymentTimeout_id" value="1" />
                     Enable cancellation of non-paid bookings? :<br />
                        <?php $option = $row['paymentTimeout_enable']; ?>
                        <select name="paymentTimeout_enable" id="paymentTimeout_enable" onchange="abcical_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br /><em>Important: These settings are applied for bookings received after updating this settings. Won't apply for bookings already received.</em><br />
                   
                   <div id="paymentTimeoutcontent_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                         <br />
                         <strong>Mark booking as cancelled if not paid after # of minutes:</strong><br />
                         <input type="number" name="timeoutminutes" value="<?php echo $row["timeoutminutes"]; ?>">
                         <br />                     
                   </div>
                   
                   <br /><hr><br>
                    Enable deletion of cancelled bookings? :<br />
                        <?php $option = $row['deletecancelled_enable']; ?>
                        <select name="deletecancelled_enable" id="deletecancelled_enable" onchange="abccanceldel_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br><em>Important: These settings are applied for bookings received after updating this settings. Won't apply for bookings already received.</em><br />
                   
                   <div id="deletecancelled_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                         <br />
                         <strong>Delete cancelled bookings after # of days:</strong><br />
                         <input type="number" name="dcancelleddays" value="<?php echo $row["dcancelleddays"]; ?>">
                         <br />                     
                   </div>                                   
                   
                   
                   <script type="text/javascript">
                       function abcical_display_option(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("paymentTimeoutcontent_yes").style.display = '';
                           else
                               document.getElementById("paymentTimeoutcontent_yes").style.display = 'none';
                       }                       
                       function abccanceldel_display_option(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("deletecancelled_yes").style.display = '';
                           else
                               document.getElementById("deletecancelled_yes").style.display = 'none';
                       }                       
                   </script>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpabc_form_paymenttimeouts';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("Cancels non-paid appointments after a time-out and/or delete cancelled items", 'cpappb' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;
                       
            add_action( 'init', array( &$this, 'paymentTimeout_check' ), 10, 1 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
            
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    paymentTimeout_enable INT NOT NULL,
                    timeoutminutes INT NOT NULL, 
                    deletecancelled_enable INT NOT NULL, 
                    dcancelleddays INT NOT NULL, 
					UNIQUE KEY id (id)
				) $charset_collate;";
            
			$wpdb->query($sql);
            
		} // end update_database
        
        
       

		/************************ PUBLIC METHODS  *****************************/
    
        
		public function paymentTimeout_check( )
		{
            global $wpdb;
           
            if (false)           
            {
                $last_checked = get_option('ABC_TIMEOUT_LASTCHECKED',0);
                if ($last_checked != 0 && $last_checked > date("Y-m-d H:i:s", strtotime("-3 minutes")))
                    return;            
                update_option('ABC_TIMEOUT_LASTCHECKED',date("Y-m-d H:i:s"));
            }
         
            $timemysql = current_time('mysql');           
            $rows = $wpdb->get_results( 
						"SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE paymentTimeout_enable=1"
					);
			foreach ($rows as $row)		
            {
                 $events = $wpdb->get_results( 
						$wpdb->prepare( "SELECT ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.".id,".CPABC_APPOINTMENTS_TABLE_NAME.".buffered_date FROM ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME." LEFT JOIN  ".CPABC_APPOINTMENTS_TABLE_NAME." ON  ".CPABC_APPOINTMENTS_TABLE_NAME.".id=".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.".reference WHERE time<='".date("Y-m-d H:i:s",strtotime($timemysql." -".$row->timeoutminutes." minutes"))."' AND is_cancelled<>1 AND calendar=".$row->formid." AND ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.".id>".intval(get_option('CPABC_TIMEOUTCHECK',0))) 
					);       
           //         echo get_option('CPABC_TIMEOUTCHECK',0);
        //  print_r($events);exit;       
                 foreach ($events as $event)
                 {
                     update_option('CPABC_TIMEOUTCHECK', $event->id);
                     $params = unserialize($event->buffered_date);      
                     $is_paid = (array_key_exists("txnid",$params) || (isset($params["payment_type"]) && ($params["payment_type"] != 'PayPal' || isset($params["txnid"]))));
                     if (!$is_paid)
                     {
                         $wpdb->query("UPDATE `".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME."` SET who_cancelled='0',is_cancelled='1',cancelled_reason='payment timeout' WHERE id=".$event->id);
                     }
                 }
            }         

            $rows = $wpdb->get_results( 
						"SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE deletecancelled_enable=1"
					);
			foreach ($rows as $row)		
            {
                 $events = $wpdb->get_results( 
						$wpdb->prepare( "SELECT ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.".id,".CPABC_APPOINTMENTS_TABLE_NAME.".buffered_date FROM ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME." LEFT JOIN  ".CPABC_APPOINTMENTS_TABLE_NAME." ON  ".CPABC_APPOINTMENTS_TABLE_NAME.".id=".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.".reference WHERE time<='".date("Y-m-d H:i:s",strtotime("-".$row->dcancelleddays." days"))."' AND is_cancelled=1 AND calendar=".$row->formid." AND ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.".id>".intval(get_option('CPABC_DELCANCELCHECK',0))) 
					);       
                 
                 foreach ($events as $event)
                 {
                     update_option('CPABC_DELCANCELCHECK', $event->id);
                     //if (!$is_paid)
                     {
                         $item = $wpdb->get_row("SELECT * FROM ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME." WHERE id=".intval($event->id));
                         $itemdetails = $wpdb->get_row("SELECT * FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".intval($item->reference));
                         $data = unserialize($itemdetails->buffered_date);
                         foreach ($data as $itemname => $itemvalue)   
                             if (strpos($itemname,'_link'))
                                 @unlink($itemvalue[0]);
                         do_action( 'cpabc_item_deleted', intval($event->id) );
                         $wpdb->get_row("DELETE FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".$item->reference);
                         $wpdb->query('DELETE FROM `'.CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.'` WHERE id='.intval($event->id));                           
                     }
                 }
            }  

		}        
        

		/**
		 *  
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}
        


    } // End Class

    // Main add-on code
    $CPABC_paymentTimeout_obj = new CPABC_paymentTimeout();

	// Add addon object to the objects list
	global $cpabc_addons_objs_list;
	$cpabc_addons_objs_list[ $CPABC_paymentTimeout_obj->get_addon_id() ] = $CPABC_paymentTimeout_obj;
}


?>