<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPABC_PWGiftCard' ) )
{
    class CPABC_PWGiftCard extends CPABC_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-PWGiftCard-20210523";
		protected $name = "PW WooCommerce Gift Cards Integration";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPABC_PWGiftCardlinks_id' ] )
			)
			{

                
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
                                    
                                    'pwgiftcard'	  => $_REQUEST["pwgiftcard"],
								),
								array( '%d',  '%d' )
							);
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
                $row["pwgiftcard"] = '0';              
			} else {
                $row["pwgiftcard"] = $rows[0]->pwgiftcard;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPABC_PWGiftCardlinks_id" value="1" />
                   <?php if (class_exists('PW_Gift_Card')) { ?>
                    Enable <a href="https://wordpress.org/plugins/pw-woocommerce-gift-cards/" target="_blank">PW WooCommerce Gift Cards</a> integration for this booking form? :<br />
                        <?php $option = $row['pwgiftcard']; ?>
                        <select name="pwgiftcard" id="pwgiftcard" onchange="cpappbzoom_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
                     <em>Note: In addition to enabling this, add at least one coupon code in the section "Discount Codes" above in this page.    
                   <?php } else { ?>    
The plugin <a href="https://wordpress.org/plugins/pw-woocommerce-gift-cards/" target="_blank">PW WooCommerce Gift Cards</a> has not been detected. 
This coupon codes add-on requires the plugin "PW WooCommerce Gift Cards" installed and active.               
                   <?php } ?>
                             
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpabc_form_PWGiftCardlinks';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("Integration with PW WooCommerce Gift Cards", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            add_action( 'cpabc_mark_coupon_code', array( &$this, 'mark_coupon' ), 10, 3 );

            add_filter( 'cpabc_calculate_coupon', array( &$this, 'calculate_coupon'), 10, 3 );
            add_filter( 'cpabc_check_coupon', array( &$this, 'check_coupon'), 10, 3 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    pwgiftcard INT NOT NULL,
					UNIQUE KEY id (id)
				) $charset_collate;";   
            $wpdb->query($sql);

		} // end update_database


		/************************ PUBLIC METHODS  *****************************/

        
		/**
         * 
         */
        public function	calculate_coupon( $price, $coupon, $formid )
		{
            global $wpdb;

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid )
					);

			if (empty( $rows ) || !$rows[0]->pwgiftcard || !class_exists('PW_Gift_Card'))
			    return $price;
            
            $gift = new PW_Gift_Card($coupon);
            if ( $gift->get_error_message() != '' || !$gift->get_active() )
                return $price;
     
            $balance = $this->get_card_balance($gift);            
            
            $price = floatval($price) - $balance;
            if ($price < 0)
                $price = 0;
            
            return $price;
        }    
        
        
		/**
         * 
         */
        public function	check_coupon( $valid, $coupon, $formid )
		{
            global $wpdb;

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid )
					);
 
			if (empty( $rows ) || !$rows[0]->pwgiftcard || !class_exists('PW_Gift_Card'))
			    return $price;
            
            $gift = new PW_Gift_Card($coupon);

            if ( $gift->get_error_message() != '' || !$gift->get_active() )
                return false;
 
            $balance = $this->get_card_balance($gift);
            
            return ($balance > 0);
        }    
        
        
		/**
         * 
         */        
        public function mark_coupon( $coupon, $amount, $formid )
        {
            global $wpdb;
                    
            
			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid )
					);

			if (empty( $rows ) || !$rows[0]->pwgiftcard || !class_exists('PW_Gift_Card'))
			    return;
                       
           
           $gift = new PW_Gift_Card($coupon);
           
           if ($gift->get_error_message() == '')
           {
               $balance = $this->get_card_balance($gift);
               if ($balance < $amount)
                   $amount = $balance;
               PW_Gift_Card_Activity::record( $gift->get_id(), 'transaction', -$amount, 'Appointment Booking Calendar transaction');
           }
           
                     
        }
        
        
    public function get_card_balance( $gift_card ) 
    {
        global $wpdb;

        $balance = 0;

        $results = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `{$wpdb->pimwick_gift_card_activity}` WHERE pimwick_gift_card_id = %d ORDER BY `activity_date`", $gift_card->get_id() ) );
        
        if ( null !== $results ) {
            foreach ( $results as $row ) {
                $balance += floatval($row->amount);
            }

        } 
        
        return $balance;
    }        
        


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}        
  

    } // End Class

    // Main add-on code
    $CPABC_PWGiftCard_obj = new CPABC_PWGiftCard();

	// Add addon object to the objects list
	global $cpabc_addons_objs_list;
	$cpabc_addons_objs_list[ $CPABC_PWGiftCard_obj->get_addon_id() ] = $CPABC_PWGiftCard_obj;
}