<?php
/*
Documentation: https://Razorpay.com/docs/quickstart
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPABC_Razorpay' ) )
{
    class CPABC_Razorpay extends CPABC_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-Razorpay-20210312";
		protected $name = "Razorpay Payment Gateway";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;

			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPABC_Razorpay_id' ] )
			)
			{
			    // verify needed fields for update
                //$wpdb->show_errors();
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
                                    
									'Razorpay_key'	 => $_REQUEST["Razorpay_key"],
									'Razorpay_secretkey'	 => $_REQUEST["Razorpay_secretkey"],
									'enabled'	 => $_REQUEST["Razorpay_enabled"],
                                    
                                    'currency'	 => $_REQUEST["Razorpay_currency"],
                                    
                                    'Razorpay_subtitle'	 => $_REQUEST["Razorpay_subtitle"],
                                    
                                    'Razorpay_optionlabel'	 => $_REQUEST["Razorpay_optionlabel"],
                                    
                                    'Razorpay_logoimage'	 => $_REQUEST["Razorpay_logoimage"]
								),
								array( '%d', '%s', '%s', '%s', 
                                             '%s', 
                                             '%s', 
                                             '%s',
                                             '%s'
                                             )
							);      
               //$wpdb->print_error();exit;
			}


			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
           
			if (!count($rows))
			{
			    $row["Razorpay_key"] = "";
			    $row["Razorpay_secretkey"] = "";
			    $row["enabled"] = "0";
                $row["currency"] = "INR";
                $row["Razorpay_subtitle"] = "";
                $row["Razorpay_logoimage"] = "";
                $row["Razorpay_optionlabel"] = __('Pay with Credit Cards', 'appointment-hour-booking');
			} else {
			    $row["Razorpay_key"] = $rows[0]->Razorpay_key;
			    $row["Razorpay_secretkey"] = $rows[0]->Razorpay_secretkey;
			    $row["enabled"] = $rows[0]->enabled;
                $row["currency"] = $rows[0]->currency;
                $row["Razorpay_subtitle"] = $rows[0]->Razorpay_subtitle;
			    $row["Razorpay_logoimage"] = $rows[0]->Razorpay_logoimage;  
                $row["Razorpay_optionlabel"] = ( $rows[0]->Razorpay_optionlabel ? $rows[0]->Razorpay_optionlabel : __('Pay with Credit Cards', 'appointment-hour-booking') );
			}
			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPABC_Razorpay_id" value="1" />
                   <table class="form-table">
                    <tr valign="top">
                    <th scope="row"><?php _e('Enable Razorpay?', 'cpabc'); ?></th>
                    <td><select name="Razorpay_enabled">
                         <option value="0" <?php if (!$row["enabled"]) echo 'selected'; ?>><?php _e('No', 'cpabc'); ?></option>
                         <option value="1" <?php if ($row["enabled"]) echo 'selected'; ?>><?php _e('Yes', 'cpabc'); ?></option>
                         <option value="2" <?php if ($row["enabled"] == '2') echo 'selected'; ?>><?php _e('Optional: This payment method + Pay Later (submit without payment)', 'cpabc'); ?></option>
                         <option value="3" <?php if ($row["enabled"] == '3') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods (enabled)', 'cpabc'); ?></option>
                         <option value="4" <?php if ($row["enabled"] == '4') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods  + Pay Later ', 'cpabc'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row">Razorpay.com <a href="https://dashboard.Razorpay.com/app/keys" target="_blank" title="<?php _e('click to get the your Razorpay key', 'appointment-hour-booking'); ?>"><?php _e('Key ID', 'cpabc'); ?></a></th>
                    <td><input type="text" name="Razorpay_key" size="20" value="<?php echo esc_attr($row["Razorpay_key"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row">Razorpay.com <a href="https://dashboard.Razorpay.com/app/keys" target="_blank" title="<?php _e('click to get the your Razorpay secret key', 'appointment-hour-booking'); ?>"><?php _e('Key Secret', 'cpabc'); ?></a></th>
                    <td><input type="text" name="Razorpay_secretkey" size="20" value="<?php echo esc_attr($row["Razorpay_secretkey"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Razorpay - Currency', 'cpabc'); ?></th>
                    <td><input type="text" name="Razorpay_currency" size="20" value="<?php echo esc_attr($row["currency"]); ?>" /></td>
                    </tr>        
                                      
                    
   
                    <tr valign="top">
                    <th scope="row"><?php _e('Seller Company Name for payment panel', 'cpabc'); ?></th>
                    <td><input type="text" name="Razorpay_subtitle" size="20" value="<?php echo esc_attr($row["Razorpay_subtitle"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('URL of logo image', 'cpabc'); ?></th>
                    <td><input type="text" name="Razorpay_logoimage" size="20" value="<?php echo esc_attr($row["Razorpay_logoimage"]); ?>" /><br />
                    <em>* A relative or absolute URL pointing to a square image of your brand or product. The recommended minimum size is 128x128px. The supported image types are: .gif, .jpeg, and .png.</em></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Option label', 'cpabc'); ?></th>
                    <td><input type="text" name="Razorpay_optionlabel" size="20" value="<?php echo esc_attr($row["Razorpay_optionlabel"]); ?>" /><br />
                    <em>* Used if multiple payments are enabled</em></td>
                    </tr>                      
                   </table>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpabc_Razorpay';
        private $form_table_plans = 'cpabc_Razorpayplans';
        private $form_table_customers = 'cpabc_Razorpaycustomers';
        private $_inserted = false;
		private $_apphbmain;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			
			$this->description = __("The add-on adds support for Razorpay payments (SCA and Classic)", 'cpabc' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            if (!is_admin())
            {
			    add_action( 'cpabc_process_data_before_insert', array( &$this, 'pp_Razorpay' ), 1, 1 );
                
			    add_action( 'cpabc_process_data', array( &$this, 'pp_Razorpay_redirect' ), 11, 1 );
                
			    add_action( 'init', array( &$this, 'pp_Razorpay_check_price' ), 1 );
                
			    add_action( 'cpabc_script_after_validation_stripe', array( &$this, 'pp_payments_script' ), 10, 2 );
                
			    add_filter( 'cpabc_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );
            }
			else
			{
				// Delete forms
				add_action( 'cpabc_delete_form', array(&$this, 'delete_form') );

				// Clone forms
				add_action( 'cpabc_clone_form', array(&$this, 'clone_form'), 10, 2 );

				// Export addon data
				add_action( 'cpabc_export_addons', array(&$this, 'export_form'), 10, 2 );

				// Import addon data
				add_action( 'cpabc_import_addons', array(&$this, 'import_form'), 10, 2 );
			}

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					enabled varchar(10) DEFAULT '0' NOT NULL ,
					Razorpay_key varchar(255) DEFAULT '' NOT NULL ,
					Razorpay_secretkey varchar(255) DEFAULT '' NOT NULL ,
                    currency varchar(255) DEFAULT '' NOT NULL ,
                    Razorpay_subtitle varchar(255) DEFAULT '' NOT NULL ,
                    Razorpay_logoimage varchar(255) DEFAULT '' NOT NULL ,
                    Razorpay_language varchar(255) DEFAULT '' NOT NULL ,                    
                    Razorpay_optionlabel varchar(255) DEFAULT '' NOT NULL ,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
            $wpdb->query($sql);

			//$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table_plans." (
			//		id mediumint(9) NOT NULL AUTO_INCREMENT,
			//		planname varchar(255) DEFAULT '' NOT NULL ,
			//		planinterval varchar(255) DEFAULT '' NOT NULL ,
			//		currency varchar(30) DEFAULT '' NOT NULL ,
			//		amount varchar(20) DEFAULT '' NOT NULL ,
			//		trial_period_days varchar(20) DEFAULT '' NOT NULL,
			//		planresult TEXT DEFAULT '' NOT NULL,
			//		UNIQUE KEY id (id)
			//	)
			//	CHARACTER SET utf8
			//	COLLATE utf8_general_ci;";
			//$wpdb->query($sql);
            //
			//$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table_customers." (
			//		id mediumint(9) NOT NULL AUTO_INCREMENT,
			//		email varchar(255) DEFAULT '' NOT NULL ,
			//		source varchar(255) DEFAULT '' NOT NULL ,
			//		customer_id varchar(255) DEFAULT '' NOT NULL ,
			//		customerresult TEXT DEFAULT '' NOT NULL,
			//		UNIQUE KEY id (id)
			//	)
			//	CHARACTER SET utf8
			//	COLLATE utf8_general_ci;";
			//$wpdb->query($sql);

		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
         * Inserts banks and Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb;

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return $form_code;


            $checkscript = '';
			$code = '<div id="opfield"'.$this->addonID.$id.'">'.
                      '<!--noptimize--><script src="https://checkout.razorpay.com/v1/checkout.js"></script>'.
                      '<script type="text/javascript">'.
                          '         var abcRazorpay_handler_paid= false;'.
                          '</script><!--/noptimize-->'.
                      '<input type="hidden" name="ahb_Razorpay_payment_id" id="ahb_Razorpay_payment_id" value="" />'.
                      '<input type="hidden" name="ahb_Razorpay_order_id" id="ahb_Razorpay_order_id" value="" />'.
                      '<input type="hidden" name="ahb_Razorpay_signature" id="ahb_Razorpay_signature" value="" />'.
			        '</div>'.$checkscript;

			$form_code = preg_replace( '/<!--addons-payment-fields-->/i', '<!--addons-payment-fields-->'.$code, $form_code );

            $Razorpaylabel = $rows[0]->Razorpay_optionlabel;
            if (!$Razorpaylabel) 
                $Razorpaylabel = __('Pay with Razorpay', 'cpabc');
                
			// output radio-buttons here
			$form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" id="apphbaddonidtp'.$id.'" vt="'.$this->addonID.'" value="'.$this->addonID.'" checked> '.__($Razorpaylabel, 'cpabc').'</div>', $form_code );

           // if (($rows[0]->enabled == '2' || $rows[0]->enabled == '4') && !strpos($form_code,'bccf_payment_option_paypal" vt="0') )
		   //    $form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" vt="0" value="0"> '.__( cpabc_get_option ('enable_paypal_option_no','Pay later'), 'cpabc').'</div>', $form_code );

			if (substr_count ($form_code, 'name="bccf_payment_option_paypal"') > 1)
			    $form_code = str_replace( 'id="field-c0" style="display:none">', 'id="field-c0">', $form_code);

            return $form_code;
		} // End insert_payment_fields
  

		/**
         * process payment
         */
		public function pp_Razorpay(&$params)
		{
            global $wpdb;

			// documentation: https://goo.gl/w3kKoH

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID)
			    return;
            
            $params["payment_type"] = $this->name;
            $params["paid"] = '1';
            
            $params["Razorpay_payment_id"] = $_POST["ahb_Razorpay_payment_id"];
            $params["Razorpay_order_id"] = $_POST["ahb_Razorpay_order_id"];
            $params["Razorpay_signature"] = $_POST["ahb_Razorpay_signature"];

		} // end pp_Razorpay
        

        function pp_Razorpay_redirect($params)
        {
            global $wpdb;
            $row = $wpdb->get_row(
				$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
			);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (
				empty( $row )  ||
				!$row->enabled ||
				$payment_option != $this->addonID
			) return;
            
            
            $amount = $params["final_price"];
            if (!floatval($amount))
                return;              

            return; // nothing here so far
        }
        
        
        private function completeAndRedirect($itemnumber)
        {
            global $wpdb;
            
            // mark item as paid
            if (!is_array($itemnumber))
                $itemnumber = explode(";",$itemnumber);
            $myrows = $wpdb->get_results( "SELECT * FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".intval($itemnumber[0]) ); 
            
            if (empty( $myrows ))
			   return;            
            $params = unserialize($myrows[0]->buffered_date);
            
			$myrowscheck = $wpdb->get_results( "SELECT * FROM ".CPABC_TDEAPP_CALENDAR_DATA_TABLE." WHERE reference='".intval($itemnumber[0])."'" );
            if (!count($myrowscheck))
            {
                $params["paid"] = '1';
                $params["payment_type"] = "Razorpay";
                
                $wpdb->query( $wpdb->prepare("UPDATE  ".CPABC_APPOINTMENTS_TABLE_NAME." SET buffered_date=%s WHERE id=%d", serialize($params), intval($itemnumber[0])) );
                
                cpabc_process_ready_to_go_appointment($_GET["inumber"]);
            } 

            $redirect = true;
            
		    /**
		     * Filters applied to decide if the website should be redirected to the thank you page after submit the form,
		     * pass a boolean as parameter and returns a boolean
		     */
            $redirect = apply_filters( 'cpabc_redirect', $redirect );
            if( $redirect )
            {
                header("Location: ".cpabc_get_option('url_ok', CPABC_APPOINTMENTS_DEFAULT_OK_URL));
                exit;
            }         
        }

		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}


        /**
         * script process payment
         */
		public function pp_Razorpay_check_price()
		{
            global $wpdb;
            
            if (!isset($_POST["abcRazorpay_getprice"]) || !isset($_POST["formid"]))
                return;

            $form_id = intval($_POST["formid"]);

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return;
            
            $price = floatval($_POST["basecost"]);
            
			$params = array(
				"amount" => round($price,2) * 100,
                "currency" => "INR",
                "receipt" => substr(md5(time()),0,5)."_".mt_rand(1000000,9999999)
			);

			$args = array(
				'headers' 	=> array(
                    'Authorization' => 'Basic '. base64_encode( $rows[0]->Razorpay_key.':'.$rows[0]->Razorpay_secretkey ),
					'Content-Type' => 'application/json'
				),
				'body' 		=> json_encode($params),
				'timeout' 	=> 45,
				'sslverify'	=> false,
			);

			$request = wp_remote_post(
				'https://api.Razorpay.com/v1/orders',
				$args
			);
            
            if(!is_wp_error($request))
            {
                $response_body = wp_remote_retrieve_body($request);
				$body = json_decode($response_body);
                if (isset($body->error) && isset($body->error->code))
                    echo 'RRRAHB:-1 '.$body->error->description;
                else
                    echo 'RRRAHB:'.(round($price,2) * 100).' '.$body->id; // return  in cents    
            }
            else
                echo 'RRRAHB:-1 '.$request->get_error_message();

			exit;

         }



		/**
         * script process payment
         */
		public function pp_payments_script( $form_sequence_id, $form_id )
		{
            global $wpdb;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return;
            

?>
            if (!abcRazorpay_handler_paid && $dexQuery("input[name='bccf_payment_option_paypal']:checked").val() == '<?php echo $this->addonID; ?>')
            {
                var charge_price = abc_cost;
                if (charge_price > 0)
                {                    
                    var emailvalue = '';                   
                    $dexQuery.ajax({
                        type: "POST",
                        url: '<?php echo cpabc_appointment_get_FULL_site_url(); ?>/',
                        data: "abcRazorpay_getprice=1&formid=<?php echo $form_id; ?>&basecost="+charge_price+"&em="+emailvalue,
                        success: function(data)
                        {
                            var finalprice = data.substring(data.indexOf('RRRAHB:')+7);
                            finalprice = finalprice.trim();
                            var orderid = finalprice.substring(finalprice.indexOf(' ')+1);
                            var finalprice = finalprice.substring(0,finalprice.indexOf(' '));
                            if (finalprice > 0)
                            {
                                var emailvalue = '';                              
var options = {
    "key": "<?php echo str_replace('"','\"',$rows[0]->Razorpay_key); ?>", 
    "amount": finalprice, /** Amount is in currency subunits. Default currency is INR. Hence, 50000 refers to 50000 paise */
    "currency": "<?php echo $rows[0]->currency; ?>",
    "name": "<?php echo str_replace('"','\"',$rows[0]->Razorpay_subtitle); ?>",
    "description": "<?php echo str_replace('"','\"', cpabc_get_option('paypal_product_name', CPABC_APPOINTMENTS_DEFAULT_PRODUCT_NAME)); ?>",
    "image": "<?php echo str_replace('"','\"',$rows[0]->Razorpay_logoimage); ?>",
    "order_id": orderid, 
    "handler": function (response){
        document.getElementById("ahb_Razorpay_payment_id").value = response.razorpay_payment_id;
        document.getElementById("ahb_Razorpay_order_id").value = response.razorpay_order_id;
        document.getElementById("ahb_Razorpay_signature").value = response.razorpay_signature;
        abcRazorpay_handler_paid = true;
        $dexQuery( ".pbSubmit" ).trigger( "click" );    
    },
    "prefill": {
        "email": emailvalue,
    },    
    "theme": {
        "color": "#3399cc"
    }
};
var rzp1 = new Razorpay(options);
rzp1.on('payment.failed', function (response){        
        alert('Razorpay error: '+response.error.description); /** response.error.reason */
});
rzp1.open();
                            }
                            else
                                if (finalprice == '0')
                                {
                                    abcRazorpay_handler_paid = true;
                                    $dexQuery("#cp_contactformpp_pform").find( '.ignore' ).parents( '.fields' ).remove(); 
                                    document.getElementById("form_structure").value = ''; 
                                    document.getElementById("cp_contactformpp_pform").submit();
                                }
                                else
                                    alert('Razorpay: '+orderid);
                        }
                    });                  
                    return false;
                }
            }
<?php
        }


        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL", $table = '')
        {
            global $wpdb;
            if ($table == '')
                $table = $this->form_table;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }

		/**
		 *	Delete the form from the addon's table
		 */
        public function delete_form( $formid)
		{
			global $wpdb;
			$wpdb->delete( $wpdb->prefix.$this->form_table, array('formid' => $formid), '%d' );
		} // delete_form

        		/**
		 *	Clone the form's row
		 */
		public function clone_form( $original_form_id, $new_form_id )
		{
			global $wpdb;

			$form_rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $original_form_id ), ARRAY_A);

			if(!empty($form_rows))
			{
				foreach($form_rows as $form_row)
				{
					unset($form_row["id"]);
					$form_row["formid"] = $new_form_id;
					$wpdb->insert( $wpdb->prefix.$this->form_table, $form_row);
				}
			}
		} // End clone_form

		/**
		 *	It is called when the form is exported to export the addons data too.
		 *  Receive an array with the other addons data, and the form's id for filtering.
		 */
		public function export_form($addons_array, $formid)
		{
			global $wpdb;
			$rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ), ARRAY_A );
			if(!empty($rows))
			{
				$addons_array[ $this->addonID ] = array();
				foreach($rows as $row)
				{
					unset($row['id']);
					unset($row['formid']);
					$addons_array[ $this->addonID ][] = $row;
				}
			}
			return $addons_array;
		} // End export_form

		/**
		 *	It is called when the form is imported to import the addons data too.
		 *  Receive an array with all the addons data, and the new form's id.
		 */
		public function import_form($addons_array, $formid)
		{
			global $wpdb;
			if(isset($addons_array[$this->addonID]))
			{
				foreach($addons_array[$this->addonID] as $row)
				{
					if(!empty($row))
					{
						$row['formid'] = $formid;
						$wpdb->insert(
							$wpdb->prefix.$this->form_table,
							$row
						);
					}
				}
			}
		} // End import_form


    } // End Class

    // Main add-on code
    $CPABC_Razorpay_obj = new CPABC_Razorpay();

    global $cpabc_addons_objs_list;
	$cpabc_addons_objs_list[ $CPABC_Razorpay_obj->get_addon_id() ] = $CPABC_Razorpay_obj;
}
?>