<?php
/*
Documentation: https://github.com/square/connect-api-examples/tree/master/connect-examples/v2/php_payment
               https://docs.connect.squareup.com/payments/online-payments
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPABC_Square' ) )
{
    class CPABC_Square extends CPABC_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-Square-20200927";
		protected $name = "Square API";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;

			// Insertion in database
			if(
				isset( $_REQUEST[ 'cpabc_square_id' ] )
			)
			{
                //$this->add_field_verify ('square_accesstoken', "varchar(255) DEFAULT '' NOT NULL");
                //$this->add_field_verify ('mode', "varchar(255) DEFAULT '0' NOT NULL");
                
			    // verify needed fields for update
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									'square_key'	 => $_REQUEST["square_key"],
                                    'square_locationid'	 => $_REQUEST["square_locationid"],
									'square_secretkey'	 => $_REQUEST["square_secretkey"],
                                    'square_accesstoken'	 => $_REQUEST["square_accesstoken"],
                                    
									'enabled'	 => $_REQUEST["Square_enabled"],
                                    'mode'	 => $_REQUEST["square_mode"],
                                    'currency'	 => $_REQUEST["Square_currency"],
                                    
									'frequency'	 => $_REQUEST["Square_frequency"]."",
									'trialdays'	 => $_REQUEST["Square_trialdays"]."",
									'planname'	 => $_REQUEST["Square_planname"]."",
                                    
								),
								array( '%d', '%s', '%s', '%s', '%s', 
                                             '%s', '%s', '%s', 
                                             '%s', '%s', '%s')
							);       
			}


			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
           
			if (!count($rows))
			{
			    $row["square_key"] = "";
                $row["square_locationid"] = "";
			    $row["square_secretkey"] = "";
                $row["square_accesstoken"] = "";
			    $row["enabled"] = "0";
			    $row["frequency"] = "";
			    $row["trialdays"] = "0";
			    $row["planname"] = "0";
                $row["mode"] = "0";
                $row["currency"] = "USD";
			} else {
			    $row["square_key"] = $rows[0]->square_key;
                $row["square_locationid"] = $rows[0]->square_locationid;
			    $row["square_secretkey"] = $rows[0]->square_secretkey;
                $row["square_accesstoken"] = $rows[0]->square_accesstoken;
			    $row["enabled"] = $rows[0]->enabled;
			    $row["frequency"] = $rows[0]->frequency;
			    $row["trialdays"] = $rows[0]->trialdays;
			    $row["planname"] = $rows[0]->planname;
                $row["currency"] = $rows[0]->currency;
                $row["mode"] = $rows[0]->mode;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="cpabc_square_id" value="1" />
                   <table class="form-table">
                    <tr valign="top">
                    <th scope="row"><?php _e('Enable Square?', 'cpabc'); ?></th>
                    <td><select name="Square_enabled">
                         <option value="0" <?php if (!$row["enabled"]) echo 'selected'; ?>><?php _e('No', 'cpabc'); ?></option>
                         <option value="1" <?php if ($row["enabled"]) echo 'selected'; ?>><?php _e('Yes', 'cpabc'); ?></option>
                         <option value="2" <?php if ($row["enabled"] == '2') echo 'selected'; ?>><?php _e('Optional: This payment method + Pay Later (submit without payment)', 'cpabc'); ?></option>
                         <option value="3" <?php if ($row["enabled"] == '3') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods (enabled)', 'cpabc'); ?></option>
                         <option value="4" <?php if ($row["enabled"] == '4') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods  + Pay Later ', 'cpabc'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row">Squareup.com <?php _e('Application ID', 'cpabc'); ?></th>
                    <td><input type="text" name="square_key" size="20" value="<?php echo esc_attr($row["square_key"]); ?>" /></td>
                    </tr>                           
                    <tr valign="top">
                    <th scope="row">Squareup.com <?php _e('Access Token', 'cpabc'); ?></th>
                    <td><input type="text" name="square_accesstoken" size="20" value="<?php echo esc_attr($row["square_accesstoken"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row">Squareup.com <?php _e('Application Secret', 'cpabc'); ?></th>
                    <td><input type="text" name="square_secretkey" size="20" value="<?php echo esc_attr($row["square_secretkey"]); ?>" /></td>
                    </tr>                    
                    <tr valign="top">
                    <th scope="row">Squareup.com <?php _e('Location ID', 'cpabc'); ?></th>
                    <td><input type="text" name="square_locationid" size="20" value="<?php echo esc_attr($row["square_locationid"]); ?>" /></td>
                    </tr>                      
                    <tr valign="top">
                    <th scope="row"><?php _e('Square - Currency', 'cpabc'); ?></th>
                    <td><input type="text" name="Square_currency" size="20" value="<?php echo esc_attr($row["currency"]); ?>" /></td>
                    </tr>                    
                    <tr valign="top">        
                    <th scope="row"><?php _e('Square Mode', 'cpabc'); ?></th>
                    <td><select name="square_mode">
                         <option value="1" <?php if ($row["mode"] != '0') echo 'selected'; ?>>Production - real payments processed</option> 
                         <option value="0" <?php if ($row["mode"] == '0') echo 'selected'; ?>>SandBox - Square testing sandbox area</option> 
                        </select>
                    </td>
                    </tr>                      
<!--                    <tr valign="top" style="display:none">
                    <th scope="row"><?php _e('Payment frequency?', 'cpabc'); ?></th>
                    <td><select name="Square_frequency">
                         <option value="" <?php if (!$row["frequency"]) echo 'selected'; ?>><?php _e('One time payment', 'cpabc'); ?></option>
                         <option value="day" <?php if ($row["frequency"] == 'day') echo 'selected'; ?>><?php _e('Daily (subcription)', 'cpabc'); ?></option>
                         <option value="week" <?php if ($row["frequency"] == 'week') echo 'selected'; ?>><?php _e('Weekly (subscription)', 'cpabc'); ?></option>
                         <option value="month" <?php if ($row["frequency"] == 'month') echo 'selected'; ?>><?php _e('Monthly (subscription)', 'cpabc'); ?></option>
                         <option value="year" <?php if ($row["frequency"] == 'year') echo 'selected'; ?>><?php _e('Yearly (subscription)', 'cpabc'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top" style="display:none">
                    <th scope="row"><?php _e('Trial period length in days for subscription payments', 'cpabc'); ?></th>
                    <td><input type="text" name="Square_trialdays" size="50" value="<?php echo esc_attr($row["trialdays"]); ?>" /></td>
                    </tr>
                    <tr valign="top" style="display:none">
                    <th scope="row"><?php _e('Plan name for subscription payments', 'cpabc'); ?></th>
                    <td><input type="text" name="Square_planname" size="20" value="<?php echo esc_attr($row["planname"]); ?>" /></td>
                    </tr>
-->                    
                   </table>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpabc_square';
        private $form_table_plans = 'cpabc_squareplans';
        private $form_table_customers = 'cpabc_squarecustomers';
        private $_inserted = false;
		private $_apphbmain;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			
			$this->description = __("The add-on adds support for Square API payments (squareup.com, credit card fields in your website)", 'cpabc' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            if (!is_admin())
            {
			        add_action( 'cpabc_process_data_before_insert', array( &$this, 'pp_Square' ), 11, 1 );
                    
			        add_action( 'cpabc_process_data', array( &$this, 'pp_Square_redirect' ), 11, 1 );                                
                        
			        add_action( 'init', array( &$this, 'pp_Square_check_price' ), 11 );

			        add_action( 'cpabc_script_after_validation', array( &$this, 'pp_payments_script' ), 10, 2 );
                    
			        add_filter( 'cpabc_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );
                    
                    add_action( 'wp_footer', array( &$this, 'insert_javascript' ), 99 );
            }
			else
			{
				// Delete forms
				add_action( 'apphb_delete_form', array(&$this, 'delete_form') );

				// Clone forms
				add_action( 'apphb_clone_form', array(&$this, 'clone_form'), 10, 2 );

				// Export addon data
				add_action( 'apphb_export_addons', array(&$this, 'export_form'), 10, 2 );

				// Import addon data
				add_action( 'apphb_import_addons', array(&$this, 'import_form'), 10, 2 );
			}

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					enabled varchar(10) DEFAULT '0' NOT NULL ,
					square_key varchar(255) DEFAULT '' NOT NULL ,
                    square_locationid varchar(255) DEFAULT '' NOT NULL ,
					square_secretkey varchar(255) DEFAULT '' NOT NULL ,
					frequency varchar(30) DEFAULT '' NOT NULL ,
					trialdays varchar(20) DEFAULT '' NOT NULL ,
					planname varchar(255) DEFAULT '' NOT NULL ,
                    currency varchar(255) DEFAULT '' NOT NULL ,
                    square_accesstoken varchar(255) DEFAULT '' NOT NULL ,
                    mode varchar(255) DEFAULT '0' NOT NULL ,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
            $wpdb->query($sql);

			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table_plans." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					planname varchar(255) DEFAULT '' NOT NULL ,
					planinterval varchar(255) DEFAULT '' NOT NULL ,
					currency varchar(30) DEFAULT '' NOT NULL ,
					amount varchar(20) DEFAULT '' NOT NULL ,
					trial_period_days varchar(20) DEFAULT '' NOT NULL,
					planresult TEXT DEFAULT '' NOT NULL,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
			$wpdb->query($sql);

			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table_customers." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					email varchar(255) DEFAULT '' NOT NULL ,
					source varchar(255) DEFAULT '' NOT NULL ,
					customer_id varchar(255) DEFAULT '' NOT NULL ,
					customerresult TEXT DEFAULT '' NOT NULL,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
			$wpdb->query($sql);

		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
         * Inserts banks and Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb;

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return $form_code;

            
            $checkscript = '';

            $code = '<div class="sq-payment-form">
    <div id="sq-walletbox">
      <button id="sq-google-pay" class="button-google-pay"></button>
      <button id="sq-apple-pay" class="sq-apple-pay"></button>
      <button id="sq-masterpass" class="sq-masterpass"></button>
      <div class="sq-wallet-divider">
        <span class="sq-wallet-divider__text">Or</span>
      </div>
    </div>
    <div id="sq-ccbox">
        <div class="sq-field">
          <label class="sq-label">Card Number</label>
          <div id="sq-card-number"></div>
        </div>
        <div class="sq-field-wrapper">
          <div class="sq-field sq-field--in-wrapper">
            <label class="sq-label">CVV</label>
            <div id="sq-cvv"></div>
          </div>
          <div class="sq-field sq-field--in-wrapper">
            <label class="sq-label">Expiration</label>
            <div id="sq-expiration-date"></div>
          </div>
          <div class="sq-field sq-field--in-wrapper" id="ahbsqpostalcode">
            <label class="sq-label">Post Code</label>
            <div id="sq-postal-code"></div>
          </div>
        </div>
        <div id="error"></div>
        <input type="hidden" id="card-nonce" name="sqnonce">
    </div>
  </div>';

            $codejs = $this->getSquareJS($rows[0]->square_key, $rows[0]->square_locationid, $rows[0]->currency, $id, $rows[0]->mode);


			$form_code = preg_replace( '/<!-- rcadon -->/i', '<!-- rcadon -->'.$code, $form_code );
            
            $form_code = str_replace( '</form>', '</form>'.$codejs, $form_code );

			// output radio-buttons here
			$form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" id="apphbaddonsquare" vt="'.$this->addonID.'" value="'.$this->addonID.'" checked> '.__('Pay with Credit Cards', 'cpabc').'</div>', $form_code );

            if (($rows[0]->enabled == '2' || $rows[0]->enabled == '4') && !strpos($form_code,'bccf_payment_option_paypal" vt="0') )
			    $form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" vt="0" value="0"> '.__( CPABC_APPOINTMENTS_DEFAULT_PAYPAL_OPTION_NO, 'cpabc').'</div>', $form_code );

			if (substr_count ($form_code, 'name="bccf_payment_option_paypal"') > 1)
			    $form_code = str_replace( 'id="field-c0" style="display:none">', 'id="field-c0">', $form_code);

            return $form_code;
		} // End insert_payment_fields


        private function getSquareJS($appid, $locid, $currency = 'USD', $id = '', $mode = '')
        {
            return ' <script type="text/javascript" src="'.($mode?"https://js.squareup.com/v2/paymentform":"https://js.squareupsandbox.com/v2/paymentform").'"></script><script type="text/javascript">
            window.applicationId = "'.$appid.'";
            window.locationId = "'.$locid.'";</script><script src="'.plugins_url('/square.addon/js/sq-payment-form.js?nc=1', __FILE__ ).'"></script><link rel="stylesheet" type="text/css" href="'.plugins_url('/square.addon/css/sq-payment-form.css', __FILE__ ).'">'.
            '<script type="text/javascript">
            function cpabc_square_submit() {                
                cpabc_blink(".pbSubmit:visible");
                $dexQuery=jQuery.noConflict();
                $dexQuery(".pbSubmit:visible").off("click");
                $dexQuery("#cp_contactformpp_pform").find( ".ignore" ).closest( ".fields" ).remove();
                document.getElementById("cp_contactformpp_pform").submit();
            }
                </script>';         
        }
        
		public function insert_javascript()
		{			
//				echo '<link href="'.plugins_url('/square.addon/css.css', __FILE__ ).'"  rel="stylesheet" type="text/css" />';
				//echo '<script src="'.plugins_url('/square.addon/js.js', __FILE__ ).'"></script>';				
        }            
        
		/**
         * process payment
         */
		public function pp_Square(&$params)
		{
            global $wpdb;

			// documentation: https://goo.gl/w3kKoH

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID)
			    return;            
            
            $amount = round($params["final_price"]*100,0);
            
            if (!$amount)
                return;            

            $notifyto = cpabc_get_option('cu_user_email_field', CPABC_APPOINTMENTS_DEFAULT_cu_user_email_field);
            $notifyto = $params[ $notifyto ];
                    
            // **************           
     
            try {
                
                if (!class_exists('\SquareConnect\Configuration'))
                    require_once dirname( __FILE__ ) . '/square.addon/vendor/autoload.php';
                
                $access_token = $rows[0]->square_accesstoken;
                $host_url = $rows[0]->mode  ?  "https://connect.squareup.com"
                                           :  "https://connect.squareupsandbox.com";
                $api_config = new \SquareConnect\Configuration();
                $api_config->setHost($host_url);
                # Initialize the authorization for Square
                $api_config->setAccessToken($access_token);
                $api_client = new \SquareConnect\ApiClient($api_config);
                $nonce = $_POST['sqnonce'];
                
                $payments_api = new \SquareConnect\Api\PaymentsApi($api_client);
                
                $request_body = array (
                  "source_id" => $nonce,
                  // Monetary amounts are specified in the smallest unit of the applicable currency.
                  // This amount is in cents. It's also hard-coded for $1.00, which isn't very useful.
                  "amount_money" => array (
                    "amount" => $amount,
                    "currency" => $rows[0]->currency
                  ),
                  // Every payment you process with the SDK must have a unique idempotency key.
                  // If you're unsure whether a particular payment succeeded, you can reattempt
                  // it with the same idempotency key without worrying about double charging
                  // the buyer.
                  "idempotency_key" => uniqid(),
                  "note" => $notifyto
                );                 
                
                try {
                    $result = $payments_api->createPayment($request_body);                    
                } catch (\SquareConnect\ApiException $e) {
                                echo '<p>Square: Failed to process credit card. Error message: <strong>'. $e->getResponseBody()->errors[0]->detail.'</strong></p>';
                                echo '<p>Please <a href="javascript:window.history.back();">go back and try again</a>.</p>';
                                //print_r("<strong>Response body:</strong><br/>");
                                //echo "<pre>"; var_dump($e->getResponseBody()); echo "</pre>";
                                //echo "<br/><strong>Response headers:</strong><br/>";
                                //echo "<pre>"; var_dump($e->getResponseHeaders()); echo "</pre>";                                
                                exit;    
                }    
            
                $params["payment_type"] = $this->name;
                $params["paid"] = '1';            
                
            } 
            catch (Exception $e)
            {
                echo '<p>Square: Failed to process credit card. Error message: '. $e->getMessage().'</p>';
                echo '<p>Please <a href="javascript:window.history.back();">go back and try again</a>.</p>';
                exit;
            }          


		} // end pp_Square

        
        function pp_Square_redirect($params)
        {
            global $wpdb;
            $row = $wpdb->get_row(
				$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
			);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (
				empty( $row )  ||
				!$row->enabled ||
				$payment_option != $this->addonID
			) return;

			// mark item as paid
            $myrows = $wpdb->get_results( $wpdb->prepare("SELECT * FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=%d", $params["itemnumber"]) );
            if (empty( $myrows ))
			   return;
            
            $params["paid"] = '1';
            $params["payment_type"] = "Square";
            
            $wpdb->query( $wpdb->prepare("UPDATE  ".$wpdb->prefix.CPABC_APPOINTMENTS_TABLE_NAME." SET buffered_date=%s WHERE id=%d", serialize($params), $params["itemnumber"]) );
            
            cpabc_process_ready_to_go_appointment(implode(";", $params["itemnumbers"]));
            
            $redirect = true;
            
		    /**
		     * Filters applied to decide if the website should be redirected to the thank you page after submit the form,
		     * pass a boolean as parameter and returns a boolean
		     */
            $redirect = apply_filters( 'cpabc_redirect', $redirect );
            if( $redirect )
            {
                header("Location: ".cpabc_get_option('url_ok', CPABC_APPOINTMENTS_DEFAULT_OK_URL));
                exit;
            }
            
        }

		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}


        /**
         * script process payment
         */
		public function pp_Square_check_price()
		{
            global $wpdb;

            if (!isset($_POST["apphbSquare_getprice"]) || !isset($_POST["formid"]))
                return;

            $form_id = intval($_POST["formid"]);

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return;

	        $price = apply_filters( 'cpabc_calculate_price', $_POST["basecost"], $form_id );

			echo round($price,2);
			exit;

         }



		/**
         * script process payment
         */
		public function pp_payments_script( $form_sequence_id, $form_id )
		{
            global $wpdb;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return;

?> 
            if (!$dexQuery("#card-nonce").val() && (!$dexQuery("#apphbaddonsquare").length || $dexQuery("input[name='bccf_payment_option_paypal']:checked").val() == '<?php echo $this->addonID; ?>'))
            {
                if (abc_cost > 0)
                {
                    cpabc_blink(".pbSubmit:visible");
                    window.applicationprice = abc_cost;  
                    window.applicationcurrency = '<?php echo $rows[0]->currency; ?>';                                  
                    onGetCardNonce(event);
                    return false;
                }
            }
<?php
        }


        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL", $table = '')
        {
            global $wpdb;
            if ($table == '')
                $table = $this->form_table;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }

		/**
		 *	Delete the form from the addon's table
		 */
        public function delete_form( $formid)
		{
			global $wpdb;
			$wpdb->delete( $wpdb->prefix.$this->form_table, array('formid' => $formid), '%d' );
		} // delete_form

        		/**
		 *	Clone the form's row
		 */
		public function clone_form( $original_form_id, $new_form_id )
		{
			global $wpdb;

			$form_rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $original_form_id ), ARRAY_A);

			if(!empty($form_rows))
			{
				foreach($form_rows as $form_row)
				{
					unset($form_row["id"]);
					$form_row["formid"] = $new_form_id;
					$wpdb->insert( $wpdb->prefix.$this->form_table, $form_row);
				}
			}
		} // End clone_form

		/**
		 *	It is called when the form is exported to export the addons data too.
		 *  Receive an array with the other addons data, and the form's id for filtering.
		 */
		public function export_form($addons_array, $formid)
		{
			global $wpdb;
			$rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ), ARRAY_A );
			if(!empty($rows))
			{
				$addons_array[ $this->addonID ] = array();
				foreach($rows as $row)
				{
					unset($row['id']);
					unset($row['formid']);
					$addons_array[ $this->addonID ][] = $row;
				}
			}
			return $addons_array;
		} // End export_form

		/**
		 *	It is called when the form is imported to import the addons data too.
		 *  Receive an array with all the addons data, and the new form's id.
		 */
		public function import_form($addons_array, $formid)
		{
			global $wpdb;
			if(isset($addons_array[$this->addonID]))
			{
				foreach($addons_array[$this->addonID] as $row)
				{
					if(!empty($row))
					{
						$row['formid'] = $formid;
						$wpdb->insert(
							$wpdb->prefix.$this->form_table,
							$row
						);
					}
				}
			}
		} // End import_form


    } // End Class

    // Main add-on code
    $cpabc_square_obj = new CPABC_Square();

    global $cpabc_addons_objs_list;
	$cpabc_addons_objs_list[ $cpabc_square_obj->get_addon_id() ] = $cpabc_square_obj;
}
?>