<?php
/*
Documentation: https://github.com/square/connect-api-examples
               https://developer.squareup.com/docs/checkout-api-overview
               files C:\TORRE_F\temp\borrar\borrar\abc\Models\
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPABC_SquareCheckout' ) )
{
    class CPABC_SquareCheckout extends CPABC_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-SquareCheckout-20200927";
		protected $name = "Square Checkout";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;

			// Insertion in database
			if(
				isset( $_REQUEST[ 'cpabc_SquareCheckout_id' ] )
			)
			{
                //$this->add_field_verify ('SquareCheckout_accesstoken', "varchar(255) DEFAULT '' NOT NULL");
                //$this->add_field_verify ('mode', "varchar(255) DEFAULT '0' NOT NULL");
                
			    // verify needed fields for update
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
									'SquareCheckout_key'	 => $_REQUEST["SquareCheckout_key"],
                                    'SquareCheckout_locationid'	 => $_REQUEST["SquareCheckout_locationid"],
									'SquareCheckout_secretkey'	 => $_REQUEST["SquareCheckout_secretkey"],
                                    'SquareCheckout_accesstoken'	 => $_REQUEST["SquareCheckout_accesstoken"],
                                    
									'enabled'	 => $_REQUEST["SquareCheckout_enabled"],
                                    'mode'	 => $_REQUEST["SquareCheckout_mode"],
                                    'currency'	 => $_REQUEST["SquareCheckout_currency"],
                                    
									'frequency'	 => $_REQUEST["SquareCheckout_frequency"]."",
									'trialdays'	 => $_REQUEST["SquareCheckout_trialdays"]."",
									'planname'	 => $_REQUEST["SquareCheckout_planname"]."",
                                    
								),
								array( '%d', '%s', '%s', '%s', '%s', 
                                             '%s', '%s', '%s', 
                                             '%s', '%s', '%s')
							);       
			}


			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
           
			if (!count($rows))
			{
			    $row["SquareCheckout_key"] = "";
                $row["SquareCheckout_locationid"] = "";
			    $row["SquareCheckout_secretkey"] = "";
                $row["SquareCheckout_accesstoken"] = "";
			    $row["enabled"] = "0";
			    $row["frequency"] = "";
			    $row["trialdays"] = "0";
			    $row["planname"] = "0";
                $row["mode"] = "0";
                $row["currency"] = "USD";
			} else {
			    $row["SquareCheckout_key"] = $rows[0]->SquareCheckout_key;
                $row["SquareCheckout_locationid"] = $rows[0]->SquareCheckout_locationid;
			    $row["SquareCheckout_secretkey"] = $rows[0]->SquareCheckout_secretkey;
                $row["SquareCheckout_accesstoken"] = $rows[0]->SquareCheckout_accesstoken;
			    $row["enabled"] = $rows[0]->enabled;
			    $row["frequency"] = $rows[0]->frequency;
			    $row["trialdays"] = $rows[0]->trialdays;
			    $row["planname"] = $rows[0]->planname;
                $row["currency"] = $rows[0]->currency;
                $row["mode"] = $rows[0]->mode;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="cpabc_SquareCheckout_id" value="1" />
                   <table class="form-table">
                    <tr valign="top">
                    <th scope="row"><?php _e('Enable SquareCheckout?', 'cpabc'); ?></th>
                    <td><select name="SquareCheckout_enabled">
                         <option value="0" <?php if (!$row["enabled"]) echo 'selected'; ?>><?php _e('No', 'cpabc'); ?></option>
                         <option value="1" <?php if ($row["enabled"]) echo 'selected'; ?>><?php _e('Yes', 'cpabc'); ?></option>
                         <option value="2" <?php if ($row["enabled"] == '2') echo 'selected'; ?>><?php _e('Optional: This payment method + Pay Later (submit without payment)', 'cpabc'); ?></option>
                         <option value="3" <?php if ($row["enabled"] == '3') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods (enabled)', 'cpabc'); ?></option>
                         <option value="4" <?php if ($row["enabled"] == '4') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods  + Pay Later ', 'cpabc'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row">Squareup.com <?php _e('Application ID', 'cpabc'); ?></th>
                    <td><input type="text" name="SquareCheckout_key" size="20" value="<?php echo esc_attr($row["SquareCheckout_key"]); ?>" /></td>
                    </tr>                           
                    <tr valign="top">
                    <th scope="row">Squareup.com <?php _e('Access Token', 'cpabc'); ?></th>
                    <td><input type="text" name="SquareCheckout_accesstoken" size="20" value="<?php echo esc_attr($row["SquareCheckout_accesstoken"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row">Squareup.com <?php _e('Application Secret', 'cpabc'); ?></th>
                    <td><input type="text" name="SquareCheckout_secretkey" size="20" value="<?php echo esc_attr($row["SquareCheckout_secretkey"]); ?>" /></td>
                    </tr>                    
                    <tr valign="top">
                    <th scope="row">Squareup.com <?php _e('Location ID', 'cpabc'); ?></th>
                    <td><input type="text" name="SquareCheckout_locationid" size="20" value="<?php echo esc_attr($row["SquareCheckout_locationid"]); ?>" /></td>
                    </tr>                      
                    <tr valign="top">
                    <th scope="row"><?php _e('Square - Currency', 'cpabc'); ?></th>
                    <td><input type="text" name="SquareCheckout_currency" size="20" value="<?php echo esc_attr($row["currency"]); ?>" /></td>
                    </tr>                    
                    <tr valign="top">        
                    <th scope="row"><?php _e('Square Mode', 'cpabc'); ?></th>
                    <td><select name="SquareCheckout_mode">
                         <option value="1" <?php if ($row["mode"] != '0') echo 'selected'; ?>>Production - real payments processed</option> 
                         <option value="0" <?php if ($row["mode"] == '0') echo 'selected'; ?>>SandBox - Square testing sandbox area</option> 
                        </select>
                    </td>
                    </tr>                      
<!--                    <tr valign="top" style="display:none">
                    <th scope="row"><?php _e('Payment frequency?', 'cpabc'); ?></th>
                    <td><select name="SquareCheckout_frequency">
                         <option value="" <?php if (!$row["frequency"]) echo 'selected'; ?>><?php _e('One time payment', 'cpabc'); ?></option>
                         <option value="day" <?php if ($row["frequency"] == 'day') echo 'selected'; ?>><?php _e('Daily (subcription)', 'cpabc'); ?></option>
                         <option value="week" <?php if ($row["frequency"] == 'week') echo 'selected'; ?>><?php _e('Weekly (subscription)', 'cpabc'); ?></option>
                         <option value="month" <?php if ($row["frequency"] == 'month') echo 'selected'; ?>><?php _e('Monthly (subscription)', 'cpabc'); ?></option>
                         <option value="year" <?php if ($row["frequency"] == 'year') echo 'selected'; ?>><?php _e('Yearly (subscription)', 'cpabc'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top" style="display:none">
                    <th scope="row"><?php _e('Trial period length in days for subscription payments', 'cpabc'); ?></th>
                    <td><input type="text" name="SquareCheckout_trialdays" size="50" value="<?php echo esc_attr($row["trialdays"]); ?>" /></td>
                    </tr>
                    <tr valign="top" style="display:none">
                    <th scope="row"><?php _e('Plan name for subscription payments', 'cpabc'); ?></th>
                    <td><input type="text" name="SquareCheckout_planname" size="20" value="<?php echo esc_attr($row["planname"]); ?>" /></td>
                    </tr>
-->                    
                   </table>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpabc_SquareCheckout';
        private $form_table_plans = 'cpabc_SquareCheckoutplans';
        private $form_table_customers = 'cpabc_SquareCheckoutcustomers';
        private $_inserted = false;
		private $_apphbmain;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			
			$this->description = __("The add-on adds support for Square Checkout payments (squareup.com, payment at Square hosted page)", 'cpabc' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            if (!is_admin())
            {
			       // add_action( 'cpabc_process_data_before_insert', array( &$this, 'pp_Square' ), 11, 1 );
                    
			        add_action( 'cpabc_process_data', array( &$this, 'pp_Square' ), 11, 1 );  

                    add_action( 'init', array( &$this, 'pp_Square_redirect' ), 10, 1 );                    

			        add_filter( 'cpabc_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );
                    
            }
			else
			{
				// Delete forms
				add_action( 'apphb_delete_form', array(&$this, 'delete_form') );

				// Clone forms
				add_action( 'apphb_clone_form', array(&$this, 'clone_form'), 10, 2 );

				// Export addon data
				add_action( 'apphb_export_addons', array(&$this, 'export_form'), 10, 2 );

				// Import addon data
				add_action( 'apphb_import_addons', array(&$this, 'import_form'), 10, 2 );
			}

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					enabled varchar(10) DEFAULT '0' NOT NULL ,
					SquareCheckout_key varchar(255) DEFAULT '' NOT NULL ,
                    SquareCheckout_locationid varchar(255) DEFAULT '' NOT NULL ,
					SquareCheckout_secretkey varchar(255) DEFAULT '' NOT NULL ,
					frequency varchar(30) DEFAULT '' NOT NULL ,
					trialdays varchar(20) DEFAULT '' NOT NULL ,
					planname varchar(255) DEFAULT '' NOT NULL ,
                    currency varchar(255) DEFAULT '' NOT NULL ,
                    SquareCheckout_accesstoken varchar(255) DEFAULT '' NOT NULL ,
                    mode varchar(255) DEFAULT '0' NOT NULL ,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
            $wpdb->query($sql);

			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table_plans." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					planname varchar(255) DEFAULT '' NOT NULL ,
					planinterval varchar(255) DEFAULT '' NOT NULL ,
					currency varchar(30) DEFAULT '' NOT NULL ,
					amount varchar(20) DEFAULT '' NOT NULL ,
					trial_period_days varchar(20) DEFAULT '' NOT NULL,
					planresult TEXT DEFAULT '' NOT NULL,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
			$wpdb->query($sql);

			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table_customers." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					email varchar(255) DEFAULT '' NOT NULL ,
					source varchar(255) DEFAULT '' NOT NULL ,
					customer_id varchar(255) DEFAULT '' NOT NULL ,
					customerresult TEXT DEFAULT '' NOT NULL,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
			$wpdb->query($sql);

		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
         * Inserts banks and Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb;

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return $form_code;


			// output radio-buttons here
			$form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" id="apphbaddonSquareCheckout" vt="'.$this->addonID.'" value="'.$this->addonID.'" checked> '.__('Pay with Credit Cards', 'cpabc').'</div>', $form_code );

            if (($rows[0]->enabled == '2' || $rows[0]->enabled == '4') && !strpos($form_code,'bccf_payment_option_paypal" vt="0') )
			    $form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" vt="0" value="0"> '.__( CPABC_APPOINTMENTS_DEFAULT_PAYPAL_OPTION_NO, 'cpabc').'</div>', $form_code );

			if (substr_count ($form_code, 'name="bccf_payment_option_paypal"') > 1)
			    $form_code = str_replace( 'id="field-c0" style="display:none">', 'id="field-c0">', $form_code);

            return $form_code;
		} // End insert_payment_fields

        
		/**
         * process payment
         */
		public function pp_Square($params)
		{
            global $wpdb;

			// documentation: https://goo.gl/w3kKoH

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID)
			    return;            
            
            $amount = round($params["final_price"]*100,0);
            
            if (!$amount)
                return;            

            $notifyto = cpabc_get_option('cu_user_email_field', CPABC_APPOINTMENTS_DEFAULT_cu_user_email_field);
            $notifyto = $params[ $notifyto ];
                    
            // **************          
            
            if (!class_exists('\Square\SquareClient'))
                require_once dirname( __FILE__ ) . '/squarecheckout.addon/autoload.php';
                                
            // Initialize the authorization for Square
            $client = new \Square\SquareClient([
              'accessToken' => $rows[0]->SquareCheckout_accesstoken,
              'environment' => ($rows[0]->mode?\Square\Environment::PRODUCTION:\Square\Environment::SANDBOX)
            ]);
            $location_id  =$rows[0]->SquareCheckout_locationid;
            
            // make sure we actually are on a POST with an amount
            // This example assumes the order information is retrieved and hard coded
            // You can find different ways to retrieve order information and fill in the following lineItems object.
            try {
              $checkout_api = $client->getCheckoutApi();
            
              // Monetary amounts are specified in the smallest unit of the applicable currency.
              // This amount is in cents. It's also hard-coded for $1.00, which isn't very useful.
              $money_A = new \Square\Models\Money();
              $money_A->setCurrency($rows[0]->currency);
              $money_A->setAmount($amount);
            
              $item_A = new \Square\Models\OrderLineItem(1);
              $item_A->setName( cpabc_get_option('paypal_product_name', CPABC_APPOINTMENTS_DEFAULT_PRODUCT_NAME) );
              $item_A->setBasePriceMoney($money_A);
            
              // Create a new order and add the line items as necessary.
              $order = new \Square\Models\Order($location_id);
              $order->setLineItems([$item_A]);
            
              $create_order_request = new \Square\Models\CreateOrderRequest();
              $create_order_request->setOrder($order);
            
              // Similar to payments you must have a unique idempotency key.
              $checkout_request = new \Square\Models\CreateCheckoutRequest(uniqid(), $create_order_request);
            
            //echo (cpabc_appointment_get_FULL_site_url().'/?cp_squarecheckout_ipncheck=1&itemnumber='.urlencode(implode(";", $params["itemnumbers"])));exit;
              //Replace with the URL where you want to redirect your customers after transaction.
              $checkout_request->setRedirectUrl( (cpabc_appointment_get_FULL_site_url().'/?cp_squarecheckout_ipncheck=1&itemnumber='.urlencode(implode(";", $params["itemnumbers"]))) );
            
              $response = $checkout_api->createCheckout($location_id, $checkout_request);
            } catch (ApiException $e) {
              // If an error occurs, output the message
              echo 'Caught exception!<br/>';
              echo '<strong>Response body:</strong><br/>';
              echo '<pre>'; var_dump($e->getResponseBody()); echo '</pre>';
              echo '<br/><strong>Context:</strong><br/>';
              echo '<pre>'; var_dump($e->getContext()); echo '</pre>';
              exit();
            }
            
            // If there was an error with the request we will
            // print them to the browser screen here
            if ($response->isError()) {
              echo 'Api response has Errors';
              $errors = $response->getErrors();
              echo '<ul>';
              foreach ($errors as $error) {
                  echo '<li>❌ ' . $error->getDetail() . '</li>';
              }
              echo '</ul>';
              exit();
            }
            
            
            // This redirects to the Square hosted checkout page
            header('Location: '.$response->getResult()->getCheckout()->getCheckoutPageUrl());                
            exit;

		} // end pp_Square

        
        function pp_Square_redirect()
        {
            global $wpdb;
            
            if ( !isset( $_GET['cp_squarecheckout_ipncheck'] ) || $_GET['cp_squarecheckout_ipncheck'] != '1' || !isset( $_GET["itemnumber"] ) 
                 || !isset( $_GET["checkoutId"] )  || !isset( $_GET["transactionId"] ) )
                return;
            
            $itemnumber = explode(";",$_GET["itemnumber"]);            
            $myrows = $wpdb->get_results( "SELECT * FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".intval($itemnumber[0]) ); 
         
            if (empty( $myrows ))
			   return;
           
            $params = unserialize($myrows[0]->buffered_date);
            //print_r($itemnumber ); echo   $_GET["itemnumber"];exit; 
			$myrowscheck = $wpdb->get_results( "SELECT * FROM ".CPABC_TDEAPP_CALENDAR_DATA_TABLE." WHERE reference='".intval($itemnumber[0])."'" );
            if (!count($myrowscheck))
            {
                $params["paid"] = '1';
                $params["payment_type"] = "SquareCheckout";
                $params["SquareCheckoutId"] = $_GET["checkoutId"];
                $params["SquareTransactionId"] = $_GET["transactionId"];
                $params["txnid"] = $_GET["transactionId"];
                
                $wpdb->query( $wpdb->prepare("UPDATE  ".CPABC_APPOINTMENTS_TABLE_NAME." SET buffered_date=%s WHERE id=%d", serialize($params), intval($itemnumber[0])) );
                
                cpabc_process_ready_to_go_appointment($_GET["itemnumber"]);
            }             
            
            $redirect = true;
            
		    /**
		     * Filters applied to decide if the website should be redirected to the thank you page after submit the form,
		     * pass a boolean as parameter and returns a boolean
		     */
            $redirect = apply_filters( 'cpabc_redirect', $redirect );
            if( $redirect )
            {
                header("Location: ".cpabc_get_option('url_ok', CPABC_APPOINTMENTS_DEFAULT_OK_URL));
                exit;
            }
            
        }

		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}



        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL", $table = '')
        {
            global $wpdb;
            if ($table == '')
                $table = $this->form_table;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }

		/**
		 *	Delete the form from the addon's table
		 */
        public function delete_form( $formid)
		{
			global $wpdb;
			$wpdb->delete( $wpdb->prefix.$this->form_table, array('formid' => $formid), '%d' );
		} // delete_form

        		/**
		 *	Clone the form's row
		 */
		public function clone_form( $original_form_id, $new_form_id )
		{
			global $wpdb;

			$form_rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $original_form_id ), ARRAY_A);

			if(!empty($form_rows))
			{
				foreach($form_rows as $form_row)
				{
					unset($form_row["id"]);
					$form_row["formid"] = $new_form_id;
					$wpdb->insert( $wpdb->prefix.$this->form_table, $form_row);
				}
			}
		} // End clone_form

		/**
		 *	It is called when the form is exported to export the addons data too.
		 *  Receive an array with the other addons data, and the form's id for filtering.
		 */
		public function export_form($addons_array, $formid)
		{
			global $wpdb;
			$rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ), ARRAY_A );
			if(!empty($rows))
			{
				$addons_array[ $this->addonID ] = array();
				foreach($rows as $row)
				{
					unset($row['id']);
					unset($row['formid']);
					$addons_array[ $this->addonID ][] = $row;
				}
			}
			return $addons_array;
		} // End export_form

		/**
		 *	It is called when the form is imported to import the addons data too.
		 *  Receive an array with all the addons data, and the new form's id.
		 */
		public function import_form($addons_array, $formid)
		{
			global $wpdb;
			if(isset($addons_array[$this->addonID]))
			{
				foreach($addons_array[$this->addonID] as $row)
				{
					if(!empty($row))
					{
						$row['formid'] = $formid;
						$wpdb->insert(
							$wpdb->prefix.$this->form_table,
							$row
						);
					}
				}
			}
		} // End import_form


    } // End Class

    // Main add-on code
    $cpabc_SquareCheckout_obj = new CPABC_SquareCheckout();

    global $cpabc_addons_objs_list;
	$cpabc_addons_objs_list[ $cpabc_SquareCheckout_obj->get_addon_id() ] = $cpabc_SquareCheckout_obj;
}
?>