<?php
/*
Documentation: https://stripe.com/docs/quickstart
*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPABC_Stripe' ) )
{
    class CPABC_Stripe extends CPABC_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-stripe-20201230";
		protected $name = "Stripe";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;

			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPABC_Stripe_id' ] )
			)
			{
			    // verify needed fields for update
                
                $this->add_field_verify("stripe_integrationtype");
                $this->add_field_verify("stripe_methods");
                
                $this->add_field_verify("stripe_language");
                $this->add_field_verify("stripe_subtitle");
                $this->add_field_verify("stripe_logoimage");
                $this->add_field_verify("askbilling");
                $this->add_field_verify("stripe_optionlabel");
                
			    $this->add_field_verify("frequency");
			    $this->add_field_verify("trialdays");
			    $this->add_field_verify("planname");
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,
                                    
									'stripe_key'	 => $_REQUEST["stripe_key"],
									'stripe_secretkey'	 => $_REQUEST["stripe_secretkey"],
									'enabled'	 => $_REQUEST["stripe_enabled"],
                                    
									'frequency'	 => $_REQUEST["stripe_frequency"],
									'trialdays'	 => $_REQUEST["stripe_trialdays"],
									'planname'	 => $_REQUEST["stripe_planname"],
                                    
                                    'currency'	 => $_REQUEST["stripe_currency"],
                                    'stripe_language'	 => $_REQUEST["stripe_language"],
                                    'stripe_subtitle'	 => $_REQUEST["stripe_subtitle"],
                                    
                                    'stripe_optionlabel'	 => $_REQUEST["stripe_optionlabel"],
                                    
                                    'stripe_logoimage'	 => $_REQUEST["stripe_logoimage"],
                                    'askbilling'	 => $_REQUEST["askbilling"],
                                    'stripe_integrationtype'	 => $_REQUEST["stripe_integrationtype"],
                                    'stripe_methods'	 => serialize($_REQUEST["stripe_methods"])
								),
								array( '%d', '%s', '%s', '%s', 
                                             '%s', '%s', '%s', 
                                             '%s', '%s', '%s', 
                                             '%s',
                                             '%s', '%s', '%s', '%s'
                                             )
							);          
			}


			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
           
			if (!count($rows))
			{
			    $row["stripe_key"] = "";
			    $row["stripe_secretkey"] = "";
			    $row["enabled"] = "0";
			    $row["frequency"] = "";
			    $row["trialdays"] = "0";
			    $row["planname"] = "0";
                $row["currency"] = "USD";
                $row["stripe_language"] = "";
                $row["stripe_subtitle"] = "";
                $row["stripe_logoimage"] = "";
                $row["askbilling"] = 0;
                $row["stripe_integrationtype"] = "";
                $row["stripe_optionlabel"] = __('Pay with Credit Cards', 'cpabc');
                $row["stripe_methods"] = array("card");
			} else {
			    $row["stripe_key"] = $rows[0]->stripe_key;
			    $row["stripe_secretkey"] = $rows[0]->stripe_secretkey;
			    $row["enabled"] = $rows[0]->enabled;
			    $row["frequency"] = $rows[0]->frequency;
			    $row["trialdays"] = $rows[0]->trialdays;
			    $row["planname"] = $rows[0]->planname;
                $row["currency"] = $rows[0]->currency;
                $row["stripe_subtitle"] = $rows[0]->stripe_subtitle;
			    $row["stripe_logoimage"] = $rows[0]->stripe_logoimage;
                $row["stripe_language"] = $rows[0]->stripe_language;
                $row["askbilling"] = $rows[0]->askbilling;
                $row["stripe_integrationtype"] = $rows[0]->stripe_integrationtype;
                if ($rows[0]->stripe_methods)
                    $row["stripe_methods"] = @unserialize($rows[0]->stripe_methods);
                if (!is_array($row["stripe_methods"]) || !count($row["stripe_methods"]))
                        $row["stripe_methods"] = array("card");                    
                $row["stripe_optionlabel"] = ( $rows[0]->stripe_optionlabel ? $rows[0]->stripe_optionlabel : __('Pay with Credit Cards', 'cpabc') );
			}
			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPABC_Stripe_id" value="1" />
                   <table class="form-table">
                    <tr valign="top">
                    <th scope="row"><?php _e('Enable Stripe?', 'cpabc'); ?></th>
                    <td><select name="stripe_enabled">
                         <option value="0" <?php if (!$row["enabled"]) echo 'selected'; ?>><?php _e('No', 'cpabc'); ?></option>
                         <option value="1" <?php if ($row["enabled"]) echo 'selected'; ?>><?php _e('Yes', 'cpabc'); ?></option>
                         <option value="2" <?php if ($row["enabled"] == '2') echo 'selected'; ?>><?php _e('Optional: This payment method + Pay Later (submit without payment)', 'cpabc'); ?></option>
                         <option value="3" <?php if ($row["enabled"] == '3') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods (enabled)', 'cpabc'); ?></option>
                         <option value="4" <?php if ($row["enabled"] == '4') echo 'selected'; ?>><?php _e('Optional: This payment method + Other payment methods  + Pay Later ', 'cpabc'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Integration Type', 'cpabc'); ?></th>
                    <td><select name="stripe_integrationtype">
                         <option value="" <?php if (!$row["stripe_integrationtype"]) echo 'selected'; ?>><?php _e('Classic - Valid for NON European Sellers (European Union Sellers)', 'cpabc'); ?></option>
                         <option value="sca" <?php if ($row["stripe_integrationtype"] == 'sca') echo 'selected'; ?>><?php _e('SCA Ready  - Valid for European Sellers (European Union Sellers)', 'cpabc'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top">
                      <th scope="row"><?php _e('Payment methods (for the SCA Ready integration type)', 'cpabc'); ?></th>
                      <td>
                         <input type="checkbox" name="stripe_methods[]" value="card" <?php if (in_array('card',$row["stripe_methods"])) echo " checked "; ?> /> Credit Card<br />
                         <input type="checkbox" name="stripe_methods[]" value="ideal" <?php if (in_array('ideal',$row["stripe_methods"])) echo " checked "; ?> /> iDEAL<br />
                         <input type="checkbox" name="stripe_methods[]" value="bancontact" <?php if (in_array('bancontact',$row["stripe_methods"])) echo " checked "; ?> /> Bancontact<br />
                         <input type="checkbox" name="stripe_methods[]" value="giropay" <?php if (in_array('giropay',$row["stripe_methods"])) echo " checked "; ?> /> giropay (only EUR currency!)<br />                         
                         <input type="checkbox" name="stripe_methods[]" value="p24" <?php if (in_array('p24',$row["stripe_methods"])) echo " checked "; ?> /> Przelewy24<br />
                         <input type="checkbox" name="stripe_methods[]" value="eps" <?php if (in_array('eps',$row["stripe_methods"])) echo " checked "; ?> /> EPS<br />                         
                      </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row">Stripe.com <a href="https://manage.stripe.com/account/apikeys" target="_blank" title="<?php _e('click to get the your stripe key', 'cpabc'); ?>"><?php _e('Publishable Key', 'cpabc'); ?></a></th>
                    <td><input type="text" name="stripe_key" size="20" value="<?php echo esc_attr($row["stripe_key"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row">Stripe.com <a href="https://manage.stripe.com/account/apikeys" target="_blank" title="<?php _e('click to get the your stripe secret key', 'cpabc'); ?>"><?php _e('Secret Key', 'cpabc'); ?></a></th>
                    <td><input type="text" name="stripe_secretkey" size="20" value="<?php echo esc_attr($row["stripe_secretkey"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Stripe - Currency', 'cpabc'); ?></th>
                    <td><input type="text" name="stripe_currency" size="20" value="<?php echo esc_attr($row["currency"]); ?>" /></td>
                    </tr>        

                    <tr valign="top">
                    <th scope="row"><?php _e('Language?', 'cpabc'); ?></th>
                    <td><select name="stripe_language">
                         <option value="auto" <?php if (!$row["stripe_language"]) echo 'selected'; ?>><?php _e('auto (recommended)', 'cpabc'); ?></option>
                         <option value="da" <?php if ($row["stripe_language"] == 'da') echo 'selected'; ?>>Danish (da)</option>
                         <option value="nl" <?php if ($row["stripe_language"] == 'nl') echo 'selected'; ?>>Dutch (nl)</option>
                         <option value="en" <?php if ($row["stripe_language"] == 'en') echo 'selected'; ?>>English (en)</option>
                         <option value="fi" <?php if ($row["stripe_language"] == 'fi') echo 'selected'; ?>>Finnish (fi)</option>
                         <option value="fr" <?php if ($row["stripe_language"] == 'fr') echo 'selected'; ?>>French (fr)</option>
                         <option value="de" <?php if ($row["stripe_language"] == 'de') echo 'selected'; ?>>German (de)</option>
                         <option value="it" <?php if ($row["stripe_language"] == 'it') echo 'selected'; ?>>Italian (it)</option>
                         <option value="ja" <?php if ($row["stripe_language"] == 'ja') echo 'selected'; ?>>Japanese (ja)</option>
                         <option value="no" <?php if ($row["stripe_language"] == 'no') echo 'selected'; ?>>Norwegian (no)</option>
                         <option value="zh" <?php if ($row["stripe_language"] == 'zh') echo 'selected'; ?>>Simplified Chinese (zh)</option>
                         <option value="es" <?php if ($row["stripe_language"] == 'es') echo 'selected'; ?>>Spanish (es)</option>
                         <option value="sv" <?php if ($row["stripe_language"] == 'sv') echo 'selected'; ?>>Swedish (sv)</option>
                        </select>
                    </td>
                    </tr>
                    
                    <tr valign="top">
                    <th scope="row"><?php _e('Ask for billing address?', 'cpabc'); ?></th>
                    <td><select name="askbilling">
                         <option value="0" <?php if (!$row["askbilling"]) echo 'selected'; ?>><?php _e('No', 'cpabc'); ?></option>
                         <option value="1" <?php if ($row["askbilling"]) echo 'selected'; ?>><?php _e('Yes', 'cpabc'); ?></option>
                         </select>
                    </td>
                    </tr>                    
                    
                    <tr valign="top">
                    <th scope="row"><?php _e('Payment frequency?', 'cpabc'); ?></th>
                    <td><select name="stripe_frequency">
                         <option value="" <?php if (!$row["frequency"]) echo 'selected'; ?>><?php _e('One time payment - Charge payment', 'cpabc'); ?></option>
                         <option value="auth" <?php if ($row["frequency"] == 'auth') echo 'selected'; ?>><?php _e('One time payment - Authorize only, do not charge', 'cpabc'); ?></option>
                         <option value="day" <?php if ($row["frequency"] == 'day') echo 'selected'; ?>><?php _e('Daily (subcription)', 'cpabc'); ?></option>
                         <option value="week" <?php if ($row["frequency"] == 'week') echo 'selected'; ?>><?php _e('Weekly (subscription)', 'cpabc'); ?></option>
                         <option value="month" <?php if ($row["frequency"] == 'month') echo 'selected'; ?>><?php _e('Monthly (subscription)', 'cpabc'); ?></option>
                         <option value="year" <?php if ($row["frequency"] == 'year') echo 'selected'; ?>><?php _e('Yearly (subscription)', 'cpabc'); ?></option>
                         </select>
                    </td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Trial period length in days for subscription payments', 'cpabc'); ?></th>
                    <td><input type="text" name="stripe_trialdays" size="50" value="<?php echo esc_attr($row["trialdays"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Plan name for subscription payments', 'cpabc'); ?></th>
                    <td><input type="text" name="stripe_planname" size="20" value="<?php echo esc_attr($row["planname"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Subtitle for payment panel', 'cpabc'); ?></th>
                    <td><input type="text" name="stripe_subtitle" size="20" value="<?php echo esc_attr($row["stripe_subtitle"]); ?>" /></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('URL of logo image', 'cpabc'); ?></th>
                    <td><input type="text" name="stripe_logoimage" size="20" value="<?php echo esc_attr($row["stripe_logoimage"]); ?>" /><br />
                    <em>* A relative or absolute URL pointing to a square image of your brand or product. The recommended minimum size is 128x128px. The supported image types are: .gif, .jpeg, and .png.</em></td>
                    </tr>
                    <tr valign="top">
                    <th scope="row"><?php _e('Option label', 'cpabc'); ?></th>
                    <td><input type="text" name="stripe_optionlabel" size="20" value="<?php echo esc_attr($row["stripe_optionlabel"]); ?>" /><br />
                    <em>* Used if multiple payments are enabled</em></td>
                    </tr>                      
                   </table>
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpabc_stripe';
        private $form_table_plans = 'cpabc_stripeplans';
        private $form_table_customers = 'cpabc_stripecustomers';
        private $_inserted = false;
		private $_apphbmain;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			
			$this->description = __("The add-on adds support for Stripe payments (SCA and Classic)", 'cpabc' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            if (!is_admin())
            {
			    add_action( 'cpabc_process_data_before_insert', array( &$this, 'pp_stripe' ), 1, 1 );
                
			    add_action( 'cpabc_process_data', array( &$this, 'pp_stripe_redirect' ), 11, 1 );
                
			    add_action( 'init', array( &$this, 'pp_stripe_check_price' ), 1 );
                
			    add_action( 'cpabc_script_after_validation_stripe', array( &$this, 'pp_payments_script' ), 10, 2 );
                
			    add_filter( 'cpabc_the_form', array( &$this, 'insert_payment_fields'), 99, 2 );
            }
			else
			{
				// Delete forms
				add_action( 'cpabc_delete_form', array(&$this, 'delete_form') );

				// Clone forms
				add_action( 'cpabc_clone_form', array(&$this, 'clone_form'), 10, 2 );

				// Export addon data
				add_action( 'cpabc_export_addons', array(&$this, 'export_form'), 10, 2 );

				// Import addon data
				add_action( 'cpabc_import_addons', array(&$this, 'import_form'), 10, 2 );
			}

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
					enabled varchar(10) DEFAULT '0' NOT NULL ,
					stripe_key varchar(255) DEFAULT '' NOT NULL ,
					stripe_secretkey varchar(255) DEFAULT '' NOT NULL ,
					frequency varchar(30) DEFAULT '' NOT NULL ,
					trialdays varchar(20) DEFAULT '' NOT NULL ,
					planname varchar(255) DEFAULT '' NOT NULL ,
                    currency varchar(255) DEFAULT '' NOT NULL ,
                    stripe_subtitle varchar(255) DEFAULT '' NOT NULL ,
                    stripe_logoimage varchar(255) DEFAULT '' NOT NULL ,
                    stripe_language varchar(255) DEFAULT '' NOT NULL ,
                    askbilling varchar(10) DEFAULT '0' NOT NULL ,
                    stripe_optionlabel varchar(255) DEFAULT '' NOT NULL ,
                    stripe_methods TEXT,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
            $wpdb->query($sql);

			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table_plans." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					planname varchar(255) DEFAULT '' NOT NULL ,
					planinterval varchar(255) DEFAULT '' NOT NULL ,
					currency varchar(30) DEFAULT '' NOT NULL ,
					amount varchar(20) DEFAULT '' NOT NULL ,
					trial_period_days varchar(20) DEFAULT '' NOT NULL,
					planresult TEXT DEFAULT '' NOT NULL,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
			$wpdb->query($sql);

			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table_customers." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					email varchar(255) DEFAULT '' NOT NULL ,
					source varchar(255) DEFAULT '' NOT NULL ,
					customer_id varchar(255) DEFAULT '' NOT NULL ,
					customerresult TEXT DEFAULT '' NOT NULL,
					UNIQUE KEY id (id)
				)
				CHARACTER SET utf8
				COLLATE utf8_general_ci;";
			$wpdb->query($sql);

		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
         * Inserts banks and Check if the Optional is enabled in the form, and inserts radiobutton
         */
        public function	insert_payment_fields( $form_code, $id )
		{
            global $wpdb;

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return $form_code;


            if ($rows[0]->stripe_integrationtype != 'sca')
            {
                $checkscript = '';
                // $checkscript = '<script type="text/javascript">function apphbaddonstripe'.$id.'(){ try { if(document.getElementById("apphbaddonidtp'.$id.'").checked) document.getElementById("opfield'.$this->addonID.$id.'").style.display=""; else document.getElementById("opfield'.$this->addonID.$id.'").style.display="none"; } catch (e) {} }setInterval("apphbaddonstripe'.$id.'()",200);</script>';
			    $code = '<div id="opfield"'.$this->addonID.$id.'">'.
                          '<!--noptimize--><script src="https://checkout.stripe.com/checkout.js"></script>'.
                          '<script type="text/javascript">'.
                          '         var abcaddonstripe_handler_paid= false;'.
                          '         var cpabc_stripe_handler = StripeCheckout.configure({'.
                          '           key: \''.$rows[0]->stripe_key.'\','.
                          '           image: \'\','.
                          '           locale: \''.$rows[0]->stripe_language.'\','.
                          '           token: function(token, args) {'.
                          '             document.getElementById("stptok'.$id.'").value = token.id;'.
                          '             abcaddonstripe_handler_paid = true;'.
                          '             $dexQuery( ".pbSubmit" ).trigger( "click" );'.
                          '           }'.
                          '         });'.
                          '</script><!--/noptimize-->'.
                          '<input type="hidden" name="stptok" id="stptok'.$id.'" value="" />'.
			            '</div>'.$checkscript;
            }

			$form_code = preg_replace( '/<!--addons-payment-fields-->/i', '<!--addons-payment-fields-->'.$code, $form_code );

            $stripelabel = $rows[0]->stripe_optionlabel;
            if (!$stripelabel) 
                $stripelabel = __('Pay with Credit Cards', 'cpabc');
                
			// output radio-buttons here
			$form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" id="apphbaddonidtp'.$id.'" vt="'.$this->addonID.'" value="'.$this->addonID.'" checked> '.__($stripelabel, 'cpabc').'</div>', $form_code );

           // if (($rows[0]->enabled == '2' || $rows[0]->enabled == '4') && !strpos($form_code,'bccf_payment_option_paypal" vt="0') )
		   //	    $form_code = preg_replace( '/<!--addons-payment-options-->/i', '<!--addons-payment-options--><div><input type="radio" name="bccf_payment_option_paypal" vt="0" value="0"> '.__( cpabc_get_option ('enable_paypal_option_no','Pay later'), 'cpabc').'</div>', $form_code );

			if (substr_count ($form_code, 'name="bccf_payment_option_paypal"') > 1)
			    $form_code = str_replace( 'id="field-c0" style="display:none">', 'id="field-c0">', $form_code);

            return $form_code;
		} // End insert_payment_fields


		/**
         * process payment
         */
		public function pp_stripe(&$params)
		{
            global $wpdb;

			// documentation: https://goo.gl/w3kKoH

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (empty( $rows ) || !$rows[0]->enabled || $payment_option != $this->addonID)
			    return;

            if ($rows[0]->stripe_integrationtype == 'sca')
                return;
            
            $params["payment_type"] = $this->name;
            $params["paid"] = '1';
            
            $currency = strtoupper($rows[0]->currency);
            if ($currency == 'JPY')
                $amount = round($params["final_price"],0);
            else
                $amount = round($params["final_price"]*100,0);
            if (!$amount)
                return;            

            // **************
            if (!class_exists('\Stripe\Stripe'))
                require_once dirname( __FILE__ ) . '/stripe-php.addon/init.php';
            \Stripe\Stripe::setApiKey( $rows[0]->stripe_secretkey );

            // Get the credit card details submitted by the form
            $token = $_POST['stptok'];                      

            if (in_array( $rows[0]->frequency, array('day','week','month','year') ) )
            {
                // step 1: Identify / create plan
                // ***********************************
                $rowsplan = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table_plans." WHERE planname=%s AND planinterval=%s AND currency=%s AND amount=%s AND trial_period_days=%s",
						   ($rows[0]->stripe_mode=='0'?"test_".$rows[0]->planname:$rows[0]->planname), $rows[0]->frequency, $currency, $amount, $rows[0]->trialdays
						 )
					);
				if (!count($rowsplan))
				{
				    $wpdb->insert(
				                  $wpdb->prefix.$this->form_table_plans,
				                  array(
				                         'planname' => ($rows[0]->stripe_mode=='0'?"test_".$rows[0]->planname:$rows[0]->planname),
				                         'planinterval' => $rows[0]->frequency,
				                         'currency' => $currency,
				                         'amount' => $amount,
				                         'trial_period_days' => "".$rows[0]->trialdays
						               ),
						          array ('%s', '%s', '%s', '%s', '%s')
					);
				    $planid = $wpdb->insert_id;
				    try {
                        $plan = \Stripe\Plan::create(array(
                          'product'        => array(
				               	'name' => ($rows[0]->stripe_mode=='0'?"test_".$rows[0]->planname:$rows[0]->planname)
				               ),
                          "id" => "apphbplan-".$planid,
                          "interval" => $rows[0]->frequency,
                          "currency" => $currency,
                          "trial_period_days" => $rows[0]->trialdays,
                          "amount" => $amount,
                        ));
                        $wpdb->update($wpdb->prefix.$this->form_table_plans,
				                        array('planresult' => serialize($plan)),
                  						array('id' => $planid)
					    );
                    } catch(Exception  $e) {
                        // The card has been declined
                        echo 'Stripe: Failed to create plan. Error message: '. $e->getMessage();
                        exit;
                    }
				}
				else
				    $planid = $rowsplan[0]->id;

                // step 2: Create customer
                // ***********************************
                try {
                    $notifyto = cpabc_get_option('cu_user_email_field', CPABC_APPOINTMENTS_DEFAULT_cu_user_email_field);
                    $notifyto = $params[ $notifyto ];
                    $customer = \Stripe\Customer::create(array(
                      "email" => $notifyto,
                      "source" => $token
                    ));
                    $wpdb->insert(
				                  $wpdb->prefix.$this->form_table_customers,
				                  array(
				                         'email' => $notifyto,
				                         'source' => $token,
				                         'customer_id' => $customer->id,
				                         'customerresult' => serialize($customer)
						               ),
						          array ('%s', '%s', '%s', '%s')
					);
                } catch(Exception  $e) {
                    // The card has been declined
                    echo 'Stripe: Failed to create customer. Error message: '. $e->getMessage();
                    exit;
                }

                // Step 3: Subscribe customer to plan
                // ***********************************
                try {
                    \Stripe\Subscription::create(array(
                      "customer" => $customer->id,
                      "plan" => "apphbplan-".$planid,
                    ));
                } catch(Exception  $e) {
                    // The card has been declined
                    echo 'Stripe: Failed to create subscription. Error message: '. $e->getMessage();
                    exit;
                }


            }
            else{ // if no subscription then process one time payment_option
                // Create the charge on Stripe's servers - this will charge the user's card
                try {                    
                    $descnn = cpabc_get_option('paypal_product_name', CPABC_APPOINTMENTS_DEFAULT_PRODUCT_NAME);
                    if ($descnn == '')
                        $descnn= CPABC_APPOINTMENTS_DEFAULT_PRODUCT_NAME;
                
                    $notifyto = cpabc_get_option('cu_user_email_field', CPABC_APPOINTMENTS_DEFAULT_cu_user_email_field);
                    $notifyto = $params[ $notifyto ];
                    $customer = \Stripe\Customer::create(array(
                      "email" => $notifyto,
                      "source" => $token
                    )); 
                    $charge = \Stripe\Charge::create(array(
                      "customer" => $customer->id,
                      "receipt_email" => $notifyto,
                      "amount" => $amount, // amount in cents, again
                      "currency" => $currency,
                      "capture" => ($rows[0]->frequency == 'auth'?false:true),
                      //"card" => $token,
                      "description" => $descnn)
                    );
                } catch(Exception $e) {
                    // The card has been declined
                    if ($e->getStripeCode() == 'authentication_required')
                        {                           
                            echo 'Transaction failed. SCA Strong Authentication required! If you are the website owner please change the "legacy" mode to the "SCA" mode in the settings then <a href="javascript:window.history.back();">go back and try again</a>.';
                            exit;
                        }                        
                    echo 'Transaction failed. The card has been declined. '.$e->getMessage().' Please <a href="javascript:window.history.back();">go back and try again</a>.';
                    exit;
                }
            }
            // **************

		} // end pp_stripe

        function pp_stripe_redirect($params)
        {
            global $wpdb;
            $row = $wpdb->get_row(
				$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
			);

			$payment_option = (isset($_POST["bccf_payment_option_paypal"])?$_POST["bccf_payment_option_paypal"]:$this->addonID);
			if (
				empty( $row )  ||
				!$row->enabled ||
				$payment_option != $this->addonID
			) return;
            
            $amount = $params["final_price"];
            if (!floatval($amount))
                return;              

            // start: New SCA method
            if ($row->stripe_integrationtype == 'sca')
            {
                if (!class_exists('\Stripe\Stripe'))
                    require_once dirname( __FILE__ ) . '/stripe-php.addon/init.php';
                \Stripe\Stripe::setApiKey( $row->stripe_secretkey );
                

            if (in_array( $row->frequency, array('day','week','month','year') ) )
            {
                // step 1: Identify / create plan
                // ***********************************
                $rowsplan = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table_plans." WHERE planname=%s AND planinterval=%s AND currency=%s AND amount=%s AND trial_period_days=%s",
						   ($row->stripe_mode=='0'?"test_".$row->planname:$row->planname), $row->frequency, $currency, $amount, $row->trialdays
						 )
					);
				if (!count($rowsplan))
				{
				    $wpdb->insert(
				                  $wpdb->prefix.$this->form_table_plans,
				                  array(
				                         'planname' => ($row->stripe_mode=='0'?"test_".$row->planname:$row->planname),
				                         'planinterval' => $row->frequency,
				                         'currency' => $row->currency,
				                         'amount' => (strtoupper($row->currency) == 'JPY' ? ceil($params["final_price"]) : ceil($params["final_price"]*100)),
				                         'trial_period_days' => "".$row->trialdays
						               ),
						          array ('%s', '%s', '%s', '%s', '%s')
					);
				    $planid = $wpdb->insert_id;
				    try {
                        $plan = \Stripe\Plan::create(array(
                          'product'        => array(
				               	'name' => ($row->stripe_mode=='0'?"test_".$row->planname:$row->planname)
				               ),
                          "id" => "apphbplan-".$planid,
                          "interval" => $row->frequency,
                          "currency" => $row->currency,
                          "trial_period_days" => $row->trialdays,
                          "amount" => (strtoupper($row->currency) == 'JPY' ? ceil($params["final_price"]) : ceil($params["final_price"]*100)),
                        ));
                        $wpdb->update($wpdb->prefix.$this->form_table_plans,
				                        array('planresult' => serialize($plan)),
                  						array('id' => $planid)
					    );
                    } catch(Exception  $e) {
                        // The card has been declined
                        echo 'Stripe: Failed to create plan. Error message: '. $e->getMessage();
                        exit;
                    }
				}
				else
				    $planid = $rowsplan[0]->id;
                
                $stripe_methods = @unserialize($row->stripe_methods);
                if (!is_array($stripe_methods) || !count($stripe_methods))
                    $stripe_methods = array("card");
                
                $session = \Stripe\Checkout\Session::create([
                  'payment_method_types' => $stripe_methods,
                  'subscription_data' => (!$row->trialdays? 
                                           [
                                            'items' => [[
                                              'plan' => "apphbplan-".$planid,
                                            ]],
                                          ]
                                          :
                                          [
                                            'items' => [[
                                              'plan' => "apphbplan-".$planid,
                                            ]],
                                            'trial_period_days' => $row->trialdays,
                                          ]
                                          ),
                  'success_url' => cpabc_appointment_get_FULL_site_url().'/?cp_appcal='.$params["formid"].'&inumber='.$params["itemnumber"].'&cp_abcaddonstripe_ipncheck={CHECKOUT_SESSION_ID}',
                  'cancel_url' => cpabc_get_option('url_cancel', CPABC_APPOINTMENTS_DEFAULT_CANCEL_URL),
                ]);        

            }
            else
            {    
                // ,['capture' => ($row->frequency == 'auth'?false:true)]
                
                $descnn = cpabc_get_option('paypal_product_name', CPABC_APPOINTMENTS_DEFAULT_PRODUCT_NAME);
                if ($descnn == '')
                    $descnn= CPABC_APPOINTMENTS_DEFAULT_PRODUCT_NAME;
                
                $stripe_methods = @unserialize($row->stripe_methods);
                if (!is_array($stripe_methods) || !count($stripe_methods))
                    $stripe_methods = array("card");
                try {
                    $session = \Stripe\Checkout\Session::create([
                      'payment_method_types' => $stripe_methods,   
                      'payment_intent_data' => array(
                               'description' => $descnn ,	
                               'statement_descriptor' => substr($descnn,0,22),	
                          ),                  
                      'line_items' => [[
                        'name' => $descnn,
                        'amount' => (strtoupper($row->currency) == 'JPY' ? ceil($params["final_price"]) : ceil($params["final_price"]*100)),
                        'currency' => $row->currency,                    
                        'quantity' => 1,
                      ]],
                      'success_url' => cpabc_appointment_get_FULL_site_url().'/?cp_appcal='.$params["formid"].'&inumber='.$params["itemnumber"].'&cp_abcaddonstripe_ipncheck={CHECKOUT_SESSION_ID}',
                      'cancel_url' => cpabc_get_option('url_cancel', CPABC_APPOINTMENTS_DEFAULT_CANCEL_URL),
                    ]
                    );     
                } catch (Exception $e) {
                    echo "<div style=\"border:1px dotted red; padding:20px;max-width:500px;margin:auto\"><h1>Stripe Configuration error</h1><p><b>Error:</b>". $e->getMessage().'</div>';
                    exit;
                }                    
            }         
                
                ?>
<html><head><title>Redirecting to Stripe Checkout</title><body>
<script src="https://js.stripe.com/v3"></script>
<script>                
var stripe = Stripe('<?php echo $row->stripe_key; ?>');
stripe.redirectToCheckout({
  // Make the id field from the Checkout Session creation API response
  // available to this file, so you can provide it as parameter here
  // instead of the {{CHECKOUT_SESSION_ID}} placeholder.
  sessionId: '<?php echo $session->id; ?>'
}).then(function (result) {
  // If `redirectToCheckout` fails due to a browser or network
  // error, display the localized error message to your customer
  // using `result.error.message`.
  alert(result.error.message);
});                
</script>
</body>
</html>
<?php
                exit;
            } 
            // end: new SCA method

			$this->completeAndRedirect($params["itemnumber"]);
        }
        
        
        private function completeAndRedirect($itemnumber)
        {
            global $wpdb;
            
            // mark item as paid
            if (!is_array($itemnumber))
                $itemnumber = explode(";",$itemnumber);
            $myrows = $wpdb->get_results( "SELECT * FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".intval($itemnumber[0]) ); 
            
            if (empty( $myrows ))
			   return;            
            $params = unserialize($myrows[0]->buffered_date);
            
			$myrowscheck = $wpdb->get_results( "SELECT * FROM ".CPABC_TDEAPP_CALENDAR_DATA_TABLE." WHERE reference='".intval($itemnumber[0])."'" );
            if (!count($myrowscheck))
            {
                $params["paid"] = '1';
                $params["payment_type"] = "Stripe";
                
                $wpdb->query( $wpdb->prepare("UPDATE  ".CPABC_APPOINTMENTS_TABLE_NAME." SET buffered_date=%s WHERE id=%d", serialize($params), intval($itemnumber[0])) );
                
                cpabc_process_ready_to_go_appointment((isset($_GET["inumber"]) ? $_GET["inumber"] : implode(";", $itemnumber)) );
            } 

            $redirect = true;
            
		    /**
		     * Filters applied to decide if the website should be redirected to the thank you page after submit the form,
		     * pass a boolean as parameter and returns a boolean
		     */
            $redirect = apply_filters( 'cpabc_redirect', $redirect );
            if( $redirect )
            {
                header("Location: ".cpabc_get_option('url_ok', CPABC_APPOINTMENTS_DEFAULT_OK_URL));
                exit;
            }         
        }

		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}


        /**
         * script process payment
         */
		public function pp_stripe_check_price()
		{
            global $wpdb;
            
            if (isset($_GET["cp_abcaddonstripe_ipncheck"]) && $_GET["cp_abcaddonstripe_ipncheck"] != '')
            {
                $row = $wpdb->get_row(
                				$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $_GET["cp_appcal"] )
                			);
                
                if (!class_exists('\Stripe\Stripe'))
                    require_once dirname( __FILE__ ) . '/stripe-php.addon/init.php';
                \Stripe\Stripe::setApiKey( $row->stripe_secretkey );
                $session = \Stripe\Checkout\Session::retrieve($_GET["cp_abcaddonstripe_ipncheck"]);
                if ($session->payment_intent)                    
                    $pintent = \Stripe\PaymentIntent::retrieve($session->payment_intent);
                else
                    $pintent = \Stripe\Subscription::retrieve($session->subscription); 
                if ($pintent->status == 'succeeded' || $pintent->status == 'active' || $pintent->status == 'trialing')
                {
                    $this->completeAndRedirect($_GET["inumber"]);
                }
                else
                {
                    echo 'Error: Purchase cannot be verified. Please contact the seller.';
                    exit;
                }
                exit;
            }
                
            //if (!isset($_POST["apphbstripe_getprice"]) || !isset($_POST["formid"]))
            //    return;
            //
            //$form_id = intval($_POST["formid"]);
            //
            //$rows = $wpdb->get_results(
			//			$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
			//		);
            //
			//if (empty( $rows ) || !$rows[0]->enabled)
			//    return;
            //
            //$price = apply_filters( 'CPABC_calculate_price', $_POST["basecost"], $form_id );
            //if ($_POST["coupon"]) 
            //    $price = apply_filters( 'CPABC_calculate_coupondiscount', $price, $_POST["coupon"], $form_id );
            //
            //
			//echo round($price,2);
			//exit;

         }



		/**
         * script process payment
         */
		public function pp_payments_script( $form_sequence_id, $form_id )
		{
            global $wpdb;

            $rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);

			if (empty( $rows ) || !$rows[0]->enabled)
			    return;
            
            if ($rows[0]->stripe_integrationtype == 'sca')
                return;

            $descnn = cpabc_get_option('paypal_product_name', CPABC_APPOINTMENTS_DEFAULT_PRODUCT_NAME);
            if ($descnn == '')
                $descnn = CPABC_APPOINTMENTS_DEFAULT_PRODUCT_NAME;
?>
            if (!abcaddonstripe_handler_paid && $dexQuery("input[name='bccf_payment_option_paypal']:checked").val() == '<?php echo $this->addonID; ?>')
            {
                var charge_price = abc_cost;                
                if (charge_price > 0)
                {                    
                    //var emailvalue = '';
                    //try {
                    //    emailvalue = document.getElementById("?").value;
                    //} catch (e) {}                                                 
                    cpabc_stripe_handler.open({
                      name: '<?php echo str_replace("'","\'",$descnn); ?>',
                      description: '<?php echo str_replace("'","\'",$rows[0]->stripe_subtitle); ?>',
                      image: '<?php echo str_replace("'","\'",$rows[0]->stripe_logoimage); ?>',
                      //email: emailvalue,
                      currency: document.getElementById("abccurrency"+cpabc_current_calendar_item).value,
                      <?php if (@$rows[0]->askbilling) { ?>billingAddress:true,<?php } ?>
                      amount: parseFloat(charge_price)<?php if (strtoupper($rows[0]->currency) != 'JPY') echo '*100'; ?>
                    });
                    return false;
                }
            }
<?php
        }


        function add_field_verify ($field, $type = "varchar(255) DEFAULT '' NOT NULL", $table = '')
        {
            global $wpdb;
            if ($table == '')
                $table = $this->form_table;
            $results = $wpdb->get_results("SHOW columns FROM `".$wpdb->prefix.$table."` where field='".$field."'");
            if (!count($results))
            {
                $sql = "ALTER TABLE  `".$wpdb->prefix.$this->form_table."` ADD `".$field."` ".$type;
                $wpdb->query($sql);
            }
        }

		/**
		 *	Delete the form from the addon's table
		 */
        public function delete_form( $formid)
		{
			global $wpdb;
			$wpdb->delete( $wpdb->prefix.$this->form_table, array('formid' => $formid), '%d' );
		} // delete_form

        		/**
		 *	Clone the form's row
		 */
		public function clone_form( $original_form_id, $new_form_id )
		{
			global $wpdb;

			$form_rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $original_form_id ), ARRAY_A);

			if(!empty($form_rows))
			{
				foreach($form_rows as $form_row)
				{
					unset($form_row["id"]);
					$form_row["formid"] = $new_form_id;
					$wpdb->insert( $wpdb->prefix.$this->form_table, $form_row);
				}
			}
		} // End clone_form

		/**
		 *	It is called when the form is exported to export the addons data too.
		 *  Receive an array with the other addons data, and the form's id for filtering.
		 */
		public function export_form($addons_array, $formid)
		{
			global $wpdb;
			$rows = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $formid ), ARRAY_A );
			if(!empty($rows))
			{
				$addons_array[ $this->addonID ] = array();
				foreach($rows as $row)
				{
					unset($row['id']);
					unset($row['formid']);
					$addons_array[ $this->addonID ][] = $row;
				}
			}
			return $addons_array;
		} // End export_form

		/**
		 *	It is called when the form is imported to import the addons data too.
		 *  Receive an array with all the addons data, and the new form's id.
		 */
		public function import_form($addons_array, $formid)
		{
			global $wpdb;
			if(isset($addons_array[$this->addonID]))
			{
				foreach($addons_array[$this->addonID] as $row)
				{
					if(!empty($row))
					{
						$row['formid'] = $formid;
						$wpdb->insert(
							$wpdb->prefix.$this->form_table,
							$row
						);
					}
				}
			}
		} // End import_form


    } // End Class

    // Main add-on code
    $CPABC_Stripe_obj = new CPABC_Stripe();

    global $cpabc_addons_objs_list;
	$cpabc_addons_objs_list[ $CPABC_Stripe_obj->get_addon_id() ] = $CPABC_Stripe_obj;
}
?>