<?php
/*

*/
require_once dirname( __FILE__ ).'/base.addon.php';

if( !class_exists( 'CPABC_Zoom' ) )
{
    class CPABC_Zoom extends CPABC_BaseAddon
    {

        /************* ADDON SYSTEM - ATTRIBUTES AND METHODS *************/
		protected $addonID = "addon-Zoom-20200509";
		protected $name = "Zoom.us Meetings Integration";
		protected $description;

		public function get_addon_form_settings( $form_id )
		{
			global $wpdb;
			// Insertion in database
			if(
				isset( $_REQUEST[ 'CPABC_Zoomlinks_id' ] )
			)
			{

                cpabc_appointments_add_field_verify($wpdb->prefix.$this->form_table, 'zoom_share', "varchar(255) DEFAULT '' NOT NULL");
                
			    $wpdb->delete( $wpdb->prefix.$this->form_table, array( 'formid' => $form_id ), array( '%d' ) );
				$wpdb->insert(
								$wpdb->prefix.$this->form_table,
								array(
									'formid' => $form_id,

									'zoom_api_key'	  => $_REQUEST["zoom_api_key"],
									'zoom_api_secret' => $_REQUEST["zoom_api_secret"],
                                    'zoom_share'	  => $_REQUEST["zoom_share"],
                                    
                                    'zoom_enable'	  => $_REQUEST["zoom_enable"],
								),
								array( '%d', '%s', '%s', '%s', '%d' )
							);
			}

			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $form_id )
					);
			if (!count($rows))
			{
			    $row["zoom_api_key"] = '';
                $row["zoom_share"] = 'zoom_share';
			    $row["zoom_api_secret"] = '';
                $row["zoom_enable"] = '24';              
			} else {
			    $row["zoom_api_key"] = $rows[0]->zoom_api_key;
                $row["zoom_share"] =  $rows[0]->zoom_share;
			    $row["zoom_api_secret"] = $rows[0]->zoom_api_secret;
                $row["zoom_enable"] = $rows[0]->zoom_enable;
			}

			?>
			<div id="metabox_basic_settings" class="postbox" >
				<h3 class='hndle' style="padding:5px;"><span><?php print $this->name; ?></span></h3>
				<div class="inside">
				   <input type="hidden" name="CPABC_Zoomlinks_id" value="1" />
                    Enable <a href="https://zoom.us/" target="_blank">Zoom</a> integration for this booking form? :<br />
                        <?php $option = $row['zoom_enable']; ?>
                        <select name="zoom_enable" id="zoom_enable" onchange="cpappbzoom_display_option(this)">
                          <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                          <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                         </select><br />
         
                   <div id="UserCalendarzoom_yes" <?php if ($option != '1') echo ' style="display:none"'; ?>>
                       <div style="font-size:120%;color:green; border: 1px dotted black;margin-top:10px;padding:15px;">To register your app, visit the <a href="https://marketplace.zoom.us/develop/create" target="_blank">Zoom App Marketplace</a> and click on the Develop option in the dropdown on the top-right corner and select Build App. A page with various app types will be displayed. <strong>Select JWT as the app type</strong> and click on Create. Then enter the API Key and API Secret in the fields below.</div>
                      <table class="form-table">
                        <tr valign="top">
                        <th scope="row">Zoom JWT API Key</th>
                        <td><input type="text" name="zoom_api_key" size="40" value="<?php echo esc_attr($row["zoom_api_key"]); ?>" /></td>
                        </tr>
                        <tr valign="top">
                        <th scope="row">Zoom JWT API Secret</th>
                        <td><input type="text" name="zoom_api_secret" size="40" value="<?php echo esc_attr($row["zoom_api_secret"]); ?>" /></td>
                        </tr> 
                        <tr valign="top">
                        <th scope="row">Invite all users from the same time slot to the same meeting</th>
                        <td>
                          <?php $option = $row['zoom_share']; ?>
                          <select name="zoom_share" id="zoom_share">
                            <option value="0"<?php if ($option != '1') echo ' selected'; ?>>No</option>
                            <option value="1"<?php if ($option == '1') echo ' selected'; ?>>Yes</option>
                           </select><br />                         
                        </td>
                        </tr>
                      </table>
                       
                          <div style="font-size:120%;color:blue; border: 1px dotted black;margin-top:10px;padding:15px;">Note: The following additional tags can be used in the emails:<br /><br />
                          <strong>%zoom%</strong>: The invitation link to the generated zoom meeting.<br />
                          <strong>%zoom_id%</strong>: The zoom meeting ID.<br />
                          <strong>%zoom_password%</strong>: The zoom meeting password.<br /><br />
                          ... the above tags are useful in the case of single time meetings, for multiple time bookings use %zoom_1%, %zoom_2%, %zoom_3%...
                          </div />
                        
                   </div>
                   <script type="text/javascript">
                       function cpappbzoom_display_option(item) 
                       {                         
                           if (item.selectedIndex == 1) 
                               document.getElementById("UserCalendarzoom_yes").style.display = '';
                           else
                               document.getElementById("UserCalendarzoom_yes").style.display = 'none';
                       }
                   </script>                   
				</div>
			</div>
			<?php
		} // end get_addon_form_settings



		/************************ ADDON CODE *****************************/

        /************************ ATTRIBUTES *****************************/

        private $form_table = 'cpabc_form_Zoomlinks';
        private $form_meetings = 'cpabc_form_Zoommeetings';
        private $_inserted = false;

        /************************ CONSTRUCT *****************************/

        function __construct()
        {
			$this->description = __("Automatically creates a Zoom.us meeting for the booked time", 'appointment-hour-booking' );
            // Check if the plugin is active
			if( !$this->addon_is_active() ) return;

            add_action( 'cpabc_process_data_before_insert', array( &$this, 'pp_Zoom_process_data' ), 10, 1 );

            $this->update_database();

        } // End __construct



        /************************ PRIVATE METHODS *****************************/

		/**
         * Create the database tables
         */
        protected function update_database()
		{
			global $wpdb;
			$charset_collate = $wpdb->get_charset_collate();
			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_table." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,
					formid INT NOT NULL,
                    zoom_api_key varchar(255) DEFAULT '' NOT NULL,
			        zoom_api_secret varchar(255) DEFAULT '' NOT NULL,
                    zoom_share varchar(255) DEFAULT '' NOT NULL,
                    zoom_enable INT NOT NULL,
					UNIQUE KEY id (id)
				) $charset_collate;";   
            $wpdb->query($sql);

			$sql = "CREATE TABLE IF NOT EXISTS ".$wpdb->prefix.$this->form_meetings." (
					id mediumint(9) NOT NULL AUTO_INCREMENT,					
                    timeslot varchar(255) DEFAULT '' NOT NULL,
			        zoom varchar(255) DEFAULT '' NOT NULL,
                    zoom_id varchar(255) DEFAULT '' NOT NULL,
                    zoom_password varchar(255) DEFAULT '' NOT NULL,
					UNIQUE KEY id (id)
				) $charset_collate;";                   

			$wpdb->query($sql);
		} // end update_database


		/************************ PUBLIC METHODS  *****************************/


		/**
		 * mark the item as paid
		 */
		private function _log($adarray = array())
		{
			$h = fopen( __DIR__.'/logs.txt', 'a' );
			$log = "";
			foreach( $_REQUEST as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			foreach( $adarray as $KEY => $VAL )
			{
				$log .= $KEY.": ".$VAL."\n";
			}
			$log .= "================================================\n";
			fwrite( $h, $log );
			fclose( $h );
		}

        public function pp_Zoom_process_data( &$params )
        {
            global $wpdb;
            
            $pro_item_name = cpabc_get_option('paypal_product_name', 'Payment', $params['formid']);
            foreach ($params as $item => $value)
                $pro_item_name = str_replace('<%'.$item.'%>',(is_array($value)?(implode(", ",$value)):($value)),$pro_item_name);
            if ($pro_item_name == '') 
                $pro_item_name = 'Appointment';            
            
			$rows = $wpdb->get_results(
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_table." WHERE formid=%d", $params["formid"] )
					);

			if (empty( $rows ) || !$rows[0]->zoom_enable)
			    return;
            
            $zoom_meeting = new AHB_Zoom_Api();
            $zoom_meeting->zoom_api_key = $rows[0]->zoom_api_key;
            $zoom_meeting->zoom_api_secret = $rows[0]->zoom_api_secret;
            try{
                $count = 1;
                //foreach($params["apps"] as $app)
                {
                    $datetime = $params["booked_time_unformatted"];
                    $starttime = date("Y-m-d H:i:s", strtotime($datetime));
                    
			        $rowprevious = $wpdb->get_results( 
						$wpdb->prepare( "SELECT * FROM ".$wpdb->prefix.$this->form_meetings." WHERE timeslot=%s", $starttime )
					);
                    
                    if ($rows[0]->zoom_share != '1' || empty($rowprevious))
                    {
                        $duration = get_option('CPABC_CAL_TIME_SLOT_SIZE_SET',"30");
                           
                        $password = $this->randomPassword();
                        $z = $zoom_meeting->createAMeeting(
                        	array(
                        		'start_date'=> $starttime,
                        		'meetingTopic'=> $pro_item_name,
                                'password'=> $password,
                                'duration'=> $duration,
                        	)
                        ); 
                        if ($count == 1)
                        {                        
                            $params["zoom"] = $z->join_url;
                            $params["zoom_id"] = $z->id;
                            $params["zoom_password"] = $password;
                        }
                        
                        if ($rows[0]->zoom_share == '1')
				            $wpdb->insert(
						    		$wpdb->prefix.$this->form_meetings,
						    		array(
						    			'zoom'	  => $z->join_url,
						    			'zoom_id' => $z->id,
                                        'zoom_password'	  => $password,                                    
                                        'timeslot'	  => $starttime,
						    		),
						    		array( '%s', '%s', '%s', '%s' )
						    	);                        
                    } else {
                        if ($count == 1)
                        {                        
                            $params["zoom"] = $rowprevious[0]->zoom;
                            $params["zoom_id"] = $rowprevious[0]->zoom_id;
                            $params["zoom_password"] = $rowprevious[0]->zoom_password;
                        }                        
                    }
                    $count++;
                }
            } catch (Exception $ex) {
                $params["zoom"] = 'Zoom link cannot be automatically created: '.$ex->getMessage();
                $params["zoom_id"] = '';
                $params["zoom_password"] = '';
            }            
                     
        }
        
        
        function randomPassword($length = 8) 
        {
            $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
            $pass = array(); //remember to declare $pass as an array
            $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
            for ($i = 0; $i < $length; $i++) {
                $n = rand(0, $alphaLength);
                $pass[] = $alphabet[$n];
            }
            return implode($pass); //turn the array into a string
        }
        
  

    } // End Class

    // Main add-on code
    $CPABC_Zoom_obj = new CPABC_Zoom();

	// Add addon object to the objects list
	global $cpabc_addons_objs_list;
	$cpabc_addons_objs_list[ $CPABC_Zoom_obj->get_addon_id() ] = $CPABC_Zoom_obj;
}

if (!class_exists('AHB_Zoom_Api'))
{
    class AHB_Zoom_Api {
    		public $zoom_api_key = '';
    		public $zoom_api_secret = '';
    		
    		protected function sendRequest($data) {
                $request_url = 'https://api.zoom.us/v2/users/me/meetings';
                $headers = array(
    				"authorization: Bearer {$this->generateJWTKey()}",
                    'content-type: application/json'
                );
                $postFields = json_encode($data);
    		    $ch = curl_init();
    			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    			curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
    			curl_setopt($ch, CURLOPT_URL, $request_url);
    			curl_setopt($ch, CURLOPT_POST, 1);
    			curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
    			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    			$response = curl_exec($ch);
    			$err = curl_error($ch);
    			curl_close($ch);
    			if(!$response){
    				return $err;
    			}
    			return json_decode($response);
    		}
    
    		//function to generate JWT
            private function generateJWTKey() {
                $key = $this->zoom_api_key;
                $secret = $this->zoom_api_secret;
                $token = array(
                    "iss" => $key,
                    "exp" => time() + 3600 //60 seconds as suggested
                );
                require_once __DIR__.'/gapi.addon/autoload.php';          
                return \Firebase\JWT\JWT::encode( $token, $secret );
            }
    		
    		public function createAMeeting( $data = array() ) {
                $post_time  = $data['start_date'];
    			$start_time = gmdate( "Y-m-d\TH:i:s", strtotime( $post_time ) );
                $createAMeetingArray = array();
                if ( ! empty( $data['alternative_host_ids'] ) ) {
                    if ( count( $data['alternative_host_ids'] ) > 1 ) {
                        $alternative_host_ids = implode( ",", $data['alternative_host_ids'] );
                    } else {
                        $alternative_host_ids = $data['alternative_host_ids'][0];
                    }
                }
                $createAMeetingArray['topic']      = @$data['meetingTopic'];
                $createAMeetingArray['agenda']     = ! empty( $data['agenda'] ) ? $data['agenda'] : "";
                $createAMeetingArray['type']       = ! empty( $data['type'] ) ? $data['type'] : 2; //Scheduled
                $createAMeetingArray['start_time'] = $start_time;
                $createAMeetingArray['timezone']   = @$data['timezone'];
                $createAMeetingArray['password']   = ! empty( $data['password'] ) ? $data['password'] : "";
                $createAMeetingArray['duration']   = ! empty( $data['duration'] ) ? $data['duration'] : 60;
                $createAMeetingArray['settings']   = array(
                    'join_before_host'  => ! empty( $data['join_before_host'] ) ? true : false,
                    'host_video'        => ! empty( $data['option_host_video'] ) ? true : false,
                    'participant_video' => ! empty( $data['option_participants_video'] ) ? true : false,
                    'mute_upon_entry'   => ! empty( $data['option_mute_participants'] ) ? true : false,
                    'enforce_login'     => ! empty( $data['option_enforce_login'] ) ? true : false,
                    'auto_recording'    => ! empty( $data['option_auto_recording'] ) ? $data['option_auto_recording'] : "none",
                    'alternative_hosts' => isset( $alternative_host_ids ) ? $alternative_host_ids : ""
                );
                return $this->sendRequest($createAMeetingArray);
            }
    
    
    }
}