<?php

if ( !is_admin() )
{
    echo 'Direct access not allowed.';
    exit;
}

if (!defined('CP_CALENDAR_ID'))
    define ('CP_CALENDAR_ID',intval($_GET["cal"]));

global $wpdb, $cpabc_addons_active_list;

$current_user = wp_get_current_user();

$format = cpabc_appointments_getDateFormat();

$message = "";

$current_page = intval($_GET["p"]);
if (!$current_page) $current_page = 1;
$records_per_page = 50;  

if (isset($_GET['delmark']) && $_GET['delmark'] == '1')
{
    for ($i=0; $i<=$records_per_page; $i++)
    if (isset($_GET['c'.$i]) && $_GET['c'.$i] != '')   
    {
        $item = $wpdb->get_row("SELECT * FROM ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME." WHERE id=".intval($_GET['c'.$i]));
        do_action( 'cpabc_item_deleted', intval($_GET['c'.$i]) );
        $wpdb->get_row("DELETE FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".$item->reference);
        $wpdb->query('DELETE FROM `'.CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.'` WHERE id='.intval($_GET['c'.$i]));       
    }    
    $message = "Marked items deleted";
}
else if (isset($_GET['delmark']) && $_GET['delmark'] == '2')
{
    for ($i=0; $i<=$records_per_page; $i++)
    if (isset($_GET['c'.$i]) && $_GET['c'.$i] != '')   
    {
        $item = $wpdb->get_row("SELECT * FROM ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME." WHERE id=".intval($_GET['c'.$i]));
        $itemdata = $wpdb->get_row("SELECT * FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".intval($item->reference));
        //print_r($_POST);exit;
        $params = unserialize($itemdata->buffered_date);
        $email_content = $_REQUEST["smscontent"];
        do_action( 'cpabc_smssend', array('params' => $params, 'formid' => $item->appointment_calendar_id, 'content' => $email_content) ); 
    }    
    $message = "SMS message(s) sent";
}
else if (isset($_GET['paid']) && intval($_GET['paid']))
{
    $item = $wpdb->get_row("SELECT * FROM ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME." WHERE id=".intval($_GET['paid']));
    $itemdetails = $wpdb->get_row("SELECT * FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".intval($item->reference));    
    $data = unserialize($itemdetails->buffered_date);
    if (intval($_GET['paidac']))
    {
        $data["payment_type"] = 'Manually updated';
    }
    else
    {
        unset($data["payment_type"]);
        unset($data["txnid"]);
    }
    //print_r($data);
    do_action( 'cpabc_update_paid_status', intval($item->reference), (intval($_GET['paidac'])?true:false) );
    $wpdb->query("UPDATE ".CPABC_APPOINTMENTS_TABLE_NAME." set buffered_date='".esc_sql(serialize($data))."' WHERE id=".intval($item->reference));   
    $message = "Paid status updated.";
}
else if (isset($_GET['ld']) && $_GET['ld'] != '')
{
    $item = $wpdb->get_row("SELECT * FROM ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME." WHERE id=".intval($_GET['ld']));
    $itemdetails = $wpdb->get_row("SELECT * FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".intval($item->reference));
    $data = unserialize($itemdetails->buffered_date);
    foreach ($data as $itemname => $itemvalue)   
        if (strpos($itemname,'_link'))
            @unlink($itemvalue[0]);
    do_action( 'cpabc_item_deleted', intval($_GET['ld']) );
    $wpdb->get_row("DELETE FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".$item->reference);
    $wpdb->query('DELETE FROM `'.CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.'` WHERE id='.intval($_GET['ld']));       
    $message = "Item deleted";
} 
else if (isset($_GET['cancel']) && $_GET['cancel'] != '')
{    
    $wpdb->query("UPDATE `".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME."` SET who_cancelled='".$current_user->ID."',is_cancelled='1',cancelled_reason='".esc_sql($_GET["reason"])."' WHERE id=".$_GET['cancel']);
    $message = "Item cancelled";
    $_GET['cancel'] = intval($_GET['cancel']);
    // send email to customer       
    $item = $wpdb->get_row("SELECT * FROM ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME." WHERE id=".$_GET['cancel']); 
    
    $app_source = $wpdb->get_row("SELECT * FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".$item->reference); 
    $params = unserialize($app_source->buffered_date);
    if ('html' == cpabc_get_option('cncustomer_emailformat')) $content_type = "Content-Type: text/html; charset=utf-8\n"; else $content_type = "Content-Type: text/plain; charset=utf-8\n";
    $email_content = str_replace('%INFORMATION%',str_replace('<br />',"\n",$item->description_customer), cpabc_get_option('cemail_notification_to_customer') );   
    $params['ITEMNUMBER'] = $_GET['cancel'];
    foreach ($params as $itemr => $value)
    {
        $email_content = str_replace('<%'.$itemr.'%>',(is_array($value)?(implode(", ",$value)):($value)),$email_content);
        $email_content = str_replace('%'.$itemr.'%',(is_array($value)?(implode(", ",$value)):($value)),$email_content);
    }
    $email_content = str_replace("%CALENDAR%", cpabc_get_option('uname'), $email_content);
    $email_content = str_replace("%cancelreason%", $_GET["reason"], $email_content);
    
    wp_mail($item->title, cpabc_get_option('cemail_subject_notification_to_customer'), $email_content,
            "From: \"".cpabc_get_option('notification_from_email')."\" <".cpabc_get_option('notification_from_email').">\r\n".
            $content_type.
            "X-Mailer: PHP/" . phpversion());    
}
else if (isset($_GET['nocancel']) && $_GET['nocancel'] != '')
{    
    $wpdb->query("UPDATE `".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME."` SET who_edited='".$current_user->ID."',is_cancelled='0' WHERE id=".$_GET['nocancel']);           
    $message = "Item un-cancelled";
}
else if (isset($_GET['resend']) && $_GET['resend'] != '')
{    
    // $_GET['nocancel']
    $events = $wpdb->get_results( "SELECT * FROM ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME." WHERE id=".intval($_GET['resend']) );
    $events = $wpdb->get_results( "SELECT * FROM ".CPABC_APPOINTMENTS_TABLE_NAME." WHERE id=".intval($events[0]->reference) );    
    define('CPABC_IS_RESEND', true);
    cpabc_process_ready_to_go_appointment($events[0]->id,'',true);
    $message = "Item re-sent";
}
else if (isset($_GET['del']) && $_GET['del'] == 'all')
{    
    if (CP_CALENDAR_ID == '' || CP_CALENDAR_ID == '0')
    {
        $wpdb->query('DELETE FROM `'.CPABC_APPOINTMENTS_TABLE_NAME.'`');
        $wpdb->query('DELETE FROM `'.CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.'`');           
    }
    else
    {
        $wpdb->query('DELETE FROM `'.CPABC_APPOINTMENTS_TABLE_NAME.'` WHERE calendar='.CP_CALENDAR_ID);
        $wpdb->query('DELETE FROM `'.CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.'` WHERE appointment_calendar_id='.CP_CALENDAR_ID);           
    }
    $message = "All items deleted";
} 
else if (isset($_GET["message"]))
    $message = $_GET["message"];

if (CP_CALENDAR_ID == '' || CP_CALENDAR_ID == '0')
    $mycalendarrows = $wpdb->get_results( 'SELECT * FROM '.CPABC_APPOINTMENTS_CONFIG_TABLE_NAME );
else
    $mycalendarrows = $wpdb->get_results( 'SELECT * FROM '.CPABC_APPOINTMENTS_CONFIG_TABLE_NAME .' WHERE `'.CPABC_TDEAPP_CONFIG_ID.'`='.CP_CALENDAR_ID);

if ( 'POST' == $_SERVER['REQUEST_METHOD'] && isset( $_POST['cpabc_appointments_post_options'] ) )
    echo "<div id='setting-error-settings_updated' class='updated settings-error'> <p><strong>Settings saved.</strong></p></div>";

$current_user = wp_get_current_user();

if (cpabc_appointment_is_administrator() || cpabc_appointments_user_access_to (CP_CALENDAR_ID)) {

                                                                                

$cond = '';
if (!empty($_GET["search"]) && $_GET["search"] != '') $cond .= " AND (title like '%".esc_sql($_GET["search"])."%' OR description LIKE '%".esc_sql($_GET["search"])."%')";
if (!empty($_GET["dfrom"]) && $_GET["dfrom"] != '') $cond .= " AND (datatime >= '".esc_sql($_GET["dfrom"])."')";
if (!empty($_GET["dto"]) && $_GET["dto"] != '') $cond .= " AND (datatime <= '".esc_sql($_GET["dto"])." 23:59:59')";

if (!empty($_GET["added_by"]) && $_GET["added_by"] != '') $cond .= " AND (who_added >= '".esc_sql($_GET["added_by"])."')";
if (!empty($_GET["edited_by"]) && $_GET["edited_by"] != '') $cond .= " AND (who_edited >= '".esc_sql($_GET["edited_by"])."')";
if (!empty($_GET["cancelled_by"]) && $_GET["cancelled_by"] != '') $cond .= " AND (is_cancelled='1' AND who_cancelled >= '".esc_sql($_GET["cancelled_by"])."')";
if (!empty($_GET["cstatus"]) && $_GET["cstatus"] == 'cancelled') $cond .= " AND (is_cancelled='1')";
if (!empty($_GET["cstatus"]) && $_GET["cstatus"] == 'approved') $cond .= " AND (is_cancelled<>'1')";

$orderby = @$_GET["orderby"];
if ($orderby == '')
    $orderby = 'datatime DESC';

if (CP_CALENDAR_ID == '' || CP_CALENDAR_ID == '0')
    $events = $wpdb->get_results( "SELECT ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.".*,".CPABC_APPOINTMENTS_TABLE_NAME.".buffered_date,".CPABC_APPOINTMENTS_TABLE_NAME.".time FROM ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME." LEFT JOIN  ".CPABC_APPOINTMENTS_TABLE_NAME." ON  ".CPABC_APPOINTMENTS_TABLE_NAME.".id=".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.".reference WHERE 1=1".$cond." ORDER BY ".$orderby." " );
else
    $events = $wpdb->get_results( "SELECT ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.".*,".CPABC_APPOINTMENTS_TABLE_NAME.".buffered_date,".CPABC_APPOINTMENTS_TABLE_NAME.".time FROM ".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME." LEFT JOIN  ".CPABC_APPOINTMENTS_TABLE_NAME." ON  ".CPABC_APPOINTMENTS_TABLE_NAME.".id=".CPABC_APPOINTMENTS_CALENDARS_TABLE_NAME.".reference WHERE appointment_calendar_id=".CP_CALENDAR_ID.$cond." ORDER BY ".$orderby." " );    
$total_pages = ceil(count($events) / $records_per_page);

$quantity_listed = 0;
for ($i=0; $i<count($events); $i++)
    $quantity_listed += $events[$i]->quantity;

$users_arr = array();
$users_arr['id-1'] = 'CUSTOMER';
$users = $wpdb->get_results( "SELECT user_login,ID FROM ".$wpdb->users." ORDER BY ID DESC" );                                                                     
foreach ($users as $user)
    $users_arr["id".$user->ID] = $user;

if ($message) echo "<div id='setting-error-settings_updated' class='updated settings-error'><p><strong>".$message."</strong></p></div>";

?>

<script type="text/javascript">
 function cp_paidMessageItem(id,ac)
 {
    if (confirm('Are you sure that you want to change this paid status?'))
    {        
        document.location = 'admin.php?page=cpabc_appointments&cal=<?php echo intval($_GET["cal"]); ?>&list=1&paid='+id+'&paidac='+ac+'&r='+Math.random();
    }
 }
 function cp_deleteMessageItem(id)
 {
    if (confirm('Are you sure that you want to delete this item?'))
    {        
        document.location = 'admin.php?page=cpabc_appointments&cal=<?php echo intval($_GET["cal"]); ?>&list=1&ld='+id+'&r='+Math.random();
    }
 }
 function cp_editItem(id, cal)
 {
     document.location = 'admin.php?page=cpabc_appointments&cal='+cal+'&edit='+id+'&r='+Math.random();
 }
 function cp_uncancelItem(id)
 {
    if (confirm('Are you sure that you want to un-cancel this item?'))
    {        
        document.location = 'admin.php?page=cpabc_appointments&cal=<?php echo intval($_GET["cal"]); ?>&list=1&nocancel='+id+'&r='+Math.random();
    }
 }
 function cp_resendItem(id)
 {
    if (confirm('Are you sure that you want to resend this email?'))
    {        
        document.location = 'admin.php?page=cpabc_appointments&cal=<?php echo intval($_GET["cal"]); ?>&list=1&resend='+id+'&r='+Math.random();
    }
 }
 function cp_cancelItem(id)
 {
        var reason;
        if (reason = prompt('Please enter cancellation reason:'))
        {
                document.location = 'admin.php?page=cpabc_appointments&cal=<?php echo intval($_GET["cal"]); ?>&list=1&cancel='+id+'&reason='+reason;
        }
 }
 function do_dexapp_deleteall()
 {
    if (confirm('Are you sure that you want to delete ALL bookings for this calendar?'))
    {        
        document.location = 'admin.php?page=cpabc_appointments&cal=<?php echo intval($_GET["cal"]); ?>&list=1&del=all&r='+Math.random();
    }    
 }
 function do_dexapp_sendsmsmarked()
 {
    if (confirm('Are you sure that you want to send the messages to the selected recipients?'))
    {        
        document.dex_table_form.delmark.value = 2;
        document.dex_table_form.submit();
    }    
 }
 function tryToExport()
 {
     if (!document.getElementById("dfrom").value || !document.getElementById("dto").value || !document.getElementById("scalitem").options.selectedIndex)
     {
         alert('Please select the from-to time range for the export and also to the related calendar');
         return false;
     }
     else
         return true;
 } 
</script>
<div class="wrap">
<h1>BookingFish Calendar - Bookings List</h1>

<input type="button" name="backbtn" value="Back to items list..." onclick="document.location='admin.php?page=cpabc_appointments';">


<div id="normal-sortables" class="meta-box-sortables">
 <hr />
 <?php if (CP_CALENDAR_ID != '' && CP_CALENDAR_ID != '0') { ?>
 <h3>This booking list applies only to: <?php echo $mycalendarrows[0]->uname; ?></h3>
 <?php } else { ?>
 <h3>This booking list contains the bookings from ALL calendars.</h3>
 <?php } ?>
</div>



<form action="admin.php" method="get">
 <input type="hidden" name="page" value="cpabc_appointments" />
 <input type="hidden" name="list" value="1" />
 <table>
  <tr>
   <td align="right">Search for:</td>
   <td><input type="text" name="search" value="<?php echo esc_attr($_GET["search"]); ?>" /></td>
   <td align="right">From:</td>
   <td><input type="text" id="dfrom" name="dfrom" value="<?php echo esc_attr($_GET["dfrom"]); ?>" /></td> 
   <td align="right">To:</td>
   <td><input type="text" id="dto" name="dto" value="<?php echo esc_attr($_GET["dto"]); ?>" /></td>
  </tr> 
<?php if (cpabc_appointment_is_administrator()) { ?>     
  <tr>
   <td align="right">Added by:</td>
   <td><select name="added_by"><option value="">--- all users ---</option><?php foreach ($users as $user) echo '<option value="'.$user->ID.'"'.($user->ID==$_GET["added_by"]?' selected':'').'>'.$user->user_login.'</option>'; ?></select></td>
   <td align="right">Edited by:</td>
   <td><select name="edited_by"><option value="">--- all users ---</option><?php foreach ($users as $user) echo '<option value="'.$user->ID.'"'.($user->ID==$_GET["edited_by"]?' selected':'').'>'.$user->user_login.'</option>'; ?></select></td>
   <td align="right">Cancelled by:</td>
   <td><select name="cancelled_by"><option value="">--- all users ---</option><?php foreach ($users as $user) echo '<option value="'.$user->ID.'"'.($user->ID==$_GET["cancelled_by"]?' selected':'').'>'.$user->user_login.'</option>'; ?></select></td>
  </tr>
  <tr>
   <td align="right">Status:</td>  
   <td><select name="cstatus">
        <option value="">--- all ---</option>
        <option value="approved" <?php if (!empty($_GET["cstatus"]) && $_GET["cstatus"] == 'approved') echo ' selected '; ?>>active</option>
        <option value="cancelled" <?php if (!empty($_GET["cstatus"]) && $_GET["cstatus"] == 'cancelled') echo ' selected '; ?>>cancelled</option>
       </select></td>  
   <td align="right">Calendar</td>
   <td>
     <select name="cal" id="scalitem">
      <option value="0">--- all calendars ---</option>
      <?php 
        $calendars = $wpdb->get_results( "SELECT * FROM ".CPABC_APPOINTMENTS_CONFIG_TABLE_NAME ); 
        $calendars_id = array();
        foreach ($calendars as $item)
        {
            echo '<option value="'.$item->id.'"'.($_GET["cal"]==$item->id?' selected':'').'>'.$item->uname.'</option>';
            $calendars_id["id".$item->id] = $item->uname;
        }
      ?>
     </select>
   </td>  
<?php } else { ?>   
  <tr>
   <td align="right">Calendar</td>
   <td>
     <select name="cal" id="scalitem">
      <!--<option value="0">--- all calendars ---</option>-->
      <?php 
        $calendars = $wpdb->get_results( "SELECT * FROM ".CPABC_APPOINTMENTS_CONFIG_TABLE_NAME." WHERE conwer=".$current_user->ID ); 
        $calendars_id = array();
        foreach ($calendars as $item)
        {
            echo '<option value="'.$item->id.'"'.($_GET["cal"]==$item->id?' selected':'').'>'.$item->uname.'</option>';
            $calendars_id["id".$item->id] = $item->uname;
        }
      ?>
     </select>
   </td>      
<?php } ?>
   <td align="right" nowrap>Order By</td>
   <td colspan="2">     
     <select name="orderby">
      <option value="id DESC" <?php if ($orderby == 'id DESC') echo ' selected'; ?>>Submission time - desc</option>
      <option value="id ASC" <?php if ($orderby == 'id ASC') echo ' selected'; ?>>Submission time - asc</option>
      <option value="datatime DESC" <?php if ($orderby == 'datatime DESC') echo ' selected'; ?>>Appointment time - desc</option>
      <option value="datatime ASC" <?php if ($orderby == 'datatime ASC') echo ' selected'; ?>>Appointment time - asc</option>
     </select>   
</td>     
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td colspan="5">  
     <span class="submit"><input type="submit" name="ds" value="Filter" /></span> &nbsp; &nbsp; &nbsp; 
     <nobr>
     <span class="submit"><input type="submit" name="cpabc_appointments_csv" value="Export to CSV" /></span>&nbsp; &nbsp; &nbsp; 
     <span class="submit"><input type="submit" name="cpabc_appointments_csv_unused" value="Export to CSV w/ unused slots" onclick="return tryToExport();" /></span>
     </nobr>
   </td>
  </tr>
 </table>
  
</form>

<br />
     
Total bookings for this search: <?php echo count($events); ?><br />
Total quantity for this search: <?php echo $quantity_listed; ?><br />     
<?php


echo paginate_links(  array(
    'base'         => 'admin.php?page=cpabc_appointments&cal='.CP_CALENDAR_ID.'&list=1%_%&dfrom='.urlencode($_GET["dfrom"]).'&dto='.urlencode($_GET["dto"]).'&search='.urlencode($_GET["search"]),
    'format'       => '&p=%#%',
    'total'        => $total_pages,
    'current'      => $current_page,
    'show_all'     => False,
    'end_size'     => 1,
    'mid_size'     => 2,
    'prev_next'    => True,
    'prev_text'    => '&laquo; '.__('Previous','cpabc'),
    'next_text'    => __('Next','cpabc').' &raquo;',
    'type'         => 'plain',
    'add_args'     => False
    ) );

?>


<div id="cpabc_printable_contents">
<form name="dex_table_form" id="dex_table_form" action="admin.php" method="get">
 <input type="hidden" name="page" value="cpabc_appointments" />
 <input type="hidden" name="cal" value="<?php echo intval($_GET["cal"]); ?>" />
 <input type="hidden" name="list" value="1" />
 <input type="hidden" name="delmark" value="1" />
<table class="wp-list-table widefat fixed pages" cellspacing="0">
	<thead>
	<tr>
      <th width="10"><input type="checkbox" name="cpcontrolck" id="cpcontrolck" value="" onclick="cp_markall();"></th>
	  <th width="30"></th>
	  <?php if (CP_CALENDAR_ID == '' || CP_CALENDAR_ID == '0') { ?>
	  <th style="padding-left:7px;font-weight:bold;">Calendar</th>
	  <?php } ?>
	  <th style="padding-left:7px;font-weight:bold;">ItemNumber</th>
	  <th style="padding-left:7px;font-weight:bold;">Booked Date</th>
	  <th style="padding-left:7px;font-weight:bold;">Email</th>
	  <th style="padding-left:7px;font-weight:bold;">Description</th>
	  <th style="padding-left:7px;font-weight:bold;">Quantity</th>
	  <th style="padding-left:7px;font-weight:bold;">Reminder</th>
      <?php if (isset($mycalendarrows[0]->enable_confirmation) && $mycalendarrows[0]->enable_confirmation) { ?> <th style="padding-left:7px;font-weight:bold;">Confirmed?</th><?php } ?>
	  <?php if ((get_option('CPABC_ENABLE_VALIDATIONS',"1") == '2')) { ?> <th style="padding-left:7px;font-weight:bold;">Verified?</th><?php } ?>
	  <th style="padding-left:7px;font-weight:bold;">Options</th>
	</tr>
	</thead>
	<tbody id="the-list">
	 <?php
     for ($i=($current_page-1)*$records_per_page; $i<$current_page*$records_per_page; $i++) if (isset($events[$i])) { 
     ?>
	  <tr class='<?php if (!($i%2)) { ?>alternate <?php } ?>author-self status-draft format-default iedit' valign="top">
	    <td width="1%"><input type="checkbox" name="c<?php echo $i-($current_page-1)*$records_per_page; ?>" value="<?php echo $events[$i]->id; ?>" /></td>
	    <?php if (CP_CALENDAR_ID == '' || CP_CALENDAR_ID == '0') { ?>
	    <td><?php echo $calendars_id["id".$events[$i]->appointment_calendar_id]; ?></td>
	    <?php } ?>
	    <td <?php if ($events[$i]->is_cancelled == '1') { ?>style="color:#faabbb;"<?php } ?>><?php echo $events[$i]->id; ?></td>
		<td <?php if ($events[$i]->is_cancelled == '1') { ?>style="color:#faabbb;"<?php } ?>><?php echo date($format,strtotime($events[$i]->datatime)); ?></td>
		<td <?php if ($events[$i]->is_cancelled == '1') { ?>style="color:#faabbb;"<?php } ?>><?php echo $events[$i]->title; ?></td>
		<td <?php if ($events[$i]->is_cancelled == '1') { ?>style="color:#faabbb;"<?php } ?>><?php
         $data = $events[$i]->description; 
         $data = str_replace('\"','"', $data);  
         $data = str_replace("&lt;img ","<img ", $data); 
         echo $data;
        ?></td>
		<td <?php if ($events[$i]->is_cancelled == '1') { ?>style="color:#faabbb;"<?php } ?>><?php echo $events[$i]->quantity; ?></td>
		<td <?php if ($events[$i]->is_cancelled == '1') { ?>style="color:#faabbb;"<?php } ?>>
		      <?php 		       
		        if ($events[$i]->reminder == '1')
		           echo '<strong>Already Sent!<br /></strong>';
		        else  
		           echo '-';   	        
		        
		      ?>		      
		</td>
        <?php if (isset($mycalendarrows[0]->enable_confirmation) && $mycalendarrows[0]->enable_confirmation) { ?>
          <td <?php if ($events[$i]->confirmation == '2') { ?>style="color:#44a658;"<?php } ?>>
		      <?php 		       
		        if ($events[$i]->confirmation == '1')
		           echo '<em>Request sent</em>';
                else if ($events[$i]->confirmation == '2')
                    echo '<strong>Confirmed!<br /></strong>';
		        else  
		           echo '-';   	        
		        
		      ?>		      
		</td>		
		<?php } ?>      
		<?php if ((get_option('CPABC_ENABLE_VALIDATIONS',"1") == '2')) { ?>
        <td <?php if ($events[$i]->is_cancelled == '1') { ?>style="color:#faabbb;"<?php } ?>>
		      <?php 		       
		        if ($events[$i]->is_verified == '1')
		           echo '<strong>Yes!<br /></strong>';
		        else  
		           echo 'No';   	        
		        
		      ?>		      
		</td>		
		<?php } ?>
		<td <?php if ($events[$i]->is_cancelled == '1') { ?>style="color:#faabbb;"<?php } ?>>
		  <input type="button" name="caledit_<?php echo $events[$i]->id; ?>" value="Edit" onclick="cp_editItem(<?php echo $events[$i]->id; ?>,<?php echo $events[$i]->appointment_calendar_id; ?>);" />
		  <?php if ($events[$i]->is_cancelled == '1') { ?>
		  <input type="button" name="calcancel_<?php echo $events[$i]->id; ?>" value="Un-Cancel" onclick="cp_uncancelItem(<?php echo $events[$i]->id; ?>);" />
		  <?php } else { ?>
		  <input type="button" name="calcancel_<?php echo $events[$i]->id; ?>" value="Cancel" onclick="cp_cancelItem(<?php echo $events[$i]->id; ?>);" />
		  <?php } ?>
		  <input type="button" name="resend_<?php echo $events[$i]->id; ?>" value="Resend Email" onclick="cp_resendItem(<?php echo $events[$i]->id; ?>);" />          
		  <?php if (cpabc_appointment_is_administrator()) { ?><input type="button" name="caldelete_<?php echo $events[$i]->id; ?>" value="Delete" onclick="cp_deleteMessageItem(<?php echo $events[$i]->id; ?>);" /><?php } ?>
		  <span style="font-style:italic;font-size:11px;">
		  <?php
		    if (isset($users_arr["id".$events[$i]->who_added]))
		        echo '<br />Added by: <strong>'.$users_arr["id".$events[$i]->who_added]->user_login.'</strong>';
		    if (isset($users_arr["id".$events[$i]->who_edited]))
		        echo '<br />Edited by: <strong>'.$users_arr["id".$events[$i]->who_edited]->user_login.'</strong>';
		    if (isset($users_arr["id".$events[$i]->who_cancelled]) && $events[$i]->is_cancelled == '1')
		        if ($events[$i]->who_cancelled == '-1')
		            echo '<br />Cancelled by: <strong><b>'.$users_arr["id".$events[$i]->who_cancelled].'</b></strong>';
		        else
		            echo '<br />Cancelled by: <strong>'.$users_arr["id".$events[$i]->who_cancelled]->user_login.'</strong>';    
		    
		    if ($events[$i]->cancelled_reason != '' && $events[$i]->is_cancelled == '1')
		        echo '<br />Cancelled reason: <strong>'.$events[$i]->cancelled_reason.'</strong>';
        
             $params = unserialize($events[$i]->buffered_date);      
             
             if (array_key_exists("txnid",$params) || (isset($params["payment_type"]) && ($params["payment_type"] != 'PayPal' || isset($params["txnid"]))))
             {
                 echo '<hr /><span class="abcpaid">'.__('Paid.','cpabc');
                 if (isset($params["payment_type"]) && ($params["payment_type"] != 'PayPal' || isset($params["txnid"]))) echo $params["payment_type"].".";
                 if (isset($params["txnid"])) echo __('Payment ID','cpabc').": ".($params["txn_id"]?$params["txn_id"]:' --- ');
                 echo '</span>';
                 ?><br /><input type="button" name="calpaide_<?php echo $events[$i]->id; ?>" value="Mark as unpaid" onclick="cp_paidMessageItem(<?php echo $events[$i]->id; ?>,0);" /><?php
             }
             else   
             {
                 echo '<hr /><span class="abcunpaid">'.__('Payment: not confirmed so far','cpabc').'</span>';
                 ?><br /><input type="button" name="calpaide_<?php echo $events[$i]->id; ?>" value="Mark as paid" onclick="cp_paidMessageItem(<?php echo $events[$i]->id; ?>,1);" /><?php
             }
              echo '<hr /><span class="abcsubdate">'.__('Submission date:','cpabc').'</span><br /><strong>'. date($format,strtotime($events[$i]->time)).'</strong>';
		  ?>
		  </SPAN>
		</td>		
      </tr>
     <?php } ?>
	</tbody>
</table>

</div>


<br /><input type="button" name="pbutton" value="Print" onclick="do_dexapp_print();" />

<div style="clear:both"></div>
<?php if (cpabc_appointment_is_administrator()) { ?>
<p class="submit" style="float:left;"><input type="button" name="pbutton" value="Delete marked items" onclick="do_dexapp_deletemarked();" /> &nbsp; &nbsp; &nbsp; </p>

<p class="submit" style="float:left;"><input type="button" name="pbutton" value="Delete All Bookings" onclick="do_dexapp_deleteall();" /></p>
<?php } ?>


<?php if ( in_array('addon-TwilioSMS-20180301',$cpabc_addons_active_list) || in_array('addon-clickatell-20170403',$cpabc_addons_active_list) ) { ?>
<div style="clear:both"></div>
<fieldset style=" border:1px solid;padding:10px; "><legend style="padding: 0.2em 0.5em;border:1px solid;">Mass SMS to the selected recipients</legend>
<textarea name="smscontent" cols="80" rows="3">We see it has been some time since your last booking. Use the following link to make a new appointment: <?php echo get_site_url(); ?></textarea><br />
<input type="button" name="smsbutton" value="Send SMS" onclick="do_dexapp_sendsmsmarked();" />
</fieldset>
<?php } ?>


</div>


<script type="text/javascript">
 function do_dexapp_print()
 {
      w=window.open();
      w.document.write("<style>table{border:2px solid black;width:100%;}th{border-bottom:2px solid black;text-align:left}td{padding-left:10px;border-bottom:1px solid black;}</style>"+document.getElementById('cpabc_printable_contents').innerHTML);
      w.print();     
 }
 function do_dexapp_deletemarked()
 {
    document.dex_table_form.submit();
 } 
 var $j = jQuery.noConflict();
 $j(function() {
 	$j("#dfrom").datepicker({     	                
                    dateFormat: 'yy-mm-dd'
                 });
 	$j("#dto").datepicker({     	                
                    dateFormat: 'yy-mm-dd'
                 });
 });
 
 function cp_markall()
 {
     var ischecked = document.getElementById("cpcontrolck").checked;
     <?php for ($i=($current_page-1)*$records_per_page; $i<$current_page*$records_per_page; $i++) if (isset($events[$i])) { ?>
     document.forms.dex_table_form.c<?php echo $i-($current_page-1)*$records_per_page; ?>.checked = ischecked;
     <?php } ?>
 }  
 
</script>
<style>
.abcpaid { font-weight: bold; color: green; font-size: 110%; }
.abcunpaid {  }
</style>


<?php } else { ?>
  <br />
  The current user logged in doesn't have enough permissions to edit this calendar. This user can edit only his/her own calendars. Please log in as administrator to get access to all calendars.

<?php } ?>








