<?php

if ( !is_admin() )
{
    echo 'Direct access not allowed.';
    exit;
}

if (!defined('CP_CALENDAR_ID'))
    define ('CP_CALENDAR_ID', intval($_GET["cal"]));

global $wpdb;

$message = ""; 

if (!cpabc_appointment_is_administrator()) {
    echo 'Not enough user access level';
    exit;
}
    
if (isset($_POST["cpabc_scheset_post_edition"]) && wp_verify_nonce ($_POST["nonce"], 'cpabc_actions_admin'))
{
    $posteddata = stripslashes_deep($_POST);
    update_option('cp_abc_schcaltitle_admin',$posteddata['cp_abc_schcaltitle_admin']);
    update_option('cp_abc_schcalcontent_admin',$posteddata['cp_abc_schcalcontent_admin']);
    update_option('cp_abc_schcaltitle_public',$posteddata['cp_abc_schcaltitle_public']);
    update_option('cp_abc_schcalcontent_public',$posteddata['cp_abc_schcalcontent_public']);
    update_option('cp_abc_schcalcontent_exclude',$posteddata['cp_abc_schcalcontent_exclude']);
    update_option('cp_abc_schcalcontent_otherparams',$posteddata['cp_abc_schcalcontent_otherparams']);
    $message = "Settings updated."; 
}

$nonce = wp_create_nonce( 'cpabc_actions_admin' );

                                                                             



if ($message) echo "<div id='setting-error-settings_updated' class='updated settings-error'><p><strong>".$message."</strong></p></div>";

$nonce_un = wp_create_nonce( 'uname_abc_bklist' );

?>
<div class="wrap">
<h1>Appointment Booking Calendar - Calendar Schedule Settings</h1>

<br />
<div class="ahb-buttons-container">    
    
     <input type="button" value="<?php _e('Back to calendar...','appointment-hour-booking'); ?>" class="button" style="margin-left:0px;" onclick="document.location='?page=cpabc_appointments&cal=<?php echo CP_CALENDAR_ID; ?>&calschedule=1';" />
   
	<div class="clear"></div>
</div>


<div id="cpabc_printable_contents">

  <p>In this area you can customize the data displayed in the "<strong>Schedule Calendar View</strong>" of the dashboard accessible through the "<strong>Schedule</strong>" button in the <a href="<?php print esc_attr(admin_url('admin.php?page=cpabc_appointments'));?>">calendars list</a> and the data displayed in the schedule calendar you can publish in the public website.
    <form  method="post" action="" name="cpformconf6">
        <input name="nonce" type="hidden" value="<?php echo $nonce; ?>" />
        <input name="cpabc_scheset_post_edition" type="hidden" value="1" />       
	    <table class="form-table">
            <tbody>
                <tr valign="top">
	    	 		<th colspan="2" style="border-top: 1px dotted black">
	    				<label><?php _e('CONTENTS FOR CALENDAR DISPLAYED ADMIN AREA','cpabc'); ?>:</label>
	    			</th>
                </tr>    
	    		<tr valign="top">
	    			<th scope="row">
	    				<label><?php _e('Event title','cpabc'); ?></label>
	    			</th>
	    			<td>
	    				<input name="cp_abc_schcaltitle_admin" type="text" value="<?php echo esc_attr(get_option('cp_abc_schcaltitle_admin',CP_ABC_SCHCALTITLE_ADMIN)); ?>" /><br />
                        <em>Available tags: %email%, %itemnumber%, %id%, %INFORMATION%</em>                        
	    			</td>
	    		</tr>
	    		<tr valign="top">
	    			<th scope="row">
	    				<label><?php _e('Event Content','cpabc'); ?></label>
	    			</th>
	    			<td>
	    				<textarea cols="80" rows="3"  name="cp_abc_schcalcontent_admin"><?php echo esc_attr(get_option('cp_abc_schcalcontent_admin',CP_ABC_SCHCALCONTENT_ADMIN)); ?></textarea><br />
                        <em>Available tags: %email%, %itemnumber%, %id%, %INFORMATION%.</em>
	    			</td>
	    		</tr>
                <tr valign="top">
	    	 		<th colspan="2" style="border-top: 1px dotted black">
	    				<label><?php _e('CONTENTS FOR CALENDAR DISPLAYED PUBLIC WEBSITE','cpabc'); ?>:</label>
	    			</th>
                </tr>    
	    		<tr valign="top">
	    			<th scope="row">
	    				<label><?php _e('Event title','cpabc'); ?></label>
	    			</th>
	    			<td>
	    				<input name="cp_abc_schcaltitle_public" type="text" value="<?php echo esc_attr(get_option('cp_abc_schcaltitle_public',CP_ABC_SCHCALTITLE_PUBLIC)); ?>" /><br />
                        <em>Available tags: %email%, %itemnumber%, %id%, %INFORMATION%</em>
	    			</td>
	    		</tr>
	    		<tr valign="top">
	    			<th scope="row">
	    				<label><?php _e('Event Content','cpabc'); ?></label>
	    			</th>
	    			<td>
	    				<textarea cols="80" rows="3" name="cp_abc_schcalcontent_public"><?php echo esc_attr(get_option('cp_abc_schcalcontent_public',CP_ABC_SCHCALCONTENT_PUBLIC)); ?></textarea><br />
                        <em>Available tags: %email%, %itemnumber%, %id%, %INFORMATION%</em>
	    			</td>
	    		</tr>     
                <tr valign="top">
	    	 		<th colspan="2" style="border-top: 1px dotted black">
	    				<label><?php _e('ADVANCED SETTINGS','cpabc'); ?>:</label>
	    			</th>
                </tr>       
	    		<tr valign="top" style="display:none">
	    			<th scope="row">
	    				<label><?php _e('Exclude calendar from schedule contents','cpabc'); ?></label>
	    			</th>
	    			<td>
	    				<input size="80" name="cp_abc_schcalcontent_exclude" value="<?php echo esc_attr(get_option('cp_abc_schcalcontent_exclude','')); ?>" /><br />
                        <em>Indicate the calendar ID to be excluded, ex: <strong>fieldname1</strong>. Comma separated for multiple IDs.</em>
	    			</td>
	    		</tr>    
	    		<tr valign="top">
	    			<th scope="row">
	    				<label><?php _e('Other parameters','cpabc'); ?></label>
	    			</th>
	    			<td>
                        <textarea cols="80" rows="3" name="cp_abc_schcalcontent_otherparams"><?php echo esc_textarea(get_option('cp_abc_schcalcontent_otherparams','')); ?></textarea><br />
                        <em><a href="https://wordpress.dwbooster.com/demos/multi-view/17-selecting-hours-to-be-shown.html" target="_blank">Click for sample "Other Parameters"</a>.</em>
	    			</td>
	    		</tr>                 
	    	</tbody>
	    </table>
	    <input type="submit" value="Update Changes" class="button button-primary" />
    </form>

</div>

<div style="clear:both"></div>


</div>











