<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if(isset($_POST['phoen_reset']))
{
	//$arg ='dashboard,downloads,orders,edit-account,edit-address,customer-logout';
	$arg ='dashboard,downloads,orders,edit-account,edit-address,customer-logout,support-ticket';

	$dashbord =array(
		'active'=>'1',
		'label'=>'Dashboard',
		'icon'=>'tachometer',
		'content'=>'',
		'role_based'=>'',
		'type'=>'pre'
	); 
	
	$my_downloads =array(
		'active'=>'1',
		'slug'=>'downloads',
		'label'=>'My Downloads',
		'icon'=>'download',
		'content'=>'[my_downloads_content]',
		'type'=>'pre',
		'role_based'=>'',
		'edit_content_download'=>'No downloads available yet.'
	); 
	
	$view_orders =array(
		'active'=>'1',
		'slug'=>'orders',
		'label'=>'My Orders',
		'icon'=>'file-text-o',
		'content'=>'[view_order_content]',
		'type'=>'pre',
		'role_based'=>'',
		'edit_content_order'=>'No order has been made yet.'
	); 
	
	$edit_account =array(
		'active'=>'1',
		'slug'=>'edit-account',
		'label'=>'Edit Account',
		'icon'=>'pencil-square-o',
		'content'=>'',
		'role_based'=>'',
		'type'=>'pre'
	); 
	
	$edit_address =array(
		'active'=>'1',
		'slug'=>'edit-address',
		'label'=>'Edit Address',
		'icon'=>'pencil-square-o',
		'content'=>'',
		'role_based'=>'',
		'type'=>'pre'
	); 
	
	$log_out =array(
		'active'=>'1',
		'slug'=>'customer-logout',
		'label'=>'Logout',
		'icon'=>'pencil-square-o',
		'role_based'=>'',
		'type'=>'pre'
	);
	
	/* $payment_methods =array(
		'active'=>'1',
		'slug'=>'payment-methods',
		'label'=>'Payment Methods',
		'icon'=>'pencil-square-o',
	); */
	
	
	update_option('phoen-endpoint', $arg);
	update_option('phoen-endpoint-dashboard', $dashbord);
	update_option('phoen-endpoint-downloads', $my_downloads);
	//update_option('phoen-endpoint-payment-methods', $payment_methods);
	update_option('phoen-endpoint-orders', $view_orders);
	update_option('phoen-endpoint-edit-account', $edit_account);
	update_option('phoen-endpoint-edit-address', $edit_address);
	update_option('phoen-endpoint-customer-logout', $log_out);
}


if(isset($_POST['add']))
{
	$title = sanitize_text_field($_POST['phoen-new-endpoint']);
	
	$endpoint_order = sanitize_text_field($_POST['endpoints-order']);
	
	$slug = strtolower( $title );
	
	$slug = trim( $slug );
	
	$slug = preg_replace( '/[^a-z]/', '-', $slug );
	
	$endpoint_name = sanitize_title(trim($title));
	
	$endpoint_order = $endpoint_order.','.$slug;
	
	$arg = array(
					'active'=>'1',
					'slug'=>$slug,
					'label'=>$endpoint_name,
					'icon'=>'',
					'content'=>'',
					'type'=>'custom',
					'role_based'=>'',
				); 
		
	update_option('phoen-endpoint-'.$slug.'', $arg);
	
	$check = update_option('phoen-endpoint', $endpoint_order);

	if($check ==1)
	{
	?>

		<div class="updated" id="message">

			<p><strong><?php _e('Add menu successfully','custom-my-account');?></strong></p>

		</div>

	<?php
	}
	else
	{
	?>
		<div class="error below-h2" id="message"><p> <?php _e('Something Went Wrong Please Try Again With Valid Data.','custom-my-account');?></p></div>
		
	<?php
	}

}

if(isset($_POST['submit']))
{
	/* echo "<pre>";
	print_r($_POST);
	echo "</pre>"; */
	
	$data = get_option('phoen-endpoint');

	$endpoint = explode(',',$data);
	
	foreach($endpoint as $point)
	{
		
		$value = $_POST["phoen-endpoint-".$point.""];
		 
		$check = update_option('phoen-endpoint-'.$point.'', $value);
	}
	
	$endpoints = sanitize_text_field($_POST['endpoints-order']);
	
	update_option('phoen-endpoint',$endpoints);

	
	?>

		<div class="updated" id="message">

			<p><strong><?php _e('Menus updated.','custom-my-account');?></strong></p>

		</div>

	<?php
}
?>

<form method="post" action="">

	<table class="form-table" style="background:#fff;">
		
		<tbody>
			
			<h3><?php _e(' Menu Options.','custom-my-account');?></h3>
			
			<tr valign="top">	
				
				<th>
				
					<h3><?php _e('Manage Menus','custom-my-account');?></h3>
				
				</th>
				
				<td class="phoen-endpoint-container">
					
					<ul class="endpoints ui-sortable" id="sortable">
					
					<?php 

						$data = get_option('phoen-endpoint');
	 
						$endpoint = explode(',',$data);
						
						foreach($endpoint as $ep)
						{
							 
							
							$row = get_option('phoen-endpoint-'.$ep.''); 
								
							if(!empty($row))
							{
							/* 	echo "<pre>";
								print_r($ep);
								echo "</pre>"; */
							?>					
					
							<li style="border: 1px solid #dfdfdf;" class="endpoint ui-sortable-handle ui-state-default">
								
								<span style="float:left;">
									<input type="checkbox" <?php if(isset($row['active']) && $row['active']==1){echo 'checked';}?> value="1" name="phoen-endpoint-<?php echo $ep.'[active]'; ?>">
								</span>
								<?php $endpoint_label = str_replace("\'", "'", $row['label']);
								$endpoint_label = str_replace('\"','"', $endpoint_label);
									?>
								<div class="header" >
									<label for="phoen-endpoint-<?php echo $ep.'-active';?>"><?php echo ucfirst($endpoint_label);?></label>
								</div>
								 
								<div class="options" style="display:none;">
								
									<?php 
									
									if($ep!='dashboard' && $ep!='downloads' && $ep!='orders' && $ep!='edit-account' && $ep!='edit-address' && $ep!='customer-logout' || $ep!='support-ticket'){?>
										
										<div class="options-row">
											
											<a class="remove-link" data-endpoint="<?php echo $ep?>"><?php _e('Remove','custom-my-account');?></a>
											
										</div>
									<?php   
									} ?> 
									<table class="form-table">
										<tbody>
											<tr>
											<?php 
											if($ep!="dashboard"){?>
												<tr>
													<th><?php _e('Slug','custom-my-account');?></th>
													<td><input type="text" name="phoen-endpoint-<?php echo $ep.'[slug]'; ?>" value="<?php echo strtolower($row['slug']); ?>"></td>
													 
												</tr>
											<?php } ?>
											<?php  	$endpoint_label = str_replace("\'", "'", $row['label']);
													$endpoint_label = str_replace('\"','"', $endpoint_label);
											?>
											
												<tr>
													<th><?php _e('Label','custom-my-account');?></th>
													<td><input type="text" name="phoen-endpoint-<?php echo $ep.'[label]'; ?>" value="<?php echo ucfirst($endpoint_label); ?>"></td>
												</tr>
												<tr>
													<td><input type="hidden" name="phoen-endpoint-<?php echo $ep.'[type]'; ?>" value="<?php echo $row['type']; ?>"></td>
												</tr>
												<tr>
												
													<th><?php _e('icon','custom-my-account');?></th>
													
													<td>
														<select class="phoen-selectbox" style="font-family:'FontAwesome'" name="phoen-endpoint-<?php echo $ep.'[icon]'; ?>">
															<optgroup label="Web Application Icons">
															<option value=""><?php _e('Choose icon','custom-my-account'); ?></option>
															<option value="adjust" <?php if($row['icon']=='adjust'){ echo"selected";}?>> <?php _e('adjust','custom-my-account'); ?></option>
															<option value="adn" <?php if($row['icon']=='adn'){ echo"selected";}?>> <?php _e('adn','custom-my-account'); ?></option>
															<option value="align-center" <?php if($row['icon']=='align-center'){ echo"selected";}?>> <?php _e('align-center','custom-my-account'); ?></option>
															<option value="align-justify" <?php if($row['icon']=='align-justify'){ echo"selected";}?>> <?php _e('align-justify','custom-my-account'); ?></option>
															<option value="align-left" <?php if($row['icon']=='align-left'){ echo"selected";}?>> <?php _e('align-left','custom-my-account'); ?></option>
															<option value="align-right" <?php if($row['icon']=='align-right'){ echo"selected";}?>> <?php _e('align-right','custom-my-account'); ?></option>
															<option value="ambulance" <?php if($row['icon']=='ambulance'){ echo"selected";}?>> <?php _e('ambulance','custom-my-account'); ?></option>
															<option value="anchor" <?php if($row['icon']=='anchor'){ echo"selected";}?>> <?php _e('anchor','custom-my-account'); ?></option>
															<option value="android" <?php if($row['icon']=='android'){ echo"selected";}?>> <?php _e('android','custom-my-account'); ?></option>
															<option value="angellist" <?php if($row['icon']=='angellist'){ echo"selected";}?>> <?php _e('angellist','custom-my-account'); ?></option>
															<option value="angle-double-down" <?php if($row['icon']=='angle-double-down'){ echo"selected";}?>> <?php _e('angle-double-down','custom-my-account'); ?></option>
															<option value="angle-double-left" <?php if($row['icon']=='angle-double-left'){ echo"selected";}?>> <?php _e('angle-double-left','custom-my-account'); ?></option>
															<option value="angle-double-right" <?php if($row['icon']=='angle-double-right'){ echo"selected";}?>> <?php _e('angle-double-right','custom-my-account'); ?></option>
															<option value="angle-double-up"<?php if($row['icon']=='angle-double-up'){ echo"selected";}?>> <?php _e('angle-double-up','custom-my-account'); ?></option>
															<option value="angle-down"<?php if($row['icon']=='angle-down'){ echo"selected";}?>> <?php _e('angle-down','custom-my-account'); ?></option>
															<option value="angle-left"<?php if($row['icon']=='angle-left'){ echo"selected";}?>> <?php _e('angle-left','custom-my-account'); ?></option>
															<option value="angle-right"<?php if($row['icon']=='angle-right'){ echo"selected";}?>> <?php _e('angle-right','custom-my-account'); ?></option>
															<option value="angle-up"<?php if($row['icon']=='angle-up'){ echo"selected";}?>> <?php _e('angle-up','custom-my-account'); ?></option>
															<option value="apple"<?php if($row['icon']=='apple'){ echo"selected";}?>> <?php _e('apple','custom-my-account'); ?></option>
															<option value="archive"<?php if($row['icon']=='archive'){ echo"selected";}?>> <?php _e('archive','custom-my-account'); ?></option>
															<option value="area-chart"<?php if($row['icon']=='area-chart'){ echo"selected";}?>> <?php _e('area-chart','custom-my-account'); ?></option>
															<option value="arrow-circle-down"<?php if($row['icon']=='arrow-circle-down'){ echo"selected";}?>> <?php _e('arrow-circle-down','custom-my-account'); ?></option>
															<option value="arrow-circle-left"<?php if($row['icon']=='arrow-circle-left'){ echo"selected";}?>> <?php _e('arrow-circle-left','custom-my-account'); ?></option>
															<option value="arrow-circle-o-down"<?php if($row['icon']=='arrow-circle-o-down'){ echo"selected";}?>> <?php _e('arrow-circle-o-down','custom-my-account'); ?></option>
															<option value="arrow-circle-o-left"<?php if($row['icon']=='arrow-circle-o-left'){ echo"selected";}?>> <?php _e('arrow-circle-o-left','custom-my-account'); ?></option>
															<option value="arrow-circle-o-right"<?php if($row['icon']=='arrow-circle-o-right'){ echo"selected";}?>> <?php _e('arrow-circle-o-right','custom-my-account'); ?></option>
															<option value="arrow-circle-o-up"<?php if($row['icon']=='arrow-circle-o-up'){ echo"selected";}?>> <?php _e('arrow-circle-o-up','custom-my-account'); ?></option>
															<option value="arrow-circle-right"<?php if($row['icon']=='arrow-circle-right'){ echo"selected";}?>> <?php _e('arrow-circle-right','custom-my-account'); ?></option>
															<option value="arrow-circle-up"<?php if($row['icon']=='arrow-circle-up'){ echo"selected";}?>> <?php _e('arrow-circle-up','custom-my-account'); ?></option>
															<option value="arrow-down"<?php if($row['icon']=='arrow-down'){ echo"selected";}?>> <?php _e('arrow-down','custom-my-account'); ?></option>
															<option value="arrow-left"<?php if($row['icon']=='arrow-left'){ echo"selected";}?>> <?php _e('arrow-left','custom-my-account'); ?></option>
															<option value="arrow-right"<?php if($row['icon']=='arrow-right'){ echo"selected";}?>> <?php _e('arrow-right','custom-my-account'); ?></option>
															<option value="arrow-up"<?php if($row['icon']=='arrow-up'){ echo"selected";}?>> <?php _e('arrow-up','custom-my-account'); ?></option>
															<option value="arrows"<?php if($row['icon']=='arrows'){ echo"selected";}?>> <?php _e('arrows','custom-my-account'); ?></option>
															<option value="arrows-alt"<?php if($row['icon']=='arrows-alt'){ echo"selected";}?>> <?php _e('arrows-alt','custom-my-account'); ?></option>
															<option value="arrows-h"<?php if($row['icon']=='arrows-h'){ echo"selected";}?>> <?php _e('arrows-h','custom-my-account'); ?></option>
															<option value="arrows-v"<?php if($row['icon']=='arrows-v'){ echo"selected";}?>> <?php _e('arrows-v','custom-my-account'); ?></option>
															<option value="asterisk"<?php if($row['icon']=='asterisk'){ echo"selected";}?>> <?php _e('asterisk','custom-my-account'); ?></option>
															<option value="at"<?php if($row['icon']=='at'){ echo"selected";}?>> <?php _e('at','custom-my-account'); ?></option>
															<option value="car"<?php if($row['icon']=='car'){ echo"selected";}?>> <?php _e('car','custom-my-account'); ?></option>
															<option value="backward"<?php if($row['icon']=='backward'){ echo"selected";}?>> <?php _e('backward','custom-my-account'); ?></option>
															<option value="ban"<?php if($row['icon']=='ban'){ echo"selected";}?>> <?php _e('ban','custom-my-account'); ?></option>
															<option value="university"<?php if($row['icon']=='university'){ echo"selected";}?>> <?php _e('university','custom-my-account'); ?></option>
															<option value="bar-chart-o"<?php if($row['icon']=='bar-chart-o'){ echo"selected";}?>> <?php _e('bar-chart-o','custom-my-account'); ?></option>
															<option value="barcode"<?php if($row['icon']=='barcode'){ echo"selected";}?>> <?php _e('barcode','custom-my-account'); ?></option>
															<option value="reorder"<?php if($row['icon']=='reorder'){ echo"selected";}?>> <?php _e('reorder','custom-my-account'); ?></option>
															<option value="hotel"<?php if($row['icon']=='hotel'){ echo"selected";}?>> <?php _e('hotel','custom-my-account'); ?></option>
															<option value="beer"<?php if($row['icon']=='beer'){ echo"selected";}?>> <?php _e('beer','custom-my-account'); ?></option>
															<option value="behance"<?php if($row['icon']=='behance'){ echo"selected";}?>> <?php _e('behance','custom-my-account'); ?></option>
															<option value="behance-square"<?php if($row['icon']=='behance-square'){ echo"selected";}?>> <?php _e('behance-square','custom-my-account'); ?></option>
															<option value="bell"<?php if($row['icon']=='bell'){ echo"selected";}?>> <?php _e('bell','custom-my-account'); ?></option>
															<option value="bell-o"<?php if($row['icon']=='bell-o'){ echo"selected";}?>> <?php _e('bell-o','custom-my-account'); ?></option>
															<option value="bell-slash"<?php if($row['icon']=='bell-slash'){ echo"selected";}?>> <?php _e('bell-slash','custom-my-account'); ?></option>
															<option value="bell-slash-o"<?php if($row['icon']=='bell-slash-o'){ echo"selected";}?>> <?php _e('bell-slash-o','custom-my-account'); ?></option>
															<option value="bicycle"<?php if($row['icon']=='bicycle'){ echo"selected";}?>> <?php _e('bicycle','custom-my-account'); ?></option>
															<option value="binoculars"<?php if($row['icon']=='binoculars'){ echo"selected";}?>> <?php _e('binoculars','custom-my-account'); ?></option>
															<option value="birthday-cake"<?php if($row['icon']=='birthday-cake'){ echo"selected";}?>> <?php _e('birthday-cake','custom-my-account'); ?></option>
															<option value="bitbucket"<?php if($row['icon']=='bitbucket'){ echo"selected";}?>> <?php _e('bitbucket','custom-my-account'); ?></option>
															<option value="bitbucket-square"<?php if($row['icon']=='bitbucket-square'){ echo"selected";}?>> <?php _e('bitbucket-square','custom-my-account'); ?></option>
															<option value="btc"<?php if($row['icon']=='btc'){ echo"selected";}?>> <?php _e('btc','custom-my-account'); ?></option>
															<option value="bold"<?php if($row['icon']=='bold'){ echo"selected";}?>> <?php _e('bold','custom-my-account'); ?></option>
															<option value="flash"<?php if($row['icon']=='flash'){ echo"selected";}?>> <?php _e('flash','custom-my-account'); ?></option>
															<option value="bomb"<?php if($row['icon']=='bomb'){ echo"selected";}?>> <?php _e('bomb','custom-my-account'); ?></option>
															<option value="book"<?php if($row['icon']=='book'){ echo"selected";}?>> <?php _e('book','custom-my-account'); ?></option>
															<option value="bookmark"<?php if($row['icon']=='bookmark'){ echo"selected";}?>> <?php _e('bookmark','custom-my-account'); ?></option>
															<option value="bookmark-o"<?php if($row['icon']=='bookmark-o'){ echo"selected";}?>> <?php _e('bookmark-o','custom-my-account'); ?></option>
															<option value="briefcase"<?php if($row['icon']=='briefcase'){ echo"selected";}?>> <?php _e('briefcase','custom-my-account'); ?></option>
															<option value="bug"<?php if($row['icon']=='bug'){ echo"selected";}?>> <?php _e('bug','custom-my-account'); ?></option>
															<option value="building"<?php if($row['icon']=='building'){ echo"selected";}?>> <?php _e('building','custom-my-account'); ?></option>
															<option value="building-o"<?php if($row['icon']=='building-o'){ echo"selected";}?>> <?php _e('building-o','custom-my-account'); ?></option>
															<option value="bullhorn"<?php if($row['icon']=='bullhorn'){ echo"selected";}?>> <?php _e('bullhorn','custom-my-account'); ?></option>
															<option value="bullseye"<?php if($row['icon']=='bullseye'){ echo"selected";}?>> <?php _e('bullseye','custom-my-account'); ?></option>
															<option value="bus"<?php if($row['icon']=='bus'){ echo"selected";}?>> <?php _e('bus','custom-my-account'); ?></option>
															<option value="buysellads"<?php if($row['icon']=='buysellads'){ echo"selected";}?>> <?php _e('buysellads','custom-my-account'); ?></option>
															<option value="taxi"<?php if($row['icon']=='taxi'){ echo"selected";}?>> <?php _e('taxi','custom-my-account'); ?></option>
															<option value="calculator"<?php if($row['icon']=='calculator'){ echo"selected";}?>> <?php _e('calculator','custom-my-account'); ?></option>
															<option value="calendar"<?php if($row['icon']=='calendar'){ echo"selected";}?>> <?php _e('calendar','custom-my-account'); ?></option>
															<option value="calendar-o"<?php if($row['icon']=='calendar-o'){ echo"selected";}?>> <?php _e('calendar-o','custom-my-account'); ?></option>
															<option value="camera"<?php if($row['icon']=='camera'){ echo"selected";}?>> <?php _e('camera','custom-my-account'); ?></option>
															<option value="camera-retro"<?php if($row['icon']=='camera-retro'){ echo"selected";}?>> <?php _e('camera-retro','custom-my-account'); ?></option>
															<option value="caret-down"<?php if($row['icon']=='caret-down'){ echo"selected";}?>> <?php _e('caret-down','custom-my-account'); ?></option>
															<option value="caret-left"<?php if($row['icon']=='caret-left'){ echo"selected";}?>> <?php _e('caret-left','custom-my-account'); ?></option>
															<option value="caret-right"<?php if($row['icon']=='caret-right'){ echo"selected";}?>> <?php _e('caret-right','custom-my-account'); ?></option>
															<option value="toggle-down"<?php if($row['icon']=='toggle-down'){ echo"selected";}?>> <?php _e('toggle-down','custom-my-account'); ?></option>
															<option value="toggle-left"<?php if($row['icon']=='toggle-left'){ echo"selected";}?>> <?php _e('toggle-left','custom-my-account'); ?></option>
															<option value="toggle-right"<?php if($row['icon']=='toggle-right'){ echo"selected";}?>> <?php _e('toggle-right','custom-my-account'); ?></option>
															<option value="toggle-up"<?php if($row['icon']=='toggle-up'){ echo"selected";}?>> <?php _e('toggle-up','custom-my-account'); ?></option>
															<option value="caret-up"<?php if($row['icon']=='caret-up'){ echo"selected";}?>> <?php _e('caret-up','custom-my-account'); ?></option>
															<option value="cart-arrow-down"<?php if($row['icon']=='cart-arrow-down'){ echo"selected";}?>> <?php _e('cart-arrow-down','custom-my-account'); ?></option>
															<option value="cart-plus"<?php if($row['icon']=='cart-plus'){ echo"selected";}?>> <?php _e('cart-plus','custom-my-account'); ?></option>
															<option value="cc"<?php if($row['icon']=='cc'){ echo"selected";}?>> <?php _e('cc','custom-my-account'); ?></option>
															<option value="cc-amex"<?php if($row['icon']=='cc-amex'){ echo"selected";}?>> <?php _e('cc-amex','custom-my-account'); ?></option>
															<option value="cc-discover"<?php if($row['icon']=='cc-discover'){ echo"selected";}?>> <?php _e('cc-discover','custom-my-account'); ?></option>
															<option value="cc-mastercard"<?php if($row['icon']=='cc-mastercard'){ echo"selected";}?>> <?php _e('cc-mastercard','custom-my-account'); ?></option>
															<option value="cc-paypal"<?php if($row['icon']=='cc-paypal'){ echo"selected";}?>> <?php _e('cc-paypal','custom-my-account'); ?></option>
															<option value="cc-stripe"<?php if($row['icon']=='cc-stripe'){ echo"selected";}?>> <?php _e('cc-stripe','custom-my-account'); ?></option>
															<option value="cc-visa"<?php if($row['icon']=='cc-visa'){ echo"selected";}?>> <?php _e('cc-visa','custom-my-account'); ?></option>
															<option value="certificate"<?php if($row['icon']=='certificate'){ echo"selected";}?>> <?php _e('certificate','custom-my-account'); ?></option>
															<option value="link"<?php if($row['icon']=='link'){ echo"selected";}?>> <?php _e('link','custom-my-account'); ?></option>
															<option value="unlink"<?php if($row['icon']=='unlink'){ echo"selected";}?>> <?php _e('unlink','custom-my-account'); ?></option>
															<option value="check"<?php if($row['icon']=='check'){ echo"selected";}?>> <?php _e('check','custom-my-account'); ?></option>
															<option value="check-circle"<?php if($row['icon']=='check-circle'){ echo"selected";}?>> <?php _e('check-circle','custom-my-account'); ?></option>
															<option value="check-circle-o"<?php if($row['icon']=='check-circle-o'){ echo"selected";}?>> <?php _e('check-circle-o','custom-my-account'); ?></option>
															<option value="check-square"<?php if($row['icon']=='check-square'){ echo"selected";}?>> <?php _e('check-square','custom-my-account'); ?></option>
															<option value="check-square-o"<?php if($row['icon']=='check-square-o'){ echo"selected";}?>> <?php _e('check-square-o','custom-my-account'); ?></option>
															<option value="chevron-circle-down"<?php if($row['icon']=='chevron-circle-down'){ echo"selected";}?>> <?php _e('chevron-circle-down','custom-my-account'); ?></option>
															<option value="chevron-circle-left"<?php if($row['icon']=='chevron-circle-left'){ echo"selected";}?>> <?php _e('chevron-circle-left','custom-my-account'); ?></option>
															<option value="chevron-circle-right"<?php if($row['icon']=='chevron-circle-right'){ echo"selected";}?>> <?php _e('chevron-circle-right','custom-my-account'); ?></option>
															<option value="chevron-circle-up"<?php if($row['icon']=='chevron-circle-up'){ echo"selected";}?>> <?php _e('chevron-circle-up','custom-my-account'); ?></option>
															<option value="chevron-down"<?php if($row['icon']=='chevron-down'){ echo"selected";}?>> <?php _e('chevron-down','custom-my-account'); ?></option>
															<option value="chevron-left"<?php if($row['icon']=='chevron-left'){ echo"selected";}?>> <?php _e('chevron-left','custom-my-account'); ?></option>
															<option value="chevron-right"<?php if($row['icon']=='chevron-right'){ echo"selected";}?>> <?php _e('chevron-right','custom-my-account'); ?></option>
															<option value="chevron-up"<?php if($row['icon']=='chevron-up'){ echo"selected";}?>> <?php _e('chevron-up','custom-my-account'); ?></option>
															<option value="child"<?php if($row['icon']=='child'){ echo"selected";}?>> <?php _e('child','custom-my-account'); ?></option>
															<option value="circle"<?php if($row['icon']=='circle'){ echo"selected";}?>> <?php _e('circle','custom-my-account'); ?></option>
															<option value="circle-o"<?php if($row['icon']=='circle-o'){ echo"selected";}?>> <?php _e('circle-o','custom-my-account'); ?></option>
															<option value="circle-o-notch"<?php if($row['icon']=='circle-o-notch'){ echo"selected";}?>> <?php _e('circle-o-notch','custom-my-account'); ?></option>
															<option value="genderless"<?php if($row['icon']=='genderless'){ echo"selected";}?>> <?php _e('genderless','custom-my-account'); ?></option>
															<option value="paste"<?php if($row['icon']=='paste'){ echo"selected";}?>> <?php _e('paste','custom-my-account'); ?></option>
															<option value="clock-o"<?php if($row['icon']=='clock-o'){ echo"selected";}?>> <?php _e('clock-o','custom-my-account'); ?></option>
															<option value="times"<?php if($row['icon']=='times'){ echo"selected";}?>> <?php _e('times','custom-my-account'); ?></option>
															<option value="cloud"<?php if($row['icon']=='cloud'){ echo"selected";}?>> <?php _e('cloud','custom-my-account'); ?></option>
															<option value="cloud-download"<?php if($row['icon']=='cloud-download'){ echo"selected";}?>> <?php _e('cloud-download','custom-my-account'); ?></option>
															<option value="cloud-upload"<?php if($row['icon']=='cloud-upload'){ echo"selected";}?>> <?php _e('cloud-upload','custom-my-account'); ?></option>
															<option value="yen"<?php if($row['icon']=='yen'){ echo"selected";}?>> <?php _e('yen','custom-my-account'); ?></option>
															<option value="code"<?php if($row['icon']=='code'){ echo"selected";}?>> <?php _e('code','custom-my-account'); ?></option>
															<option value="code-fork"<?php if($row['icon']=='code-fork'){ echo"selected";}?>> <?php _e('code-fork','custom-my-account'); ?></option>
															<option value="codepen"<?php if($row['icon']=='codepen'){ echo"selected";}?>> <?php _e('codepen','custom-my-account'); ?></option>
															<option value="coffee"<?php if($row['icon']=='coffee'){ echo"selected";}?>> <?php _e('coffee','custom-my-account'); ?></option>
															<option value="gear"<?php if($row['icon']=='gear'){ echo"selected";}?>> <?php _e('gear','custom-my-account'); ?></option>
															<option value="gears"<?php if($row['icon']=='gears'){ echo"selected";}?>> <?php _e('gears','custom-my-account'); ?></option>
															<option value="columns"<?php if($row['icon']=='columns'){ echo"selected";}?>> <?php _e('columns','custom-my-account'); ?></option>
															<option value="comment"<?php if($row['icon']=='comment'){ echo"selected";}?>> <?php _e('comment','custom-my-account'); ?></option>
															<option value="comment-o"<?php if($row['icon']=='comment-o'){ echo"selected";}?>> <?php _e('comment-o','custom-my-account'); ?></option>
															<option value="comments"<?php if($row['icon']=='comments'){ echo"selected";}?>> <?php _e('comments','custom-my-account'); ?></option>
															<option value="comments-o"<?php if($row['icon']=='comments-o'){ echo"selected";}?>> <?php _e('comments-o','custom-my-account'); ?></option>
															<option value="compass"<?php if($row['icon']=='compass'){ echo"selected";}?>> <?php _e('compass','custom-my-account'); ?></option>
															<option value="compress"<?php if($row['icon']=='compress'){ echo"selected";}?>> <?php _e('compress','custom-my-account'); ?></option>
															<option value="connectdevelop"<?php if($row['icon']=='connectdevelop'){ echo"selected";}?>> <?php _e('connectdevelop','custom-my-account'); ?></option>
															<option value="files-o"<?php if($row['icon']=='files-o'){ echo"selected";}?>> <?php _e('files-o','custom-my-account'); ?></option>
															<option value="copyright"<?php if($row['icon']=='copyright'){ echo"selected";}?>> <?php _e('copyright','custom-my-account'); ?></option>
															<option value="credit-card"<?php if($row['icon']=='credit-card'){ echo"selected";}?>> <?php _e('credit-card','custom-my-account'); ?></option>
															<option value="crop"<?php if($row['icon']=='crop'){ echo"selected";}?>> <?php _e('crop','custom-my-account'); ?></option>
															<option value="crosshairs"<?php if($row['icon']=='crosshairs'){ echo"selected";}?>> <?php _e('crosshairs','custom-my-account'); ?></option>
															<option value="css3"<?php if($row['icon']=='css3'){ echo"selected";}?>> <?php _e('css3','custom-my-account'); ?></option>
															<option value="cube"<?php if($row['icon']=='cube'){ echo"selected";}?>> <?php _e('cube','custom-my-account'); ?></option>
															<option value="cubes"<?php if($row['icon']=='cubes'){ echo"selected";}?>> <?php _e('cubes','custom-my-account'); ?></option>
															<option value="scissors"<?php if($row['icon']=='scissors'){ echo"selected";}?>> <?php _e('scissors','custom-my-account'); ?></option>
															<option value="cutlery"<?php if($row['icon']=='cutlery'){ echo"selected";}?>> <?php _e('cutlery','custom-my-account'); ?></option>
															<option value="tachometer"<?php if($row['icon']=='tachometer'){ echo"selected";}?>> <?php _e('tachometer','custom-my-account'); ?></option>
															<option value="dashcube"<?php if($row['icon']=='dashcube'){ echo"selected";}?>> <?php _e('dashcube','custom-my-account'); ?></option>
															<option value="database"<?php if($row['icon']=='database'){ echo"selected";}?>> <?php _e('database','custom-my-account'); ?></option>
															<option value="outdent"<?php if($row['icon']=='outdent'){ echo"selected";}?>> <?php _e('outdent','custom-my-account'); ?></option>
															<option value="delicious"<?php if($row['icon']=='delicious'){ echo"selected";}?>> <?php _e('delicious','custom-my-account'); ?></option>
															<option value="desktop"<?php if($row['icon']=='desktop'){ echo"selected";}?>> <?php _e('desktop','custom-my-account'); ?></option>
															<option value="deviantart"<?php if($row['icon']=='deviantart'){ echo"selected";}?>> <?php _e('deviantart','custom-my-account'); ?></option>
															<option value="diamond"<?php if($row['icon']=='diamond'){ echo"selected";}?>> <?php _e('diamond','custom-my-account'); ?></option>
															<option value="digg"<?php if($row['icon']=='digg'){ echo"selected";}?>> <?php _e('digg','custom-my-account'); ?></option>
															<option value="usd"<?php if($row['icon']=='usd'){ echo"selected";}?>> <?php _e('usd','custom-my-account'); ?></option>
															<option value="dot-circle-o"<?php if($row['icon']=='dot-circle-o'){ echo"selected";}?>> <?php _e('dot-circle-o','custom-my-account'); ?></option>
															<option value="download"<?php if($row['icon']=='download'){ echo"selected";}?>> <?php _e('download','custom-my-account'); ?></option>
															<option value="dribbble"<?php if($row['icon']=='dribbble'){ echo"selected";}?>> <?php _e('dribbble','custom-my-account'); ?></option>
															<option value="dropbox"<?php if($row['icon']=='dropbox'){ echo"selected";}?>> <?php _e('dropbox','custom-my-account'); ?></option>
															<option value="drupal"<?php if($row['icon']=='drupal'){ echo"selected";}?>> <?php _e('drupal','custom-my-account'); ?></option>
															<option value="file-text-o"<?php if($row['icon']=='file-text-o'){ echo"selected";}?>> <?php _e('file-text-o','custom-my-account'); ?></option>
															<option value="heart"<?php if($row['icon']=='heart'){ echo"selected";}?>> <?php _e('heart','custom-my-account'); ?></option>                          						
															<option value="pencil-square-o"<?php if($row['icon']=='pencil-square-o'){ echo"selected";}?>> <?php _e('pencil-square-o','custom-my-account'); ?></option>
															<option value="user-md"<?php if($row['icon']=='user-md'){ echo"selected";}?>> <?php _e('user-md','custom-my-account'); ?></option>
															<option value="user-plus"<?php if($row['icon']=='user-plus'){ echo"selected";}?>> <?php _e('user-plus','custom-my-account'); ?></option>
															<option value="user-secret"<?php if($row['icon']=='user-secret'){ echo"selected";}?>> <?php _e('user-secret','custom-my-account'); ?></option>
															<option value="user-times"<?php if($row['icon']=='user-times'){ echo"selected";}?>> <?php _e('user-times','custom-my-account'); ?></option>
															<option value="venus"<?php if($row['icon']=='venus'){ echo"selected";}?>> <?php _e('venus','custom-my-account'); ?></option>
															<option value="venus-double"<?php if($row['icon']=='venus-double'){ echo"selected";}?>> <?php _e('venus-double','custom-my-account'); ?></option>
															<option value="venus-mars"<?php if($row['icon']=='venus-mars'){ echo"selected";}?>> <?php _e('venus-mars','custom-my-account'); ?></option>
															<option value="viacoin"<?php if($row['icon']=='viacoin'){ echo"selected";}?>> <?php _e('viacoin','custom-my-account'); ?></option>
															<option value="video-camera"<?php if($row['icon']=='video-camera'){ echo"selected";}?>> <?php _e('video-camera','custom-my-account'); ?></option>
															<option value="vimeo-square"<?php if($row['icon']=='vimeo-square'){ echo"selected";}?>> <?php _e('vimeo-square','custom-my-account'); ?></option>
															<option value="vine"<?php if($row['icon']=='vine'){ echo"selected";}?>> <?php _e('vine','custom-my-account'); ?></option>
															<option value="vk"<?php if($row['icon']=='vk'){ echo"selected";}?>> <?php _e('vk','custom-my-account'); ?></option>
															<option value="volume-down"<?php if($row['icon']=='volume-down'){ echo"selected";}?>> <?php _e('volume-down','custom-my-account'); ?></option>
															<option value="volume-off"<?php if($row['icon']=='volume-off'){ echo"selected";}?>> <?php _e('volume-off','custom-my-account'); ?></option>
															<option value="volume-up"<?php if($row['icon']=='volume-up'){ echo"selected";}?>> <?php _e('volume-up','custom-my-account'); ?></option>
															<option value="weixin"<?php if($row['icon']=='weixin'){ echo"selected";}?>> <?php _e('weixin','custom-my-account'); ?></option>
															<option value="weibo"<?php if($row['icon']=='weibo'){ echo"selected";}?>> <?php _e('weibo','custom-my-account'); ?></option>
															<option value="whatsapp"<?php if($row['icon']=='whatsapp'){ echo"selected";}?>> <?php _e('whatsapp','custom-my-account'); ?></option>
															<option value="wheelchair"<?php if($row['icon']=='wheelchair'){ echo"selected";}?>> <?php _e('wheelchair','custom-my-account'); ?></option>
															<option value="wifi"<?php if($row['icon']=='wifi'){ echo"selected";}?>> <?php _e('wifi','custom-my-account'); ?></option>
															<option value="windows"<?php if($row['icon']=='windows'){ echo"selected";}?>> <?php _e('windows','custom-my-account'); ?></option>
															<option value="wordpress"<?php if($row['icon']=='wordpress'){ echo"selected";}?>> <?php _e('wordpress','custom-my-account'); ?></option>
															<option value="wrench"<?php if($row['icon']=='wrench'){ echo"selected";}?>> <?php _e('wrench','custom-my-account'); ?></option>
															<option value="xing"<?php if($row['icon']=='xing'){ echo"selected";}?>> <?php _e('xing','custom-my-account'); ?></option>
															<option value="xing-square"<?php if($row['icon']=='xing-square'){ echo"selected";}?>> <?php _e('xing-square','custom-my-account'); ?></option>
															<option value="yahoo"<?php if($row['icon']=='yahoo'){ echo"selected";}?>> <?php _e('yahoo','custom-my-account'); ?></option>
															<option value="yelp"<?php if($row['icon']=='yelp'){ echo"selected";}?>> <?php _e('yelp','custom-my-account'); ?></option>
															<option value="youtube"<?php if($row['icon']=='youtube'){ echo"selected";}?>> <?php _e('youtube','custom-my-account'); ?></option>
															<option value="youtube-play"<?php if($row['icon']=='youtube-play'){ echo"selected";}?>> <?php _e('youtube-play','custom-my-account'); ?></option>
															<option value="youtube-square"<?php if($row['icon']=='youtube-square'){ echo"selected";}?>> <?php _e('youtube-square','custom-my-account'); ?></option>
														</select>
													
													</td>
												</tr>
												<tr>
													<th><?php _e('User Roles','custom-my-account');?></th>
													<td>
													<select style="width:50%;" name="phoen-endpoint-<?php echo $ep.'[user_role][]'; ?>" multiple="multiple" class="phoen_main_user_role">
													
													<?php 
													$roles = get_editable_roles();
													$usr_roles = array();
													foreach ( $roles as $key => $role ) {
														if( empty( $role['capabilities'] ) ) {
															continue;
														}
														//$usr_roles[ $key ] = $role['name']; ?>
														<option value="<?php echo $key ?>" <?php selected( in_array( $key, (array) $row['user_role'] ), true ); ?>><?php echo $role['name'] ?></option>
													<?php } ?>
													</select>
													</td>
												</tr>
												
												<?php
													/* if($ep=='orders'){
														?>
														<tr>
															<th><?php _e('Edit Content','custom-my-account');?></th>
															<td><input type="text" name="phoen-endpoint-<?php echo $ep.'[edit_content_order]'; ?>" value="<?php echo strtolower($row['edit_content_order']); ?>"></td>
														</tr>
														
													<?php 
													}
													
													if($ep=='downloads'){
														?>
														<tr>
															<th><?php _e('Edit Content','custom-my-account');?></th>
															<td><input type="text" name="phoen-endpoint-<?php echo $ep.'[edit_content_download]'; ?>" value="<?php echo strtolower($row['edit_content_download']); ?>"></td>
														</tr>
													
													
													<?php 
													} */
												if( isset($row['content_type']) && $row['content_type'] == 'custom_url'){
													$custom_url_show = '';
													$custom_content_show = 'none';
												}else{
													$custom_url_show = 'none';
													$custom_content_show = '';
												}
												
												if($ep!='dashboard' && $ep!='downloads' && $ep!='orders' && $ep!='edit-account' && $ep!='edit-address' && $ep!='customer-logout'  || $ep!='support-ticket' ){?>
													
													<tr> 
												
														<th><?php _e('Content Type','custom-my-account');?></th>
														<?php $content_type_val = (isset($row['content_type']) && $row['content_type'] != '')?$row['content_type']:'custom_content'; ?>
														<td>
															<label><?php _e('Custom Url','custom-my-account'); ?></label><input class="phoen-endpoint-content_type" data-key="<?php echo $ep;?>" type="radio" <?php if($content_type_val == 'custom_url') echo"checked"; ?>  value="custom_url" name="phoen-endpoint-<?php echo $ep."[content_type]";?>"/>
															<label><?php _e('Custom Content','custom-my-account'); ?></label><input class="phoen-endpoint-content_type" data-key="<?php echo $ep;?>" type="radio"  <?php if($content_type_val== 'custom_content') echo"checked"; ?>  value="custom_content" name="phoen-endpoint-<?php echo $ep."[content_type]";?>"/>
														</td>
													</tr>
													
															
													<tr class="phoen_custom_url_<?php echo $ep; ?>" style="display:<?php echo $custom_url_show;?>";> 
												
														<th><?php _e('Custom Url','custom-my-account');?></th>
														
														<td><input type="text" value="<?php echo $row['custom_url']; ?>" name="phoen-endpoint-<?php echo $ep."[custom_url]";?>"/><?php _e('Enter full site url.','custom-my-account'); ?></td>
														
													</tr>
												
												<?php
												} 
												
												if($ep!='downloads' && $ep!='orders' && $ep!='edit-account' && $ep!='edit-address' && $ep!='customer-logout' || $ep!='support-ticket'){?>
													
														<tr class="phoen_content_<?php echo $ep; ?>" style="display:<?php echo $custom_content_show;?>;"> 
														
															<th><?php _e('Custom Content','custom-my-account');?></th>
															
															<td><?php $settings = array( 'media_buttons' => false ); $content = $row['content']; $editor_id="phoen-endpoint-".$ep;  $text_area ="phoen-endpoint-".$ep.'[content]'; echo wp_editor( stripcslashes($content), $editor_id, array( 'textarea_name' => $text_area ,'media_buttons' => false));?></td>
														</tr>
													<?php 
													
												} ?>	
												
											</tr> 
										</tbody>
									</table>
								</div>
								<input type="hidden" class="phoen-endpoint-order" name="phoen-endpoint-order" value="<?php echo $ep;?>">
							</li>
						<?php 
						}
						} ?>
						
						<li class="add_endpoint" style="border-style: dashed; height:30px; cursor:pointer; "></li>
					
					</ul>
					
					<input type="hidden" name="endpoints-order" class="endpoints-order" name="endpoints-order" value="<?php echo get_option('phoen-endpoint');?>">
				</td>
			</tr>
			
		</tbody>
	</table>
	<p class="submit">
		<input type="submit" value="<?php _e('Save changes','custom-my-account'); ?>" class="button button-primary" id="submit" name="submit">&nbsp;&nbsp;&nbsp;&nbsp;
		<input type="submit" onclick="return confirm('If you continue with this action, you will reset all options in this page.\nAre you sure?');" value="<?php _e('Reset Defaults','custom-my-account'); ?>" class="button-secondary" name="phoen_reset">
	</p>
</form>
<?php 	
wp_enqueue_style( 'select22','https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.7/css/select2.css' );
wp_enqueue_script( 'select2' );
		?>
<script>
jQuery(document).ready(function(){
	
	
	jQuery('.phoen_main_user_role').select2();
	jQuery('.phoen-endpoint-content_type').click(function(){
		
		var phoebn_ep_key = jQuery(this).data('key');
		
		if((jQuery(this).val()) == 'custom_url'){
			
			jQuery('.phoen_content_'+phoebn_ep_key).hide();
			jQuery('.phoen_custom_url_'+phoebn_ep_key).show();
			
		}else{
			
			jQuery('.phoen_custom_url_'+phoebn_ep_key).hide();
			jQuery('.phoen_content_'+phoebn_ep_key).show();
			
		}
		
	});
	
});

</script>
