<?php 
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	if ( !current_user_can( 'manage_options' ) ){ die(); }
	
	if ( ! empty( $_POST ) && check_admin_referer( 'phoen_custom_my_account_action', 'phoen_custom_my_account_nonce_field' ) ) {
	
		if(isset($_POST['update_settings']))
		{
			
			$check = update_option('myaccount_general_setting', $_POST);
		 
			if($check ==1)
			{
			?>

				<div class="updated" id="message">

					<p><strong><?php _e('Setting updated.','custom-my-account');?></strong></p>

				</div>

			<?php
			}
			else
			{
				?>
					<div class="error below-h2" id="message"><p><?php _e(' Something Went Wrong Please Try Again With Valid Data.','custom-my-account');?></p></div>
				<?php
			}
		}
	
		if(isset($_POST['phoen_reset']))
		{
			$reset = array(
							'phoen_enable_plugin'=>'enable',
							'phoen_das_text'=>'0',
							'menu_text_size'=>'16',
							'icon_text_menu_margin'=>'5',
							'menu_icon_color'=>'',
							'menu_icon_hvr_color'=>'',
							'menu_width_size'=>'30',
							'phoen_first_das_text'=>'0',
							'phoen_recent_text'=>'0',
							'menu_icon_font_size'=>'20',
							'phoen_sec_das_text'=>'0',
							'custom_profile'=>'enable',
							'menu_style'=>'sidebar',					
							'menu_item_color'=>'#777777',
							'menu_item_hover_color'=>'#000000',
							'menu_background_color'=>'#ffffff',
							'menu_background_hover_color_'=>'#ffffff',
							'user_name_color'=>'#c0c0c0',
							'menu_padding_tab_top'=>'10',
							'padding_tab_bottom'=>'10',
							'menu_padding_tab_right'=>'20',
							'menu_padding_tab_left'=>'20',
							'menu_color_active_color'=>'#3333'
							
							
						);
			$check = update_option('myaccount_general_setting', $reset); 
			
			if($check ==1)
			{
			?>

				<div class="updated" id="message">

					<p><strong><?php _e('Setting has been Reset.','custom-my-account');?></strong></p>

				</div>

			<?php
			}  
			else
			{    
				?>
					<div class="error below-h2" id="message"><p><?php _e(' Something Went Wrong Please Try Again With Valid Data.','custom-my-account');?></p></div>
				<?php
			}
		}
		
	}
	$row = get_option('myaccount_general_setting');

?>

<form method="post" action="" class="form-table">
	<?php wp_nonce_field( 'phoen_custom_my_account_action', 'phoen_custom_my_account_nonce_field' ); ?>
	<table class="form-table" style="background:#fff;">
		<tbody>
		<h3><?php _e('General Options','custom-my-account');?></h3>
			<tr>
				<th><?php _e('Enable plugin','custom-my-account');?></th>
				<td><input type="checkbox" value="enable" name="phoen_enable_plugin" <?php if($row['phoen_enable_plugin']=='enable'){echo"checked";}?>></td>
			</tr>
			
			<tr>
				<th><?php _e('Custom Profile','custom-my-account');?></th>
				<td><input type="checkbox" value="enable" name="custom_profile" <?php if($row['custom_profile']=='enable'){echo"checked";}?>><td>
			</tr>
			<tr>
				<th><?php _e('Menu Style','custom-my-account');?></th>
				<td><input type="radio" <?php if($row['menu_style']=='sidebar'){ echo "checked";}?> name="menu_style" value="sidebar"><?php _e('Sidebar','custom-my-account');?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
				<input type="radio" <?php if($row['menu_style']=='tab'){echo "checked";}?> name="menu_style" value="tab"><?php _e('Tab','custom-my-account');?><td>
			</tr>
		</tbody>
	</table>
	
	<table class="form-table" style="background:#fff;">
		<tbody>
		<h3><?php _e('Dashboard Options','custom-my-account');?></h3>
			
			<tr>
				<th><?php _e('Show Custom Text Before OR End','custom-my-account');?></th>
				<td><input type="radio" value="0" name="phoen_das_text" <?php if($row['phoen_das_text']=='0'){echo"checked";}?>><?php _e('Before dashbord default text','custom-my-account');?> <br />
					<input type="radio" value="1" name="phoen_das_text" <?php if($row['phoen_das_text']=='1'){echo"checked";}?>><?php _e('End dashbord default text','custom-my-account');?>
				
				</td>
			</tr>
			
			<tr>
				<th><?php _e('Show/Hide','custom-my-account');?></th>
				<td><input type="radio" value="0" name="phoen_first_das_text" <?php if($row['phoen_first_das_text']=='0'){echo"checked";}?>><?php _e('Show Dashboard Hello Message','custom-my-account');?><br />
					<input type="radio" value="1" name="phoen_first_das_text" <?php if($row['phoen_first_das_text']=='1'){echo"checked";}?>><?php _e('Hide Dashboard Hello Message','custom-my-account');?>
				
				</td>
			</tr>
			<tr>
				<th><?php _e('Show/Hide','custom-my-account');?></th>
				<td><input type="radio" value="0" name="phoen_recent_text" <?php if($row['phoen_recent_text']=='0'){echo"checked";}?>><?php _e('Show Dashboard Recent orders','custom-my-account');?><br />
					<input type="radio" value="1" name="phoen_recent_text" <?php if($row['phoen_recent_text']=='1'){echo"checked";}?>><?php _e('Hide Dashboard Recent orders','custom-my-account');?>
				
				</td>
			</tr>
			<tr>
				<th><?php _e('Show/Hide','custom-my-account');?></th>
				<td><input type="radio" value="0" name="phoen_sec_das_text" <?php if($row['phoen_sec_das_text']=='0'){echo"checked";}?>><?php _e('Show recent order,billing and shipping address,edit your account details','custom-my-account');?><br />
					<input type="radio" value="1" name="phoen_sec_das_text" <?php if($row['phoen_sec_das_text']=='1'){echo"checked";}?>><?php _e('Hide recent order,billing and shipping address,edit your account details','custom-my-account');?>
				
				</td>
			</tr>
			
		</tbody>
	</table>
	
	<table class="form-table" style="background:#fff;">
		<tbody>
		<h3><?php _e('Style Options','custom-my-account');?></h3>
			<tr>
				<th><?php _e('Menu item text size in px','custom-my-account');?></th>
				<td><input type="number" value="<?php echo $row['menu_text_size'];?>" name="menu_text_size" id="menu_text_size" ><td>
			</tr>
			
			<tr>
			
				<th><?php _e(' Menu text font weight','custom-my-account');?></th>
				<td>
				
					<select name="phoen_tab_weight" id="phoen_tab_weight">
					
						<option value="normal" <?php if(isset($row['phoen_tab_weight']) && $row['phoen_tab_weight'] == 'normal') echo"selected"; ?> ><?php _e('Normal','custom-my-account'); ?></option>
						<option value="lighter" <?php if(isset($row['phoen_tab_weight']) && $row['phoen_tab_weight'] == 'lighter') echo"selected"; ?> ><?php _e('Lighter','custom-my-account'); ?></option>	
						<option value="bold" <?php if(isset($row['phoen_tab_weight']) && $row['phoen_tab_weight'] == 'bold') echo"selected"; ?> ><?php _e('Bold','custom-my-account'); ?></option>
						
					</select>
					
				</td>
				
			</tr>
			
			<tr>
				<th><?php _e('Menu item width size in %','custom-my-account');?></th>
				<td><input type="number" value="<?php echo $row['menu_width_size'];?>" name="menu_width_size" id="menu_width_size" ><label><?php _e('sidebar menu style.','custom-my-account'); ?> </label><td>
			</tr>
			
			<tr>
				<th><?php _e('Menu item icon font size ','custom-my-account');?></th>
				<td><input type="number" min="10" value="<?php echo $row['menu_icon_font_size'];?>" name="menu_icon_font_size" id="menu_icon_font_size" ><label><?php _e('sidebar menu Icon size. ','custom-my-account'); ?></label><td>
			</tr>
			<tr>
				<th><?php _e('Margin between icon and text','custom-my-account');?></th>
				<td><input type="number" value="<?php echo $row['icon_text_menu_margin'];?>" name="icon_text_menu_margin" id="icon_text_menu_margin" ><td>
			</tr>
			
			<tr>
				<th><?php _e('Padding between Menu','custom-my-account');?></th>
				<td><input type="number" value="<?php echo $row['menu_padding_tab_top'];?>" name="menu_padding_tab_top" id="menu_padding_tab_top" placeholder="<?php _e('	','custom-my-account');?>" >
				<input type="number" value="<?php echo $row['menu_padding_tab_right'];?>" name="menu_padding_tab_right" id="menu_padding_tab_right" placeholder="<?php _e('Right','custom-my-account');?>">
				<input type="number" value="<?php echo $row['menu_padding_tab_bottom'];?>" name="menu_padding_tab_bottom" id="menu_padding_tab_bottom" placeholder="<?php _e('Bottom','custom-my-account');?>">
				<input type="number" value="<?php echo $row['menu_padding_tab_left'];?>" name="menu_padding_tab_left" id="menu_padding_tab_left" placeholder="<?php _e('Left','custom-my-account');?>">
				<td>
			</tr>
			
			<tr>
				<th><?php _e('Menu Active Color','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['menu_color_active_color'];?>" name="menu_color_active_color" id="menu_color_active_color" class="phoen_wp_color_picker"><td>
			</tr>
			
			
			
			<tr>
				<th><?php _e('Menu Icon Color','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['menu_icon_color'];?>" name="menu_icon_color" id="menu_icon_color" class="phoen_wp_color_picker"><td>
			</tr>
			
			<tr>
				<th><?php _e('Menu Icon Hover Color','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['menu_icon_hvr_color'];?>" name="menu_icon_hvr_color" id="menu_icon_hvr_color" class="phoen_wp_color_picker"><td>
			</tr>
			<tr>
				<th><?php _e('User Name Color','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['user_name_color'];?>" name="user_name_color" id="user_name_color" class="phoen_wp_color_picker"><td>
			</tr>
			
			<tr>
				<th><?php _e('Menu item color','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['menu_item_color'];?>" name="menu_item_color" id="menu_item_color" class="phoen_wp_color_picker"><td>
			</tr>
			<tr>
				<th><?php _e('Menu item color on hover','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['menu_item_hover_color'];?>" name="menu_item_hover_color" id="menu_item_hover_color" class="phoen_wp_color_picker">
				
			</tr>
			<tr>
				<th><?php _e('Menu item Background color','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['menu_background_color'];?>" name="menu_background_color" id="menu_background_color" class="phoen_wp_color_picker"><td>
			</tr>
			<tr>
				<th><?php _e('Menu item Background color on hover','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['menu_background_hover_color'];?>" name="menu_background_hover_color" id="menu_background_hover_color" class="phoen_wp_color_picker"><td>
			</tr>
			
			<tr>
				<th><?php _e('Menu item Text active color','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['menu_text_active_color'];?>" name="menu_text_active_color" id="menu_text_active_color" class="phoen_wp_color_picker"><td>
			</tr>
			
			<tr>
				<th><?php _e('Menu item active Background color','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['menu_background_active_color'];?>" name="menu_background_active_color" id="menu_background_active_color" class="phoen_wp_color_picker"><td>
			</tr>
			
			<tr>
				<th><?php _e('Menu Border ','custom-my-account');?></th>
				<td>
					<input type="number" value="<?php echo $row['menu_border_top'];?>" name="menu_border_top" id="menu_border_top" placeholder="<?php _e('Top','custom-my-account');?>">
					<input type="number" value="<?php echo $row['menu_border_right'];?>" name="menu_border_right" id="menu_border_right" placeholder="<?php _e('Right','custom-my-account');?>">
					<input type="number" value="<?php echo $row['menu_border_bottom'];?>" name="menu_border_bottom" id="menu_border_bottom" placeholder="<?php _e('Bottom','custom-my-account');?>">
					<input type="number" value="<?php echo $row['menu_border_left'];?>" name="menu_border_left" id="menu_border_left" placeholder="<?php _e('Left','custom-my-account');?>">
				</td>
			</tr>
			
			<tr>
				<th><?php _e('Menu Border Style ','custom-my-account');?></th>
				<td>
				<select name="phoen_menu_border_style">
					<option value="none" <?php if(isset($row['phoen_menu_border_style']) && $row['phoen_menu_border_style'] == 'none') echo"selected"; ?>><?php _e('None','custom-my-account');?></option>
					<option value="solid" <?php if(isset($row['phoen_menu_border_style']) && $row['phoen_menu_border_style'] == 'solid') echo"selected"; ?>><?php _e('Solid','custom-my-account');?></option>
					<option value="dotted" <?php if(isset($row['phoen_menu_border_style'])&& $row['phoen_menu_border_style'] == 'dotted') echo"selected"; ?>><?php _e('Dotted','custom-my-account');?></option>
					<option value="double" <?php if(isset($row['phoen_menu_border_style']) && $row['phoen_menu_border_style'] == 'double') echo"selected"; ?>><?php _e('Double','custom-my-account');?></option>
					<option value="dashed" <?php if(isset($row['phoen_menu_border_style']) && $row['phoen_menu_border_style'] == 'dashed') echo"selected"; ?>><?php _e('Dashed','custom-my-account');?></option>
				</select>
				</td>
			</tr>
			
			<tr>
				<th><?php _e('Menu Border color','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['menu_border_color'];?>" name="menu_border_color" id="menu_border_color" class="phoen_wp_color_picker"><td>
			</tr>
			
			<tr>
				<th><?php _e('Menu Border Radius ','custom-my-account');?></th>
				<td><input type="number"  value="<?php echo $row['menu_border_radius'];?>" name="menu_border_radius" id="menu_border_radius" ></td>
			</tr>
			
			<tr>
				<th><?php _e('Profile Name Color','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['profile_color'];?>" name="profile_color" id="profile_color" class="phoen_wp_color_picker"><td>
			</tr>
			
			<tr>
				<th><?php _e('Profile Font Size','custom-my-account');?></th>
				<td><input type="number" value="<?php echo $row['profile_font_size'];?>" name="profile_font_size" id="profile_font_size" ><td>
			</tr>
			
			<tr>
				<th><?php _e('Profile Font Weight','custom-my-account');?></th>
				<td>
				
					<select name="phoen_profile_weight" id="phoen_profile_weight">
					
						<option value="normal"  <?php if(isset($row['phoen_profile_weight']) && $row['phoen_profile_weight'] == 'normal') echo"selected"; ?>><?php _e('Normal','custom-my-account'); ?></option>
						<option value="lighter" <?php if(isset($row['phoen_profile_weight']) && $row['phoen_profile_weight'] == 'lighter') echo"selected"; ?>><?php _e('Lighter','custom-my-account'); ?></option>	
						<option value="bold" <?php if(isset($row['phoen_profile_weight']) && $row['phoen_profile_weight'] == 'bold') echo"selected"; ?>><?php _e('Bold','custom-my-account'); ?></option>
						
					</select>
					
				</td>
			</tr>
			
			<tr>
				<th><?php _e('Profile Text Transform','custom-my-account');?></th>
				<td>
				
					<select name="phoen_profile_transform" id="phoen_profile_transform">
					
						<option value="normal"  <?php if(isset($row['phoen_profile_transform']) &&  $row['phoen_profile_transform']== 'normal') echo"selected"; ?> ><?php _e('Normal','custom-my-account'); ?></option>
						<option value="uppercase" <?php if(isset($row['phoen_profile_transform']) && $row['phoen_profile_transform'] == 'uppercase') echo"selected"; ?>><?php _e('Uppercase','custom-my-account'); ?></option>
						<option value="lowercase"  <?php if(isset($row['phoen_profile_transform']) && $row['phoen_profile_transform'] == 'lowercase') echo"selected"; ?> ><?php _e('Lowercase','custom-my-account'); ?></option>	
						<option value="capitalize"  <?php if(isset($row['phoen_profile_transform']) && $row['phoen_profile_transform']	 == 'capitalize') echo"selected"; ?>><?php _e('Capitalize','custom-my-account'); ?></option>
						
					</select>
					
				</td>
			</tr>
			
			<tr>
				<th><?php _e('Margin Profile Text','custom-my-account');?></th>
				<td><input type="number" value="<?php echo $row['profile_margin_text_top'];?>" name="profile_margin_text_top" id="profile_margin_text_top" placeholder="<?php _e('Top','custom-my-account'); ?>" >
				<input type="number" value="<?php echo $row['profile_margin_text_right'];?>" name="profile_margin_text_right" id="profile_margin_text_right" placeholder="<?php _e('Right','custom-my-account'); ?>">
				<input type="number" value="<?php echo $row['profile_margin_text_bottom'];?>" name="profile_margin_text_bottom" id="profile_margin_text_bottom" placeholder="<?php _e('Bottom','custom-my-account'); ?>">
				<input type="number" value="<?php echo $row['profile_margin_text_left'];?>" name="profile_margin_text_left" id="profile_margin_text_left" placeholder="<?php _e('Left','custom-my-account'); ?>">
				<td>
			</tr>
			
			<tr>
				<th><?php _e('Profile Images Border','custom-my-account');?></th>
				<td><input type="number" value="<?php echo $row['profile_border'];?>" name="profile_border" id="profile_border" ><td>
			</tr>
			
			<tr>
				<th><?php _e('Profile Images Border Style','custom-my-account');?></th>
				<td>
				
					<select name="profile_border_style_images" id="profile_border_style_images">
					
						<option value="none"  <?php if(isset($row['profile_border_style_images']) && $row['profile_border_style_images'] == 'none') echo"selected"; ?>><?php _e('None','custom-my-account'); ?></option>
						<option value="solid"  <?php if(isset($row['profile_border_style_images']) && $row['profile_border_style_images'] == 'solid') echo"selected"; ?>><?php _e('Solid','custom-my-account'); ?></option>
						<option value="dotted"  <?php if(isset($row['profile_border_style_images']) && $row['profile_border_style_images'] == 'dotted') echo"selected"; ?>><?php _e('Dotted','custom-my-account'); ?></option>
						<option value="dashed" <?php if(isset($row['profile_border_style_images']) && $row['profile_border_style_images'] == 'dashed') echo"selected"; ?>><?php _e('Dashed','custom-my-account'); ?></option>	
						
					</select>
				</td>
				
			</tr>
			
			<tr>
				<th><?php _e('Profile images border color','custom-my-account');?></th>
				<td><input type="text" value="<?php echo $row['profile_border_color'];?>" name="profile_border_color" id="profile_border_color" class="phoen_wp_color_picker"><td>
			</tr>
			
			<tr>
				<th><?php _e('Padding Profile image','custom-my-account');?></th>
				<td><input type="number" value="<?php echo $row['profile_padding_image'];?>" name="profile_padding_image" id="profile_padding_image"></td>
				
			</tr>	
			
			<tr>
				<th><?php _e('Profile image style','custom-my-account');?></th>
				
				<td>
					<?php _e('Round:','custom-my-account'); ?><input type="radio" name="profile_padding_image_st_view" value="50" <?php if(isset($row['profile_padding_image_st_view'])&& $row['profile_padding_image_st_view'] == '50') echo"checked"; ?>>
					<?php _e('Square','custom-my-account'); ?><input type="radio" name="profile_padding_image_st_view" value="0" <?php if(isset($row['profile_padding_image_st_view']) && $row['profile_padding_image_st_view'] == '0') echo"checked"; ?>> 
				</td>
				
			</tr>	
				
		</tbody>
	</table>
	<p class="submit"><input type="submit" value="<?php _e('Save changes','custom-my-account'); ?>" class="button button-primary" id="submit" name="update_settings">&nbsp;&nbsp;&nbsp;&nbsp;<input type="submit" onclick="return confirm('If you continue with this action, you will reset all options in this page.\nAre you sure?');" value="<?php _e('Reset Defaults','custom-my-account'); ?>" class="button-secondary" name="phoen_reset">
</p>
</form>