<?php 
/**
Plugin Name: Custom My Account for Woocommerce Premium
Plugin URI: http://www.phoeniixx.com
Description: Woocommerce custom my account template plugin by phoeniixx designs
Author: phoeniixx
Version: 2.0.7
Text Domain:custom-my-account
Domain Path: /languages
Author URI: http://www.phoeniixx.com
WC requires at least: 2.6.0
WC tested up to: 4.1.0
**/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	include(dirname(__FILE__).'/myaccount_settings.php');
	define('PHOENCMAFWPUGINURL',plugin_dir_url(__FILE__));
	add_action( 'init', 'init' );

	function init(){
		
		!defined( 'PHOEN_CUSTOM_TEMPLATE_PATH' )   && define( 'PHOEN_CUSTOM_TEMPLATE_PATH', plugin_dir_path( __FILE__ ) . 'woocommerce/' );
		
		add_filter( 'woocommerce_locate_template', 'phoen_custom_my_account_template', 10, 3 );
		
		add_filter( 'pcmac_woocommerce_custom_my_account', 'do_shortcode' );
	} 
	
	function phoen_custom_my_account_template( $template, $template_name, $template_path ){
		
		if('myaccount/navigation.php' == $template_name ){
			
			$template = PHOEN_CUSTOM_TEMPLATE_PATH . 'myaccount/navigation.php';
		
		}
		if('myaccount/dashboard.php' == $template_name ){
			
			$template = PHOEN_CUSTOM_TEMPLATE_PATH . 'myaccount/dashboard.php';
			
		}
		return $template;
	} 

	add_action('admin_enqueue_scripts','phoen_my_account');
	
	//ajax add endpoint
	add_action( 'wp_ajax_nopriv_phoen_myaccount_check', 'phoen_myaccount_check' );
	add_action( 'wp_ajax_phoen_myaccount_check', 'phoen_myaccount_check' );
	//ajax remove endpoint
	add_action( 'wp_ajax_nopriv_phoen_remove_endpoint', 'phoen_remove_endpoint' );
	add_action( 'wp_ajax_phoen_remove_endpoint', 'phoen_remove_endpoint' );

	function phoen_my_account(){
		
		wp_enqueue_style( 'font-awesome', plugin_dir_url(__FILE__).'/assets/css/font-awesome.min.css');
		
		wp_enqueue_style( 'phoen-wcmap3',  plugin_dir_url(__FILE__).'/assets/css/phoen-wcmap.css');
				
		wp_enqueue_script( 'script_myaccount_request', plugin_dir_url( __FILE__ ).'/assets/js/my_account.js', array( 'jquery' ));
		
		wp_localize_script( 'script_myaccount_request', 'phoen_myaccount_Ajax', array( 'ajax_url' => admin_url( 'admin-ajax.php' )) );
		
		wp_enqueue_style( 'font-awesome' );
		
		wp_enqueue_style( 'wp-color-picker');
		
		wp_enqueue_script( 'wp-color-picker');
		
		?>
			<script>
				
				var plugin_url= '<?php echo plugin_dir_url(__FILE__);?>';
			
			</script>
			
		<?php	 
	}
	
	add_action( 'wp_ajax_phoen_wp_handle_upload', 'phoen_wp_handle_upload');
	add_action( 'wp_ajax_nopriv_phoen_wp_handle_upload' ,'phoen_wp_handle_upload');

	function phoen_wcmap_add_scripts() {
		
		wp_enqueue_script( 'script_myaccount_front_request', plugin_dir_url( __FILE__ ).'/assets/js/my_account_font.js', array( 'jquery' ));
		
		wp_enqueue_style( 'phoen-wcmap',  plugins_url('assets/css/phoen-wcmap.css', __FILE__) );
		
		wp_enqueue_style( 'font-awesome', plugin_dir_url(__FILE__).'/assets/css/font-awesome.min.css');
		
		wp_enqueue_script('media-upload');
		
		wp_enqueue_style('thickbox');
		
		wp_enqueue_script('thickbox');
		
		wp_localize_script( 'script_myaccount_front_request', 'phoen_myaccount_Ajax', array( 'ajax_url' => admin_url( 'admin-ajax.php' )) );
		
		?>
		<div class="pho-myaccount-popup-body" style="display:none;">

			<div class="pho-modal-box-backdrop"></div>

			<div class="pho-popup-myaccount">
			
				<div class="pho-close_btn"> &#10005; </div>
				
				<h3><?php _e('Upload Your Profile','custom-my-account');?></h3>
				
				<form method="post" enctype="multipart/form-data">
					
					<p>
					<label class="phoen_account_label"></label>
					<input type="file" name="profile" id="profile">
					
					</p>
					
					<p><input type="submit" name="submit" value="Upload"></p>
					
					<input type="hidden" name="action" value="phoen_wp_handle_upload">
					
					<input type="hidden" name="_nonce" value="<?php echo wp_create_nonce('wp_handle_upload') ?>">
				
				</form>
			
			</div> <!-- popup class end -->

		</div> <!-- pho-popup-body class end -->
		<?php
		
	}

	add_action( 'init', 'phoen_wp_handle_upload');

	function phoen_wp_handle_upload()
	{
		if( ! isset( $_FILES['profile'] ) || ! wp_verify_nonce( $_POST['_nonce'], 'wp_handle_upload' ) )
			
			return;
				
			if ( ! function_exists( 'media_handle_upload' )  ) {
				
				require_once( ABSPATH . 'wp-admin/includes/file.php' );
				
				require_once( ABSPATH . 'wp-admin/includes/image.php' );
				
				require_once( ABSPATH . 'wp-admin/includes/media.php' );
			}

			$media_id = media_handle_upload( 'profile', 0 );

			if( is_wp_error( $media_id ) ) {
				
				return;
			
			}

			// save media id for filter query in media library
			$medias = get_option('phoen-wcmap-users-avatar-ids', array() );
			
			$medias[] = $media_id;
			// then save
			update_option( 'phoen-wcmap-users-avatar-ids', $medias );

			// save user meta
			$user = get_current_user_id();
			
			update_user_meta( $user, 'phoen-wcmap-avatar', $media_id );	
	}

	add_filter( 'pcmac_woocommerce_custom_my_account', 'do_shortcode' );

	add_action( 'wp_enqueue_scripts', 'phoen_wcmap_add_scripts' );

	function phoen_myaccount_check()
	{
		$title =  $_POST['title'];
		
		$data = get_option('phoen-endpoint');
		
		$endpoint = explode(',',$data);
		
		foreach($endpoint as $p)
		{
			if($p==$title)
			{

				echo 1;
				
				break;
			}
			else
			{
				echo 0;
			}
		}

		die;
	}

	function phoen_remove_endpoint()
	{
		$all_point = array();
		
		$endpoint = $_POST['endpoint'];
		
		$all_point = explode(',', get_option('phoen-endpoint'));

		$value = array_search($endpoint, $all_point);
		
		unset($all_point[$value]);
		
		$data = implode(',', $all_point);
		
		update_option('phoen-endpoint', $data);
		
		die;
	
	}


	register_activation_hook( __FILE__, 'phoen_wc_myaccount_registration' );

	function phoen_wc_myaccount_registration()
	{
		$arg ='dashboard,downloads,orders,edit-account,edit-address,customer-logout,support-ticket';
		
		$dashbord =array(
			'active'=>'1',
			'label'=>'Dashboard',
			'icon'=>'tachometer',
			'content'=>'',
			'type'=>'pre'
		); 
		
		$my_downloads =array(
			'active'=>'1',
			'slug'=>'downloads',
			'label'=>'My Downloads',
			'icon'=>'download',
			'content'=>'[my_downloads_content]',
			'type'=>'pre',
			'edit_content_download'=>'No downloads available yet.'
		); 
		
		$view_orders =array(
			'active'=>'1',
			'slug'=>'orders',
			'label'=>'My Orders',
			'icon'=>'file-text-o',
			'content'=>'[view_order_content]',
			'type'=>'pre',
			'edit_content_order'=>'No order has been made yet.'
		); 
		
		$edit_account =array(
			'active'=>'1',
			'slug'=>'edit-account',
			'label'=>'Edit Account',
			'icon'=>'pencil-square-o',
			'content'=>'',
			'type'=>'pre'
		); 
		
		$edit_address =array(
			'active'=>'1',
			'slug'=>'edit-address',
			'label'=>'Edit Address',
			'icon'=>'pencil-square-o',
			'content'=>'',
			'type'=>'pre'
		); 
		
		$log_out =array(
			'active'=>'1',
			'slug'=>'customer-logout',
			'label'=>'Logout',
			'icon'=>'pencil-square-o',
			'type'=>'pre'
			
		); 
		
		$general_setting = array(
									'phoen_enable_plugin'=>'enable',
									'custom_profile'=>'enable',
									'menu_text_size'=>'16',
									'menu_width_size'=>'30',
									'menu_icon_font_size'=>'20',
									'phoen_das_text'=>'0',
									'phoen_first_das_text'=>'0',
									'phoen_recent_text'=>'0',
									'phoen_sec_das_text'=>'0',
									'menu_style'=>'sidebar',					
									'menu_style'=>'sidebar',					
									'menu_item_color'=>'#777777',
									'menu_item_hover_color'=>'#000000',
									'menu_background_color'=>'#ffffff',
									'menu_background_hover_color_'=>'#ffffff',
									'user_name_color'=>'#c0c0c0',
									'icon_text_menu_margin'=>'5',
									'menu_icon_color'=>'',
									'menu_icon_hvr_color'=>'',
						
								);
		
		if(!get_option('phoen-endpoint'))
		{
			update_option('myaccount_general_setting', $general_setting);
			
			update_option('phoen-endpoint', $arg);
			
			update_option('phoen-endpoint-dashboard', $dashbord);
			
			update_option('phoen-endpoint-downloads', $my_downloads);
			
			//update_option('phoen-endpoint-payment-methods', $payment_methods);
			
			update_option('phoen-endpoint-orders', $view_orders);
			
			update_option('phoen-endpoint-edit-account', $edit_account);
			
			update_option('phoen-endpoint-edit-address', $edit_address);
			
			update_option('phoen-endpoint-customer-logout', $log_out);
		}
		
	}
	
	if ( in_array( 'support-ticket-system-by-phoeniixx/phoen_ticket_system.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
			
		$support_ticket =array(
			'active'=>'1',
			'slug'=>'support-ticket',
			'label'=>'Support Ticket',
			'icon'=>'pencil-square-o',
			'content'=>'',
			'type'=>'pre'
			
		); 
			$phoen_data = get_option('phoen-endpoint-support-ticket');
			if(empty($phoen_data))
			{
					update_option('phoen-endpoint-support-ticket', $support_ticket);
			}
	
	}else{
		
		update_option('phoen-endpoint-support-ticket', '');
	}	
	

	add_filter( 'get_avatar', 'phoen_get_avatar',1,10);

	function phoen_get_avatar($avatar, $user, $size, $default, $alt, $args ) {
		//echo $size;
		//$current_user = wp_get_current_user();
		$user_info = get_userdata($user);
		// get custom avatar
		$custom_avatar = get_user_meta( $user, 'phoen-wcmap-avatar', true );

		if( ! $custom_avatar ){
			
			//$avatars = get_avatar_url($user_info->user_email,$size);
			
			
			/* if($avatars)
			{
				$avatar = sprintf("<img alt='' src='".$avatars."'>");
			}
			else
			{  */
				$url = plugin_dir_url(__FILE__).'/assets/images/default_avatar.png';
				
				$avatar = sprintf("<img height='".$size."px' width='".$size."px' alt='' src='".$url."'>");
			/* } */ 
			
			return $avatar;
		}else{
			// maybe resize img
			$resized = phoen_wcmap_resize_avatar_url( $custom_avatar, $size );
			// if error occurred return
			if( ! $resized ) {
				return $avatar;
			}

			$src = phoen_wcmap_generate_avatar_url( $custom_avatar, $size );
			
			$class = array( 'avatar', 'avatar-' . (int) 120, 'photo' );
			
			$avatar = sprintf(
								"<img  src='%s' class='%s' />",
								esc_url( $src ),
								esc_attr( join( ' ', $class ) )
							); 
							
			return $avatar;
		}

		
			 
	}
		
	/*#####################################
	 AVATAR FUNCTION
	#####################################*/

	if( ! function_exists( 'phoen_wcmap_generate_avatar_path' ) ){
		/**
		 * Generate avatar path
		 *
		 * @param $attachment_id
		 * @param $size
		 * @return string
		 */
		function  phoen_wcmap_generate_avatar_path( $attachment_id, $size ) {
			// Retrieves attached file path based on attachment ID.
			$filename = get_attached_file( $attachment_id );

			$pathinfo  = pathinfo( $filename );
			$dirname   = $pathinfo['dirname'];
			$extension = $pathinfo['extension'];

			// i18n friendly version of basename().
			$basename = wp_basename( $filename, '.' . $extension );

			$suffix    = $size . 'x' . $size;
			$dest_path = $dirname . '/' . $basename . '-' . $suffix . '.' . $extension;

			return $dest_path;
		}
	}

	if( ! function_exists( 'phoen_wcmap_generate_avatar_url' ) ) {
		/**
		 * Generate avatar url
		 *
		 * @param $attachment_id
		 * @param $size
		 * @return mixed
		 */
		function phoen_wcmap_generate_avatar_url( $attachment_id, $size ) {
			// Retrieves path information on the currently configured uploads directory.
			
			$upload_dir = wp_upload_dir();

			// Generates a file path of an avatar image based on attachment ID and size.
			$path = phoen_wcmap_generate_avatar_path( $attachment_id, $size );

			return str_replace( $upload_dir['basedir'], $upload_dir['baseurl'], $path );
		}
	}

	if( ! function_exists( 'phoen_wcmap_resize_avatar_url' ) ) {
		/**
		 * Resize avatar
		 *
		 * @param $attachment_id
		 * @param $size
		 * @return boolean
		 */
		function phoen_wcmap_resize_avatar_url( $attachment_id, $size ){
		
			$dest_path = phoen_wcmap_generate_avatar_path( $attachment_id, $size );
			
			//echo $dest_path."sadhfjkhaskdfhkjasdhfjkhsdjkf";

			if ( file_exists( $dest_path ) ) {
				$resize = true;
			} else {
				// Retrieves attached file path based on attachment ID.
				$path = get_attached_file( $attachment_id );

				// Retrieves a WP_Image_Editor instance and loads a file into it.
				$image = wp_get_image_editor( $path );

				if ( ! is_wp_error( $image ) ) {

					// Resizes current image.
					$image->resize( $size, $size, true );

					// Saves current image to file.
					$image->save( $dest_path );

					$resize = true;

				}
				else {
					$resize = false;
				}
			}

			return $resize;
		}
}
	
	add_action('wp_head','my_account_dynamic_css');
		
	function my_account_dynamic_css()
	{
		$row = get_option('myaccount_general_setting');
		$menu_color_active_color = (isset($row['menu_color_active_color']) && $row['menu_color_active_color'] != '')?$row['menu_color_active_color']:'#3333';
		
		$profile_border = (isset($row['profile_border']) && $row['profile_border'] != '')?$row['profile_border']:'1';
		$profile_border_style_images = (isset($row['profile_border_style_images']) && $row['profile_border_style_images'] != '')?$row['profile_border_style_images']:'solid';
		$profile_border_color = (isset($row['profile_border_color']) && $row['profile_border_color'] != '')?$row['profile_border_color']:'#ccc';
		
		$profile_padding_image = (isset($row['profile_padding_image']) && $row['profile_padding_image'] != '')?$row['profile_padding_image']:'5';
		
		$profile_padding_image_st_view = (isset($row['profile_padding_image_st_view']) && $row['profile_padding_image_st_view'] != '')?$row['profile_padding_image_st_view']:'50';
	?>
	
	<style>	
		
		.phoen_custom_account ul li a {
			color: <?php echo $row['menu_item_color'].'!important';?>;
			background-color: <?php echo $row['menu_background_color'].'!important';?>;
		}
	
		.phoen_custom_account ul li a:hover {
			color:<?php echo $row['menu_item_hover_color'].'!important';?>;
			background-color: <?php echo $row['menu_background_hover_color'].'!important';?>;
		}

		.pho-user-info .pho-username {
			margin-top: 10px;
			color: <?php echo $row['user_name_color'].'!important';?>;
		}
		
		.woocommerce .phoen_custom_account ul li.is-active a {
			box-shadow: 4px 0 0 0 <?php echo $menu_color_active_color ; ?> inset;
		}

		.pho-user-image img {
			border: <?php echo $profile_border ; ?>px <?php echo $profile_border_style_images ;?> <?php echo $profile_border_color ;?> ;
			border-radius: <?php echo $profile_padding_image_st_view ;?>%;
			padding: <?php echo $profile_padding_image ;?>px;
		}
		
		
		.pho-user-info .pho-username {
			text-align: center;
		}
		
		.phoen_account_label {
			border: 2px dashed #ccc;
			bottom: 0;
			cursor: pointer;
			height: 100%;
			left: 0;
			min-height: 150px;
			position: absolute;
			top: 0;
			width: 100%;
			z-index: 0;
			line-height: 1;
		}
		
		.pho-popup-myaccount input[type="file"] {
			min-height: 150px;
			z-index: 999;
			opacity: 0;
			cursor: pointer;
	}
	
	.pho-popup-myaccount form p {
		position: relative;
		margin-bottom: 15px;
	}
	
	.pho-popup-myaccount {
		height: 320px;
	}
	
		.phoen_account_label::after {
			color: #ccc;
			content: "\f0ee";
			font-family: fontawesome;
			font-size: 50px;
			left: 50%;
			position: absolute;
			top: 25px;
			transform: translateX(-50%);
			-webkit-transform: translateX(-50%);
			-moz-transform: translateX(-50%);
		}
		
		.phoen_account_label::before {
			color: #555;
			content: "Browse";
			font-weight: 600;
			left: 50%;
			position: absolute;
			text-transform: uppercase;
			top: 85px;
			transform: translateX(-50%);
			-webkit-transform: translateX(-50%);
			-moz-transform: translateX(-50%);
		}
		
		.pho-popup-myaccount h3 {
			font-size: 17px;
			margin-bottom: 30px;
			margin-top: 20px;
			text-transform: uppercase;
			padding: 0;
			}
			
			.pho-popup-myaccount {
				padding: 3px 40px;
			}
		
	
	</style>
 	
	<?php
	}
