<?php
/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 *
*/
if ( ! defined( 'ABSPATH' ) ) {   
	exit;
}

global $woocommerce;

do_action( 'woocommerce_before_account_navigation' );

$data = get_option('phoen-endpoint');

$endpoint = explode(',',$data);

$row = get_option('myaccount_general_setting');

if(isset($row['phoen_enable_plugin']) && $row['phoen_enable_plugin'] == 'enable'){

?>
	<nav class="woocommerce-MyAccount-navigation phoen_custom_account">
		<?php if($row['custom_profile'] == 'enable'){ ?>
		
			<div class="pho-user-profile">
				
				<div class="pho-user-image">
					
					<?php

						$current_user = wp_get_current_user();
					
						$user_id = $current_user->ID;
						
						echo get_avatar( $user_id, 120 ); 

						//echo phoen_get_avatar('',$user_id,120, '', '', '');
						
						//print_r(phoen_get_avatar('',$user_id,120, '', '', ''));

					?>

				</div>
					
				<div class="pho-user-info">
					
					<p class="pho-username"> <?php echo $current_user->display_name;?> </p>
					
				</div>
				
			</div>
			
		<?php 
			
		}
		$endpints_row = get_option('phoen-endpoint-customer-logout');
				
		$endpoint_label = str_replace("\'", "'", isset($endpints_row['label'])?$endpints_row['label']:"");
		$endpoint_label = str_replace('\"','"', $endpoint_label);
		
		if((isset($endpints_row['active'])  && $endpints_row['active'] == 1) && (isset($endpints_row['type']) && $endpints_row['type'] == 'pre')){
			
			if(isset($endpints_row['slug'])){
				$endpoint_slug = $endpints_row['slug'];
			}else{
				$endpoint_slug = '';
			}
			
		?>
			<div class="phoen_cust_myaccount_main">
			<a  class="button <?php echo wc_get_account_menu_item_classes($endpoint_slug); ?>" href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint_slug ) ); ?>"><i class="fa fa-<?php echo $endpints_row['icon'];?>"></i>&nbsp;<?php echo esc_html($endpoint_label); ?></a>
			</div>
		<?php
		}
		
		?>
		
		<ul class="phoen_nav_tab"><?php 
			foreach($endpoint as $ep)
			{
				if($ep!='customer-logout'){
					$endpints_row = get_option('phoen-endpoint-'.$ep.'');
					$user = wp_get_current_user();
					$roles = $user->roles[0]; 
					
					if(!isset($endpints_row['user_role'])){ $endpints_row['user_role'] = array();}
					if(in_array($roles,$endpints_row['user_role']) || empty($endpints_row['user_role'])){

						$endpoint_label = str_replace("\'", "'", isset($endpints_row['label'])?$endpints_row['label']:"");
						$endpoint_label = str_replace('\"','"', $endpoint_label);
						
						if((isset($endpints_row['active'])  && $endpints_row['active'] == 1) && (isset($endpints_row['type']) && $endpints_row['type'] == 'pre')){
							
							if(isset($endpints_row['slug'])){
								$endpoint_slug = $endpints_row['slug'];
							}else{
								$endpoint_slug = '';
							}
							
						?>
							<li class="<?php echo wc_get_account_menu_item_classes($endpoint_slug); ?>">
								<a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint_slug ) ); ?>"><i class="fa fa-<?php echo $endpints_row['icon'];?>"></i>&nbsp;<?php echo esc_html($endpoint_label); ?></a>
							</li>
						<?php
						}else if((isset($endpints_row['active']) && $endpints_row['active'] == 1) && (isset($endpints_row['type']) &&  $endpints_row['type']== 'custom')){
					
							if($endpints_row['content_type'] == 'custom_url'){
								
								$phoen_endpoint_url = $endpints_row['custom_url'];
								//$phoen_target_page = 'blank';
							
							}else{
								
								$phoen_endpoint_url = get_permalink(get_option('woocommerce_myaccount_page_id'))."?temp=".$endpints_row['slug'];
								//$phoen_target_page = '';
							}
							
							?>
								<li class="<?php echo wc_get_account_menu_item_classes( $endpints_row['slug'] ); ?> <?php echo(isset($_GET['temp']) &&  ($_GET['temp'] == $endpints_row['slug']))?'is-active':'';?>" id="phoen_tab_active">
									<a  class="phoen_click" href="<?php echo $phoen_endpoint_url;?>"><i class="fa fa-<?php echo $endpints_row['icon'];?>"></i>&nbsp;<?php echo esc_html( $endpoint_label ); ?></a>
								</li>
								
							<?php
						}
						
					}
				}
			}?>
		</ul>
	</nav>

<?php }else{ ?>
	
	<nav class="woocommerce-MyAccount-navigation">
		<ul>
			<?php 
				foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
					<li class="<?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
						<a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
					</li>
			<?php endforeach; ?>
		</ul>
	</nav>
	
<?php } do_action( 'woocommerce_after_account_navigation' ); ?>


<style>
.phoen_cust_myaccount_main {
    display: block;
    margin: 0 auto;
    text-align: center;
    margin-bottom: 10px;
}
.woocommerce-account .phoen_custom_account ul {
	
	list-style:none;
	background: none;
}
.pho-user-profile .pho-user-image img {
    margin: 0 auto;
}

<?php  
$padding_top = (isset($row['menu_padding_tab_top']) && $row['menu_padding_tab_top'] != '')?$row['menu_padding_tab_top']:'10';
$padding_right =(isset($row['menu_padding_tab_right']) && $row['menu_padding_tab_right'] != '')?$row['menu_padding_tab_right']:'20';
$padding_bottom =(isset($row['menu_padding_tab_bottom']) && $row['menu_padding_tab_bottom'] != '')?$row['menu_padding_tab_bottom']:'10';
$padding_left = (isset($row['menu_padding_tab_left']) && $row['menu_padding_tab_left'] != '')?$row['menu_padding_tab_left']:'10';
$phoen_tab_weight = (isset($row['phoen_tab_weight']) && $row['phoen_tab_weight'] != '')?$row['phoen_tab_weight']:'normal';
$menu_color_active_color = (isset($row['menu_color_active_color']) && $row['menu_color_active_color'] != '')?$row['menu_color_active_color']:'#3333';

$profile_color = (isset($row['profile_color']) && $row['profile_color'] != '')?$row['profile_color']:'normal';
$profile_font_size = (isset($row['profile_font_size']) && $row['profile_font_size'] != '')?$row['profile_font_size']:'normal';
$phoen_profile_weight = (isset($row['phoen_profile_weight']) && $row['phoen_profile_weight'] != '')?$row['phoen_profile_weight']:'normal';
$phoen_profile_transform = (isset($row['phoen_profile_transform']) && $row['phoen_profile_transform'] != '')?$row['phoen_profile_transform']:'normal';
$profile_margin_text_top = (isset($row['profile_margin_text_top']) && $row['profile_margin_text_top'] != '')?$row['profile_margin_text_top']:'10';
$profile_margin_text_right = (isset($row['profile_margin_text_right']) && $row['profile_margin_text_right'] != '')?$row['profile_margin_text_right']:'0';
$profile_margin_text_bottom = (isset($row['profile_margin_text_bottom']) && $row['profile_margin_text_bottom'] != '')?$row['profile_margin_text_bottom']:'10';
$profile_margin_text_left = (isset($row['profile_margin_text_left']) && $row['profile_margin_text_left'] != '')?$row['profile_margin_text_left']:'0';

$menu_background_active_color = (isset($row['menu_background_active_color']) && $row['menu_background_active_color'] != '')?$row['menu_background_active_color']:'#ccc';

$menu_border_top = (isset($row['menu_border_top']) && $row['menu_border_top'] != '')?$row['menu_border_top']:'';
$menu_border_right = (isset($row['menu_border_right']) && $row['menu_border_right'] != '')?$row['menu_border_right']:'';
$menu_border_bottom = (isset($row['menu_border_bottom']) && $row['menu_border_bottom'] != '')?$row['menu_border_bottom']:'';
$menu_border_left = (isset($row['menu_border_left']) && $row['menu_border_left'] != '')?$row['menu_border_left']:'';


$phoen_menu_border_style = (isset($row['phoen_menu_border_style']) && $row['phoen_menu_border_style'] != '')?$row['phoen_menu_border_style']:'';
$menu_border_color = (isset($row['menu_border_color']) && $row['menu_border_color'] != '')?$row['menu_border_color']:'';
$menu_border_radius = (isset($row['menu_border_radius']) && $row['menu_border_radius'] != '')?$row['menu_border_radius']:'0';
$menu_text_active_color = (isset($row['menu_text_active_color']) && $row['menu_text_active_color'] != '')?$row['menu_text_active_color']:'#000';





	if($row['menu_style'] == 'tab'){ ?>
		
		/* for tab */
		
		.woocommerce-account .woocommerce-MyAccount-content{
			width:100% !important;
			
		}
		
		.woocommerce-account nav.phoen_custom_account {
			float: none;
			width: 100% !important;
		}

		nav.phoen_custom_account .pho-user-profile {
			display: block;
		}

		.woocommerce-account .phoen_custom_account ul li {
			display: inline-block;
			margin-left: -5px;
			border: #ccc solid 1px;
		}

		.woocommerce-account .phoen_custom_account ul li:first-child {
			margin-left: 0;
		}

		.woocommerce-account .phoen_custom_account ul li a {
			border: none;
			box-shadow: none;
			font-size: 14px;
			display: block;
			padding: 5px 10px;
			text-align: center;
			border-right: none;
			font-weight:<?php echo $phoen_tab_weight ; ?>
		}
		
		.woocommerce .phoen_custom_account ul li.is-active{
			box-shadow: 0 -3px 0 0 <?php echo $menu_color_active_color ; ?> inset;
		}
		
		.woocommerce .phoen_custom_account ul {
			margin-bottom: 20px;
		}
		
		.woocommerce .phoen_custom_account ul li.woocommerce-MyAccount-navigation-link:last-child a {
			border-right: <?php echo $menu_border_right ; ?>px;
			border-color: <?php echo $menu_border_color ; ?>;
			border-style: <?php echo $phoen_menu_border_style ; ?>;
		}

	.woocommerce .phoen_custom_account ul li.woocommerce-MyAccount-navigation-link a {	
		border-width: <?php echo $menu_border_top ; ?>px 0 <?php echo $menu_border_bottom ;?>px <?php echo $menu_border_left ; ?>px;
		border-color: <?php echo $menu_border_color ; ?>;
		border-style: <?php echo $phoen_menu_border_style ; ?>;
		border-radius: <?php echo $menu_border_radius ; ?>px;
	
	}		

		
	<?php }else{  ?>
		
		/*For sidebar */
		
		.woocommerce-account .woocommerce-MyAccount-navigation.phoen_custom_account {
			float: left;
			width: <?php echo(isset($row['menu_width_size']) && $row['menu_width_size'] != '')?$row['menu_width_size']:'30';?>%;
			margin:0;
		}
		 
		 
		@media (max-width: 768px) { 
			.woocommerce-account .woocommerce-MyAccount-navigation.phoen_custom_account, .woocommerce-account .woocommerce-MyAccount-content {
				float: none;
				width: 100%!important;
			}
		}	
		
		.woocommerce .phoen_custom_account ul li.woocommerce-MyAccount-navigation-link.is-active a{
			box-shadow: 4px 0 0 0 <?php echo $menu_color_active_color ; ?> inset;
			
		}
		
		.woocommerce .phoen_custom_account ul li.woocommerce-MyAccount-navigation-link {
			border: 0 none;
			padding: 0;
			display: block;
			margin:0;
		}
		
		
		.woocommerce .phoen_custom_account ul li.woocommerce-MyAccount-navigation-link a {
			
			box-shadow: none;
			display: block;
			padding: 10px 12px;
			text-decoration: none;
			text-align: left;
			font-weight:<?php echo $phoen_tab_weight ; ?>
			
		}

		.woocommerce-account .phoen_custom_account ul li a:hover, .woocommerce-account .phoen_custom_account ul li a:focus {
			text-decoration: none;
			outline: none;
		}
		.woocommerce-account .woocommerce-MyAccount-content {
			float: right;
			width: <?php echo(isset($row['menu_width_size']) && $row['menu_width_size'] !='')?(98-$row['menu_width_size']):'70';?>%;
		}
		
		.woocommerce .phoen_custom_account ul li.woocommerce-MyAccount-navigation-link:last-child a {
			border-bottom: <?php echo $menu_border_bottom ; ?>px;
			border-color: <?php echo $menu_border_color ; ?>;
			border-style: <?php echo $phoen_menu_border_style ; ?>;
		}	
		
	.woocommerce .phoen_custom_account ul li.woocommerce-MyAccount-navigation-link a {	
		border-width: <?php echo $menu_border_top ; ?>px <?php echo $menu_border_right ; ?>px 0 <?php echo $menu_border_left ; ?>px;
		border-color: <?php echo $menu_border_color ; ?>;
		border-style: <?php echo $phoen_menu_border_style ; ?>;
		border-radius: <?php echo $menu_border_radius ; ?>px;
	
	}

				
	<?php }	
?>

.pho-user-info .pho-username {
    color: <?php echo $profile_color ;?>!important;
    font-size: <?php echo $profile_font_size ;?>px;
    font-weight: <?php echo $phoen_profile_weight ; ?>;
    text-align: center;
    text-transform: <?php echo $phoen_profile_transform ; ?>;
	 margin: <?php echo $profile_margin_text_top ;?>px <?php echo $profile_margin_text_right ;?>px <?php echo $profile_margin_text_bottom ;?>px <?php echo $profile_margin_text_left ;?>px;
}


.woocommerce .phoen_custom_account ul {
	margin-left: 0;
	padding-left:0;
}

.phoen_custom_account .pho-user-profile {
    text-align: center;
}

.woocommerce .phoen_custom_account ul li {
	padding: 0;
}	

.woocommerce .phoen_custom_account ul li.woocommerce-MyAccount-navigation-link a {
	font-size: <?php echo(isset($row['menu_text_size']) && $row['menu_text_size'] !='')?($row['menu_text_size']):'16';?>px;
	padding: <?php echo $padding_top ; ?>px  <?php echo $padding_right ; ?>px  <?php echo $padding_bottom ; ?>px  <?php echo $padding_left ; ?>px ;
	font-weight:<?php echo $phoen_tab_weight ; ?>
	box-shadow: none;
	display: block;
	text-decoration: none;
	text-align: left;
	
}

.woocommerce .phoen_custom_account ul li.woocommerce-MyAccount-navigation-link.is-active a{
	
		background-color: <?php echo $menu_background_active_color ;?> !important;
		color: <?php echo $menu_text_active_color ; ?> !important;
	}
	
	

.woocommerce-account .woocommerce-MyAccount-content{
	margin:0;
}
.woocommerce .phoen_custom_account ul li a::before {
    display: none;
}
.phoen_custom_account .fa {
    font-size: <?php echo(isset($row['menu_icon_font_size']) && $row['menu_icon_font_size'] !='')?($row['menu_icon_font_size']):'20';?>px;
	width: <?php echo(isset($row['menu_icon_font_size']) && $row['menu_icon_font_size'] !='')?($row['menu_icon_font_size']):'20';?>px;  
    vertical-align: middle;
	margin-right: <?php echo(isset($row['icon_text_menu_margin']) && $row['icon_text_menu_margin'] !='')?($row['icon_text_menu_margin']):'5';?>px;
	color: <?php echo(isset($row['menu_icon_color']) && $row['menu_icon_color'] !='')?($row['menu_icon_color']):'';?>;
	
}
.phoen_custom_account .fa:hover {
	color:<?php echo(isset($row['menu_icon_hvr_color']) && $row['menu_icon_hvr_color'] !='')?($row['menu_icon_hvr_color']):'';?>;
}
</style>