<?php

/**
 * @author WC MArketplace
 */
class WCMp_Paypal_Checkout_For_Woocommerce_Admin {

    private $plugin_name;
    private $version;

    public function __construct($plugin_name, $version) {

        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    public function enqueue_scripts() {
        global $WCMP_Paypal_Checkout_Gateway;
        if (isset($_GET['section']) && 'paypal_smart_checkout' === $_GET['section']) {
            wp_enqueue_script($this->plugin_name, $WCMP_Paypal_Checkout_Gateway->plugin_url . 'assets/admin/js/wcmp-paypal-checkout-for-woocommerce-admin.js', array('jquery'), time(), false);
            wp_localize_script($this->plugin_name, 'paypal_smart_checkout', array(
                'woocommerce_currency' => get_woocommerce_currency(),
                'is_advanced_cards_available' => wcmp_paypal_is_advanced_cards_available() ? 'yes' : 'no'
            ));
        }
    }
}
