<?php

defined('ABSPATH') || exit;

$default_settings = array(
    'enabled' => array(
        'title' => __('Enable/Disable', 'wcmp-paypal-checkout-gateway'),
        'type' => 'checkbox',
        'label' => __('Enable PayPal Checkout', 'wcmp-paypal-checkout-gateway'),
        'description' => __('Check this box to enable the payment gateway. Leave unchecked to disable it.', 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true,
        'default' => 'yes',
    ),
    'title' => array(
        'title' => __('Title', 'wcmp-paypal-checkout-gateway'),
        'type' => 'text',
        'description' => __('This controls the label the user will see for this payment option during checkout.', 'wcmp-paypal-checkout-gateway'),
        'default' => __('PayPal', 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true,
    ),
    'description' => array(
        'title' => __('Description', 'wcmp-paypal-checkout-gateway'),
        'type' => 'text',
        'desc_tip' => true,
        'description' => __('This controls the description the user will see for this payment option during checkout.', 'wcmp-paypal-checkout-gateway'),
        'default' => __("Pay via PayPal; you can pay with your credit card if you don't have a PayPal account.", 'wcmp-paypal-checkout-gateway'),
    ),
    'testmode' => array(
        'title' => __('PayPal sandbox', 'wcmp-paypal-checkout-gateway'),
        'type' => 'checkbox',
        'label' => __('Enable PayPal sandbox', 'wcmp-paypal-checkout-gateway'),
        'default' => 'no',
        'description' => __('Check this box to enable test mode so that all transactions will hit PayPal’s sandbox server instead of the live server. This should only be used during development as no real transactions will occur when this is enabled.', 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true
    ),
    'enabled_split_payment' => array(
        'title' => __('Enabled Paypal Split', 'wcmp-paypal-checkout-gateway'),
        'type' => 'checkbox',
        'label' => __('Enabled Paypal Split Payment', 'wcmp-paypal-checkout-gateway'),
        'default' => 'no',
        'description' => __('Enabled paypal split/multiaccount paymant.', 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true
    ),
    'api_details' => array(
        'title' => __('API credentials', 'wcmp-paypal-checkout-gateway'),
        'type' => 'title',
        'description' => __("<a target='_blank' href='https://developer.paypal.com/docs/business/get-started/#step-1-get-api-credentials'>Get API credentials</a>", 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true
    ),
    'rest_email_live' => array(
        'title' => __('Live Account Email', 'woo-paypal-checkout'),
        'type' => 'password',
        'description' => 'Enter your Live PayPal Rest API Email',
        'default' => '',
        'desc_tip' => true,
    ),
    'api_client_id' => array(
        'title' => __('PayPal Client ID', 'wcmp-paypal-checkout-gateway'),
        'type' => 'password',
        'description' => __('Enter your PayPal Client ID.', 'wcmp-paypal-checkout-gateway'),
        'default' => '',
        'desc_tip' => true
    ),
    'api_secret' => array(
        'title' => __('PayPal Secret', 'wcmp-paypal-checkout-gateway'),
        'type' => 'password',
        'description' => __('Enter your PayPal Secret.', 'wcmp-paypal-checkout-gateway'),
        'default' => '',
        'desc_tip' => true
    ),
    'rest_email_sandbox' => array(
        'title' => __('Sandbox Account Email', 'woo-paypal-checkout'),
        'type' => 'password',
        'description' => 'Enter your Sandbox PayPal Rest API Email',
        'default' => '',
        'desc_tip' => true,
    ),
    'sandbox_client_id' => array(
        'title' => __('Sandbox Client ID', 'wcmp-paypal-checkout-gateway'),
        'type' => 'password',
        'description' => __('Enter your PayPal Sandbox Client ID.', 'wcmp-paypal-checkout-gateway'),
        'default' => '',
        'desc_tip' => true
    ),
    'sandbox_api_secret' => array(
        'title' => __('Sandbox Secret', 'wcmp-paypal-checkout-gateway'),
        'type' => 'password',
        'description' => __('Enter your PayPal Sandbox Secret.', 'wcmp-paypal-checkout-gateway'),
        'default' => '',
        'desc_tip' => true
    )
);

$button_manager_settings = array(
    /*'button_manager' => array(
        'title' => __('WCMp Payment Buttons options', 'wcmp-paypal-checkout-gateway'),
        'type' => 'title',
        'description' => '',
    ),
    'style_color' => array(
        'title' => __('Button Color', 'wcmp-paypal-checkout-gateway'),
        'type' => 'select',
        'class' => 'wc-enhanced-select',
        'description' => __('Set the color you would like to use for the PayPal button.', 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true,
        'default' => 'gold',
        'options' => array(
            'gold' => __('Gold (Recommended)', 'wcmp-paypal-checkout-gateway'),
            'blue' => __('Blue', 'wcmp-paypal-checkout-gateway'),
            'silver' => __('Silver', 'wcmp-paypal-checkout-gateway'),
            'white' => __('White', 'wcmp-paypal-checkout-gateway'),
            'black' => __('Black', 'wcmp-paypal-checkout-gateway')
        ),
    ),
    'style_shape' => array(
        'title' => __('Button Shape', 'wcmp-paypal-checkout-gateway'),
        'type' => 'select',
        'class' => 'wc-enhanced-select',
        'description' => __('Set the shape you would like to use for the buttons.', 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true,
        'default' => 'rect',
        'options' => array(
            'rect' => __('Rect (Recommended)', 'wcmp-paypal-checkout-gateway'),
            'pill' => __('Pill', 'wcmp-paypal-checkout-gateway')
        ),
    ),
    'style_label' => array(
        'title' => __('Button Label', 'wcmp-paypal-checkout-gateway'),
        'type' => 'select',
        'class' => 'wc-enhanced-select',
        'description' => __('Set the label type you would like to use for the PayPal button.', 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true,
        'default' => 'paypal',
        'options' => array(
            'paypal' => __('PayPal (Recommended)', 'wcmp-paypal-checkout-gateway'),
            'checkout' => __('Checkout', 'wcmp-paypal-checkout-gateway'),
            'buynow' => __('Buynow', 'wcmp-paypal-checkout-gateway'),
            'pay' => __('Pay', 'wcmp-paypal-checkout-gateway')
        ),
    ),
    'disable_funding' => array(
        'title' => __('Disable funding', 'wcmp-paypal-checkout-gateway'),
        'type' => 'multiselect',
        'class' => 'wc-enhanced-select',
        'description' => __('Funding methods selected here will be hidden from showing in the Smart Payment Buttons.', 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true,
        'options' => array(
            'credit' => __('PayPal Credit', 'wcmp-paypal-checkout-gateway'),
            'venmo' => __('Venmo', 'wcmp-paypal-checkout-gateway'),
            'sepa' => __('SEPA-Lastschrift', 'wcmp-paypal-checkout-gateway'),
            'bancontact' => __('Bancontact', 'wcmp-paypal-checkout-gateway'),
            'eps' => __('eps', 'wcmp-paypal-checkout-gateway'),
            'giropay' => __('giropay', 'wcmp-paypal-checkout-gateway'),
            'ideal' => __('iDEAL', 'wcmp-paypal-checkout-gateway'),
            'mybank' => __('MyBank', 'wcmp-paypal-checkout-gateway'),
            'p24' => __('Przelewy24', 'wcmp-paypal-checkout-gateway'),
            'sofort' => __('Sofort', 'wcmp-paypal-checkout-gateway'),
        ),
    )*/
);

$order_review_page_settings = array(
    /*'order_review_page' => array(
        'title' => __('Order Review Page options', 'wcmp-paypal-checkout-gateway'),
        'type' => 'title',
        'description' => '',
    ),
    'order_review_page_title' => array(
        'title' => __('Page Title', 'wcmp-paypal-checkout-gateway'),
        'type' => 'text',
        'description' => __('Set the Page Title value you would like used on the PayPal Checkout order review page.', 'wcmp-paypal-checkout-gateway'),
        'default' => __('Confirm your PayPal order', 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true,
    ),
    'order_review_page_description' => array(
        'title' => __('Description', 'wcmp-paypal-checkout-gateway'),
        'type' => 'text',
        'desc_tip' => true,
        'description' => __('Set the Description you would like used on the PayPal Checkout order review page.', 'wcmp-paypal-checkout-gateway'),
        'default' => __("<strong>You're almost done!</strong><br>Review your information before you place your order.", 'wcmp-paypal-checkout-gateway'),
    ),
    'order_review_page_button_text' => array(
        'title' => __('Button Text', 'wcmp-paypal-checkout-gateway'),
        'type' => 'text',
        'description' => __('Set the Button Text you would like used on the PayPal Checkout order review page.', 'wcmp-paypal-checkout-gateway'),
        'default' => __('Confirm your PayPal order', 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true,
    )*/
);

$advanced_settings = array(
    /*'advanced' => array(
        'title' => __('Advanced options', 'wcmp-paypal-checkout-gateway'),
        'type' => 'title',
        'description' => '',
    ),
    'brand_name' => array(
        'title' => __('Brand Name', 'wcmp-paypal-checkout-gateway'),
        'type' => 'text',
        'description' => __('This controls what users see as the brand / company name on PayPal review pages.', 'wcmp-paypal-checkout-gateway'),
        'default' => __(get_bloginfo('name'), 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true,
    ),
    'landing_page' => array(
        'title' => __('Landing Page', 'wcmp-paypal-checkout-gateway'),
        'type' => 'select',
        'class' => 'wc-enhanced-select',
        'description' => __('The type of landing page to show on the PayPal site for customer checkout. PayPal Account Optional must be checked for this option to be used.', 'wcmp-paypal-checkout-gateway'),
        'options' => array('LOGIN' => __('Login', 'wcmp-paypal-checkout-gateway'),
            'BILLING' => __('Billing', 'wcmp-paypal-checkout-gateway'),
            'NO_PREFERENCE' => __('No Preference', 'wcmp-paypal-checkout-gateway')),
        'default' => 'NO_PREFERENCE',
        'desc_tip' => true,
    ),*/
    'enable_advanced_card_payments' => array(
        'title' => __('Enable/Disable', 'wcmp-paypal-checkout-gateway'),
        'type' => 'checkbox',
        'label' => __('Enable advanced credit and debit card payments', 'wcmp-paypal-checkout-gateway'),
        'default' => 'no',
        'description' => __('Currently PayPal support Unbranded payments in US, AU, UK, FR, IT and ES only. <br> <br>Advanced credit and debit cards requires that your business account be evaluated and approved by PayPal. <br><a target="_blank" href="https://www.sandbox.paypal.com/bizsignup/entry/product/ppcp">Enable for Sandbox Account</a> <span> | </span> <a target="_blank" href="https://www.paypal.com/bizsignup/entry/product/ppcp">Enable for Live Account</a><br>', 'wcmp-paypal-checkout-gateway'),
    ),
    'threed_secure_enabled' => array(
        'title' => __('3D Secure', 'wcmp-paypal-checkout-gateway'),
        'type' => 'checkbox',
        'label' => __('Enable 3D Secure', 'wcmp-paypal-checkout-gateway'),
        'description' => __('If you are based in Europe, you are subjected to PSD2. PayPal recommends this option', 'wcmp-paypal-checkout-gateway'),
        'default' => 'no',
    ),
    /*'paymentaction' => array(
        'title' => __('Payment action', 'wcmp-paypal-checkout-gateway'),
        'type' => 'select',
        'class' => 'wc-enhanced-select',
        'description' => __('Choose whether you wish to capture funds immediately or authorize payment only.', 'wcmp-paypal-checkout-gateway') .'  '. $payment_action_not_available,
        'default' => 'capture',
        'desc_tip' => true,
        'options' => array(
            'capture' => __('Capture', 'wcmp-paypal-checkout-gateway'),
            'authorize' => __('Authorize', 'wcmp-paypal-checkout-gateway'),
        ),
    ),*/
    'invoice_prefix' => array(
        'title' => __('Invoice prefix', 'wcmp-paypal-checkout-gateway'),
        'type' => 'text',
        'description' => __('Please enter a prefix for your invoice numbers. If you use your PayPal account for multiple stores ensure this prefix is unique as PayPal will not allow orders with the same invoice number.', 'wcmp-paypal-checkout-gateway'),
        'default' => 'WC-PSB',
        'desc_tip' => true,
    ),
    'disable_debit_card' => array(
        'title' => __('Disable debit and credit cart', 'wcmp-paypal-checkout-gateway'),
        'type' => 'checkbox',
        'label' => __('Disable debit and credit cart', 'wcmp-paypal-checkout-gateway'),
        'default' => 'no',
        'description' => __('Disable debit and credit cart on checkout page.', 'wcmp-paypal-checkout-gateway'),
        'desc_tip' => true
    ),
    'debug' => array(
        'title' => __('Debug log', 'wcmp-paypal-checkout-gateway'),
        'type' => 'checkbox',
        'label' => __('Enable logging', 'wcmp-paypal-checkout-gateway'),
        'default' => 'no',
        'description' => sprintf(__('Log PayPal events, such as Webhook, Payment, Refund inside %s Note: this may log personal information. We recommend using this for debugging purposes only and deleting the logs when finished.', 'wcmp-paypal-checkout-gateway'), '<code>' . WC_Log_Handler_File::get_log_file_path('paypal') . '</code>'),
    )
);
/*if (function_exists('wc_coupons_enabled')) {
    if (wc_coupons_enabled()) {
        $order_review_page_settings['order_review_page_enable_coupons'] = array(
            'title' => __('Enable/Disable coupons', 'wcmp-paypal-checkout-gateway'),
            'type' => 'checkbox',
            'label' => __('Enable the use of coupon codes', 'wcmp-paypal-checkout-gateway'),
            'description' => __('Coupons can be applied from the order review.', 'wcmp-paypal-checkout-gateway'),
            'default' => 'yes',
        );
    }
}*/
$settings = apply_filters('wcmp_paypal_settings', array_merge($default_settings, $button_manager_settings, $order_review_page_settings, $advanced_settings));
return $settings;
