<?php

/**
 * @since      1.0.0
 * @author     WC Marketplace
 */
class Paypal_Checkout_For_Woocommerce {

    protected $loader;
    protected $plugin_name;
    protected $version;
    public $button_manager;
    public $license;
    public function __construct() {
        if (defined('WCMP_PAYPAL_CHECKOUT_GATEWAY_PLUGIN_VERSION')) {
            $this->version = WCMP_PAYPAL_CHECKOUT_GATEWAY_PLUGIN_VERSION;
        } else {
            $this->version = '1.0.0';
        }
        $this->plugin_name = 'wcmp-paypal-checkout-gateway';
        add_filter('woocommerce_payment_gateways', array($this, 'wcmp_paypal_woocommerce_payment_gateways'), 99999999);
        $prefix = is_network_admin() ? 'network_admin_' : '';
        add_filter("{$prefix}plugin_action_links_" . plugin_basename(__FILE__), array($this, 'wcmp_paypal_plugin_action_links'), 10, 1);
        $this->load_dependencies();
        $this->define_admin_hooks();
        $this->define_public_hooks();
        add_action('init', array(&$this, 'wcmp_paypal_init'));
    }

    private function load_dependencies() {
        global $WCMP_Paypal_Checkout_Gateway;
        require_once $WCMP_Paypal_Checkout_Gateway->plugin_path . 'classes/class-wcmp-paypal-checkout-for-woocommerce-loader.php';
        require_once $WCMP_Paypal_Checkout_Gateway->plugin_path . 'admin/class-wcmp-paypal-checkout-for-woocommerce-admin.php';
        require_once $WCMP_Paypal_Checkout_Gateway->plugin_path . 'classes/class-wcmp-paypal-checkout-for-woocommerce-button-manager.php';
        require_once $WCMP_Paypal_Checkout_Gateway->plugin_path . 'classes/class-wcmp-paypal-checkout-for-woocommerce-product.php';



        $this->loader = new Paypal_Checkout_For_Woocommerce_Loader();
    }

    private function define_admin_hooks() {
        $plugin_admin = new WCMp_Paypal_Checkout_For_Woocommerce_Admin($this->get_plugin_name(), $this->get_version());
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts');
    }

    private function define_public_hooks() {
        $this->button_manager = new Paypal_Checkout_For_Woocommerce_Button_Manager($this->get_plugin_name(), $this->get_version());
    }

    public function run() {
        $this->loader->run();
    }

    public function get_plugin_name() {
        return $this->plugin_name;
    }

    public function get_loader() {
        return $this->loader;
    }

    public function get_version() {
        return $this->version;
    }

    public function wcmp_paypal_woocommerce_payment_gateways($methods) {
        global $WCMP_Paypal_Checkout_Gateway;
        include_once $WCMP_Paypal_Checkout_Gateway->plugin_path . 'classes/class-wcmp-paypal-checkout-for-woocommerce-gateway.php';
        $methods[] = 'Paypal_Checkout_For_Woocommerce_Gateway';
        return $methods;
    }

    public function wcmp_paypal_plugin_action_links($actions) {
        $custom_actions = array(
            'settings' => sprintf('<a href="%s">%s</a>', admin_url('admin.php?page=wc-settings&tab=checkout&section=paypal_smart_checkout'), __('Settings', 'wcmp-paypal-checkout-gateway')),
        );
        return array_merge($custom_actions, $actions);
    }

    public function wcmp_paypal_init() {
        add_action( 'woocommerce_check_cart_items', array($this, 'check_paypal_product_added_to_cart'), 10 );
    }

    public function check_paypal_product_added_to_cart() {
        $checkout_woocommerce_class = new Paypal_Checkout_For_Woocommerce();
        foreach( WC()->cart->get_cart() as $key => $item ) {
            $cart_product_id = $item['product_id'];
            $product_vendor = get_wcmp_product_vendors( $cart_product_id );
            $admin_email_link = "<a href='mailto:" . get_option('admin_email') . "'>". __('admin', 'wcmp-stripe-marketplace') ."</a>";
            $error_msg = __("You have a product belonging to one vendor in your cart who might be facing some technical issues related to PayPal settings.", 'wcmp-stripe-marketplace') . __('Contact the ', 'wcmp-stripe-marketplace') . $admin_email_link . __(' for more details.', 'wcmp-stripe-marketplace');
            if( $product_vendor && $checkout_woocommerce_class->button_manager->enabled && $checkout_woocommerce_class->button_manager->enabled_split_payment ) {
                $vendor_payment_method = get_user_meta( $product_vendor->id, '_vendor_payment_mode', true );
                $vendor_paypal_masspay_id = get_user_meta( $product_vendor->id, '_vendor_paypal_email', true );
                $is_vendor_connected_to_stripe = get_user_meta( $product_vendor->id, 'vendor_connected', true );
                $vendor_payment_method_check = $vendor_payment_method == 'paypal_masspay' ? true : false;
                $paypal_masspay_enabled = apply_filters('wcmp_paypal_masspay_enabled', $vendor_payment_method_check);
                if ( $paypal_masspay_enabled && $vendor_paypal_masspay_id && $checkout_woocommerce_class->button_manager->account_email && $checkout_woocommerce_class->button_manager->account_email != $vendor_paypal_masspay_id ) {} else {
                    wc_add_notice($error_msg, 'error');
                }
            }
        }
    }
}
