<?php

class WCMP_Paypal_Checkout_Gateway {

    public $plugin_url;
    public $plugin_path;
    public $version;
    public $token;
    public $text_domain;
    public $library;
    public $shortcode;
    public $admin;
    public $frontend;
    public $template;
    public $ajax;
    private $file;
    public $settings;
    public $dc_wp_fields;
    public $payment_admin_settings;
    public $license;

    public function __construct($file) {

        $this->file = $file;
        $this->plugin_url = trailingslashit(plugins_url('', $plugin = $file));
        $this->plugin_path = trailingslashit(dirname($file));
        $this->token = WCMP_PAYPAL_CHECKOUT_GATEWAY_PLUGIN_TOKEN;
        $this->text_domain = WCMP_PAYPAL_CHECKOUT_GATEWAY_TEXT_DOMAIN;
        $this->version = WCMP_PAYPAL_CHECKOUT_GATEWAY_PLUGIN_VERSION;

        require_once $this->plugin_path . 'classes/class-wcmp-vendor-paypal-license.php';        
        $this->license =  new WCMP_Vendor_Paypal_License( $this->file, $this->plugin_path, WCMP_VENDOR_PAYPAL_PLUGIN_PRODUCT_ID, $this->version, 'plugin', WCMP_VENDOR_PAYPAL_PLUGIN_SERVER_URL, WCMP_VENDOR_PAYPAL_PLUGIN_SOFTWARE_TITLE, $this->text_domain  );


        add_action('init', array(&$this, 'init'), 0);
    }

    /**
     * initilize plugin on WP init
     */
    function init() {
        // Init Text Domain
        $this->load_plugin_textdomain();
    }

    /**
     * Load Localisation files.
     *
     * Note: the first-loaded translation file overrides any following ones if the same translation is present
     *
     * @access public
     * @return void
     */
    public function load_plugin_textdomain() {
        $locale = is_admin() && function_exists('get_user_locale') ? get_user_locale() : get_locale();
        $locale = apply_filters('plugin_locale', $locale, 'wcmp-paypal-checkout-gateway');
        load_textdomain('wcmp-paypal-checkout-gateway', WP_LANG_DIR . '/wcmp-paypal-checkout-gateway/wcmp-paypal-checkout-gateway-' . $locale . '.mo');
        load_plugin_textdomain('wcmp-paypal-checkout-gateway', false, plugin_basename(dirname(dirname(__FILE__))) . '/languages');
    }

    public function load_class($class_name = '') {
        if ('' != $class_name && '' != $this->token) {
            require_once ('class-' . esc_attr($this->token) . '-' . esc_attr($class_name) . '.php');
        } // End If Statement
    }

    // End load_class()

    /** Cache Helpers ******************************************************** */

    /**
     * Sets a constant preventing some caching plugins from caching a page. Used on dynamic pages
     *
     * @access public
     * @return void
     */
    function nocache() {
        if (!defined('DONOTCACHEPAGE'))
            define("DONOTCACHEPAGE", "true");
        // WP Super Cache constant
    }

}
