<?php

if (!function_exists('woocommerce_inactive_notice')) {

    function woocommerce_inactive_notice() {
        ?>
        <div id="message" class="error">
            <p><?php printf(__('%sWCMp Paypal Checkout Gateway is inactive.%s The %sWooCommerce plugin%s must be active for the WCMp Paypal Checkout Gateway to work. Please %sinstall & activate WooCommerce%s', 'wcmp-paypal-checkout-gateway'), '<strong>', '</strong>', '<a target="_blank" href="http://wordpress.org/extend/plugins/woocommerce/">', '</a>', '<a href="' . admin_url('plugins.php') . '">', '&nbsp;&raquo;</a>'); ?></p>
        </div>
        <?php
    }

}


function wcmp_paypal_remove_empty_key($data) {
    $original = $data;
    $data = array_filter($data);
    $data = array_map(function ($e) {
        return is_array($e) ? wcmp_paypal_remove_empty_key($e) : $e;
    }, $data);
    return $original === $data ? $data : wcmp_paypal_remove_empty_key($data);
}

function wcmp_paypal_set_session($key, $value) {
    if (!class_exists('WooCommerce') || WC()->session == null) {
        return false;
    }
    $wcmp_paypal_session = WC()->session->get('wcmp_paypal_session');
    if (!is_array($wcmp_paypal_session)) {
        $wcmp_paypal_session = array();
    }
    $wcmp_paypal_session[$key] = $value;
    WC()->session->set('wcmp_paypal_session', $wcmp_paypal_session);
}

function wcmp_paypal_get_session($key) {
    if (!class_exists('WooCommerce') || WC()->session == null) {
        return false;
    }

    $wcmp_paypal_session = WC()->session->get('wcmp_paypal_session');
    if (!empty($wcmp_paypal_session[$key])) {
        return $wcmp_paypal_session[$key];
    }
    return false;
}

function wcmp_paypal_unset_session($key) {
    if (!class_exists('WooCommerce') || WC()->session == null) {
        return false;
    }
    $wcmp_paypal_session = WC()->session->get('wcmp_paypal_session');
    if (!empty($wcmp_paypal_session[$key])) {
        unset($wcmp_paypal_session[$key]);
        WC()->session->set('wcmp_paypal_session', $wcmp_paypal_session);
    }
}

function has_active_session() {
    $checkout_details = wcmp_paypal_get_session('wcmp_paypal_paypal_transaction_details');
    $wcmp_paypal_paypal_order_id = wcmp_paypal_get_session('wcmp_paypal_paypal_order_id');
    if (!empty($checkout_details) && !empty($wcmp_paypal_paypal_order_id) && isset($_GET['paypal_order_id'])) {
        return true;
    }
    return false;
}

function wcmp_paypal_update_post_meta($order, $key, $value) {
    if (!is_object($order)) {
        $order = wc_get_order($order);
    }
    $old_wc = version_compare(WC_VERSION, '3.0', '<');
    if ($old_wc) {
        update_post_meta($order->id, $key, $value);
    } else {
        $order->update_meta_data($key, $value);
    }
    if (!$old_wc) {
        $order->save_meta_data();
    }
}

function wcmp_paypal_get_post_meta($order, $key, $bool = true) {
    $order_meta_value = false;
    if (!is_object($order)) {
        $order = wc_get_order($order);
    }
    $old_wc = version_compare(WC_VERSION, '3.0', '<');
    if ($old_wc) {
        $order_meta_value = get_post_meta($order->id, $key, $bool);
    } else {
        $order_meta_value = $order->get_meta($key, $bool);
    }
    return $order_meta_value;
}

function get_button_locale_code() {
    $_supportedLocale = array(
        'en_US', 'fr_XC', 'es_XC', 'zh_XC', 'en_AU', 'de_DE', 'nl_NL',
        'fr_FR', 'pt_BR', 'fr_CA', 'zh_CN', 'ru_RU', 'en_GB', 'zh_HK',
        'he_IL', 'it_IT', 'ja_JP', 'pl_PL', 'pt_PT', 'es_ES', 'sv_SE', 'zh_TW', 'tr_TR'
    );
    $wpml_locale = wcmp_paypal_get_wpml_locale();
    if ($wpml_locale) {
        if (in_array($wpml_locale, $_supportedLocale)) {
            return $wpml_locale;
        }
    }
    $locale = get_locale();
    if (get_locale() != '') {
        $locale = substr(get_locale(), 0, 5);
    }
    if (!in_array($locale, $_supportedLocale)) {
        $locale = 'en_US';
    }
    return $locale;
}

function wcmp_paypal_get_wpml_locale() {
    $locale = false;
    if (defined('ICL_LANGUAGE_CODE') && function_exists('icl_object_id')) {
        global $sitepress;
        if (isset($sitepress)) {
            $locale = $sitepress->get_current_language();
        } else if (function_exists('pll_current_language')) {
            $locale = pll_current_language('locale');
        } else if (function_exists('pll_default_language')) {
            $locale = pll_default_language('locale');
        }
    }
    return $locale;
}

function wcmp_paypal_is_local_server() {
    if (!isset($_SERVER['HTTP_HOST'])) {
        return;
    }
    if ($_SERVER['HTTP_HOST'] === 'localhost' || substr($_SERVER['REMOTE_ADDR'], 0, 3) === '10.' || substr($_SERVER['REMOTE_ADDR'], 0, 7) === '192.168') {
        return true;
    }
    $live_sites = [
        'HTTP_CLIENT_IP',
        'HTTP_X_REAL_IP',
        'HTTP_X_FORWARDED_FOR',
        'HTTP_X_FORWARDED',
        'HTTP_X_CLUSTER_CLIENT_IP',
    ];
    foreach ($live_sites as $ip) {
        if (!empty($_SERVER[$ip])) {
            return false;
        }
    }
    if (in_array($_SERVER['REMOTE_ADDR'], array('127.0.0.1', '::1'))) {
        return true;
    }
    $fragments = explode('.', site_url());
    if (in_array(end($fragments), array('dev', 'local', 'localhost', 'test'))) {
        return true;
    }
    return false;
}

function wcmp_paypal_readable($tex) {
    $tex = ucwords(strtolower(str_replace('_', ' ', $tex)));
    return $tex;
}

if (!function_exists('wcmp_paypal_is_advanced_cards_available')) {

    function wcmp_paypal_is_advanced_cards_available() {
        try {
            $currency = get_woocommerce_currency();
            $country_state = wc_get_base_location();
            $available = array(
                'US' => array('AUD', 'CAD', 'EUR', 'GBP', 'JPY', 'USD'),
                'AU' => array('AUD', 'CAD', 'CHF', 'CZK', 'DKK', 'EUR', 'GBP', 'HKD', 'HUF', 'JPY', 'NOK', 'NZD', 'PLN', 'SEK', 'SGD', 'USD'),
                'GB' => array('AUD', 'CAD', 'CHF', 'CZK', 'DKK', 'EUR', 'GBP', 'HKD', 'HUF', 'JPY', 'NOK', 'NZD', 'PLN', 'SEK', 'SGD', 'USD'),
                'FR' => array('AUD', 'CAD', 'CHF', 'CZK', 'DKK', 'EUR', 'GBP', 'HKD', 'HUF', 'JPY', 'NOK', 'NZD', 'PLN', 'SEK', 'SGD', 'USD'),
                'IT' => array('AUD', 'CAD', 'CHF', 'CZK', 'DKK', 'EUR', 'GBP', 'HKD', 'HUF', 'JPY', 'NOK', 'NZD', 'PLN', 'SEK', 'SGD', 'USD'),
                'ES' => array('AUD', 'CAD', 'CHF', 'CZK', 'DKK', 'EUR', 'GBP', 'HKD', 'HUF', 'JPY', 'NOK', 'NZD', 'PLN', 'SEK', 'SGD', 'USD')
            );
            if (isset($available[$country_state['country']]) && in_array($currency, $available[$country_state['country']])) {
                return true;
            }
            return false;
        } catch (Exception $ex) {
            return false;
        }
    }
}