<?php

/**
 * Plugin Name: WCMp Paypal Split Payment
 * Plugin URI: https://wc-marketplace.com/
 * Description: WCMp Paypal Checkout Gateway is a payment gateway for woocommerce shopping plateform also compatible with WC Marketplace.
 * Author: WC Marketplace
 * Version: 1.0.4
 * Author URI: https://wc-marketplace.com/
 *
 * Text Domain: wcmp-paypal-checkout-gateway
 * Domain Path: /languages/
 */
if (!defined('ABSPATH')) {
    // Exit if accessed directly
    exit;
}
if (!class_exists('WCMP_Paypal_Checkout_Gateway_Dependencies')) {
    require_once 'includes/class-wcmp-paypal-checkout-gateway-dependencies.php';
}
require_once 'includes/wcmp-paypal-checkout-gateway-core-functions.php';
require_once 'wcmp-paypal-checkout-gateway-config.php';

if (!defined('WCMP_PAYPAL_CHECKOUT_GATEWAY_PLUGIN_TOKEN')) {
    exit;
}
if (!defined('WCMP_PAYPAL_CHECKOUT_GATEWAY_TEXT_DOMAIN')) {
    exit;
}
require plugin_dir_path(__FILE__) . 'classes/class-wcmp-paypal-checkout-for-woocommerce.php';

if(!WCMP_Paypal_Checkout_Gateway_Dependencies::woocommerce_active_check()){
    add_action('admin_notices', 'woocommerce_inactive_notice');
}

if (!class_exists('WCMP_Paypal_Checkout_Gateway') && WCMP_Paypal_Checkout_Gateway_Dependencies::woocommerce_active_check()) {
    require_once( 'classes/class-wcmp-paypal-checkout-gateway.php' );
    global $WCMP_Paypal_Checkout_Gateway;
    $WCMP_Paypal_Checkout_Gateway = new WCMP_Paypal_Checkout_Gateway(__FILE__);
    $GLOBALS['WCMP_Paypal_Checkout_Gateway'] = $WCMP_Paypal_Checkout_Gateway;
}

function run_paypal_checkout_for_woocommerce() {
    $plugin = new Paypal_Checkout_For_Woocommerce();
    $plugin->run();
}

add_action('plugins_loaded', 'load_paypal_checkout_for_woocommerce', 11);

function load_paypal_checkout_for_woocommerce() {
    if (class_exists('WC_Payment_Gateway')) {
        run_paypal_checkout_for_woocommerce();
    }
}
